/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.prefs;

import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.prefs.BSColumn;
import org.eclipse.epf.library.prefs.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceUtil {
    private static Properties xslParams;
    private static Map colIdLabelMap;
    private static final String ID_STEPS = "steps";

    static {
        colIdLabelMap = new HashMap();
        try {
            xslParams = LibraryPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            colIdLabelMap.put("id", PreferenceUtil.getLabel("indexText"));
            colIdLabelMap.put("name", PreferenceUtil.getLabel("nameText"));
            colIdLabelMap.put("presentation_name", PreferenceUtil.getLabel("breakdownElementText"));
            colIdLabelMap.put(ID_STEPS, PreferenceUtil.getLabel("stepsText"));
            colIdLabelMap.put("prefix", PreferenceUtil.getLabel("prefixText"));
            colIdLabelMap.put("type", PreferenceUtil.getLabel("typeText"));
            colIdLabelMap.put("model_info", PreferenceUtil.getLabel("modelInfoText"));
            colIdLabelMap.put("predecessors", PreferenceUtil.getLabel("predecessorsText"));
            colIdLabelMap.put("is_repeatable", PreferenceUtil.getLabel("repeatableText"));
            colIdLabelMap.put("is_ongoing", PreferenceUtil.getLabel("ongoingText"));
            colIdLabelMap.put("is_event_driven", PreferenceUtil.getLabel("eventDrivenText"));
            colIdLabelMap.put("is_optional", PreferenceUtil.getLabel("optionalText"));
            colIdLabelMap.put("is_planned", PreferenceUtil.getLabel("plannedText"));
            colIdLabelMap.put("has_multiple_occurrences", PreferenceUtil.getLabel("multipleOccurrencesText"));
            colIdLabelMap.put("teams", PreferenceUtil.getLabel("teamText"));
            colIdLabelMap.put("deliverable", PreferenceUtil.getLabel("deliverableText"));
            colIdLabelMap.put("entry_state", PreferenceUtil.getLabel("entryStateText"));
            colIdLabelMap.put("exit_state", PreferenceUtil.getLabel("exitStateText"));
        }
        catch (IOException iOException) {}
    }

    private static String getLabel(String key) {
        String label = xslParams.getProperty(key);
        if (label == null) {
            System.out.println("Can't find property entry for " + key);
            label = key;
        }
        return label;
    }

    public static List getWBSColumns() {
        return PreferenceUtil.getPreferenceItems("org.eclipse.epf.library.edit.wbs_columns");
    }

    public static List getTBSColumns() {
        return PreferenceUtil.getPreferenceItems("org.eclipse.epf.library.edit.tbs_columns");
    }

    public static List getWPBSColumns() {
        return PreferenceUtil.getPreferenceItems("org.eclipse.epf.library.edit.wpbs_columns");
    }

    public static void validatePreferences() {
        PreferenceUtil.getWBSColumns();
        PreferenceUtil.getTBSColumns();
        PreferenceUtil.getWPBSColumns();
    }

    private static List getPreferenceItems(String key) {
        IPreferenceStore store = LibraryPlugin.getDefault().getPreferenceStore();
        String str = store.getString(key);
        if (str == null) {
            str = store.getDefaultString(key);
        }
        if (str == null || str.length() == 0) {
            str = PreferenceUtil.getDefault(key);
            store.setValue(key, str);
        }
        ArrayList<BSColumn> items = new ArrayList<BSColumn>();
        StringTokenizer tokens = new StringTokenizer(str, ",");
        while (tokens.hasMoreTokens()) {
            String id = tokens.nextToken().trim();
            if (id == null || id.length() == 0) continue;
            BSColumn col = new BSColumn(id, PreferenceUtil.getColText(id));
            items.add(col);
            if (!key.equals("org.eclipse.epf.library.edit.wbs_columns") || !id.equals("presentation_name")) continue;
            col = new BSColumn(ID_STEPS, PreferenceUtil.getColText(ID_STEPS));
            items.add(col);
        }
        return items;
    }

    private static String getColText(String key) {
        String text = (String)colIdLabelMap.get(key);
        if (text == null) {
            System.out.println("No label defined for column " + key);
            text = key;
        }
        return text;
    }

    private static String getDefault(String key) {
        if ("org.eclipse.epf.library.edit.wbs_columns".equals(key)) {
            return PreferenceUtil.toString(PreferenceConstants.DEFAULT_WBS_COLUMNS);
        }
        if ("org.eclipse.epf.library.edit.tbs_columns".equals(key)) {
            return PreferenceUtil.toString(PreferenceConstants.DEFAULT_TBS_COLUMNS);
        }
        if ("org.eclipse.epf.library.edit.wpbs_columns".equals(key)) {
            return PreferenceUtil.toString(PreferenceConstants.DEFAULT_WPBS_COLUMNS);
        }
        return null;
    }

    private static String toString(String[] ids) {
        StringBuffer strBuf = new StringBuffer();
        int max = ids.length - 1;
        int i = 0;
        while (i < max) {
            strBuf.append(ids[i]).append(',');
            ++i;
        }
        strBuf.append(ids[ids.length - 1]);
        return strBuf.toString();
    }
}

