/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.services;

import com.ibm.icu.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodUnit;

public class VersionManager {
    private ILibraryManager manager;
    private ILibraryServiceListener libSvcListener = null;
    private ILibraryChangeListener libListener = null;
    private boolean inProcessing = false;

    public VersionManager(ILibraryManager manager) {
        this.manager = manager;
        this.initialize();
    }

    private void initialize() {
        this.libSvcListener = new ILibraryServiceListener(){

            public void configurationSet(MethodConfiguration config) {
            }

            public void libraryClosed(MethodLibrary library) {
            }

            public void libraryCreated(MethodLibrary library) {
            }

            public void libraryOpened(MethodLibrary library) {
            }

            public void libraryReopened(MethodLibrary library) {
            }

            public void librarySet(MethodLibrary library) {
            }
        };
        LibraryService.getInstance().addListener(this.libSvcListener);
        this.libListener = new ILibraryChangeListener(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void libraryChanged(int option, Collection changedItems) {
                if (option != 8) {
                    if (option != 16) return;
                }
                if (VersionManager.this.inProcessing) return;
                if (changedItems == null) return;
                VersionManager.this.inProcessing = true;
                try {
                    VersionManager.this.processChanges(option, changedItems);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    VersionManager.this.inProcessing = false;
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                VersionManager.this.inProcessing = false;
            }
        };
        this.manager.addListener(this.libListener);
    }

    public void dispose() {
        LibraryService.getInstance().removeListener(this.libSvcListener);
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.removeListener(this.libListener);
        }
    }

    private void processChanges(int option, Collection changedItems) {
        if (changedItems == null || changedItems.size() == 0) {
            return;
        }
        Iterator it = changedItems.iterator();
        while (it.hasNext()) {
            MethodUnit pkg;
            MethodElement element = (MethodElement)it.next();
            if (element instanceof MethodUnit) {
                pkg = (MethodUnit)element;
                switch (option) {
                    case 8: {
                        this.updateVersion(pkg);
                        break;
                    }
                    case 32: {
                        this.updateVersion(pkg);
                        this.updateVersion((MethodUnit)pkg.eContainer());
                        break;
                    }
                    case 16: {
                        this.updateVersion((MethodUnit)pkg.eContainer());
                    }
                }
                continue;
            }
            if (element == null) continue;
            EObject parent = element.eContainer();
            while (parent != null && !(parent instanceof MethodUnit)) {
                parent = parent.eContainer();
            }
            if (parent == null) continue;
            pkg = (MethodUnit)parent;
            this.updateVersion(pkg);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateVersion(MethodUnit pkg) {
        if (pkg == null) {
            return;
        }
        Calendar c = Calendar.getInstance();
        int y = c.get(1);
        int m = c.get(2) + 1;
        int d = c.get(5);
        long t = c.getTimeInMillis();
        String baseVer = String.valueOf(Integer.toString(y)) + Integer.toString(m) + Integer.toString(d);
        String miniVer = Long.toHexString(t);
        boolean oldNotify = pkg.eDeliver();
        try {
            pkg.eSetDeliver(false);
            pkg.setVersion(String.valueOf(baseVer) + "." + miniVer);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            pkg.eSetDeliver(oldNotify);
            throw throwable;
        }
        {
            Object var11_12 = null;
        }
        pkg.eSetDeliver(oldNotify);
    }
}

