/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MoveInCategoryCommand;
import org.eclipse.epf.library.edit.util.ContentElementOrderList;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.VariabilityElementLabelProvider;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ContentElementsOrderDialog
extends Dialog {
    private Composite baseComposite;
    private Button ctrl_up;
    private Button ctrl_down;
    private Table ctrl_steps;
    private TableViewer stepsTableViewer;
    private ContentElementOrderList allSteps;
    private IStructuredContentProvider stepsViewerContentProvider;
    private ILabelProvider stepsViewerLabelProvider;
    private ContentElement contentElement;
    private IActionManager actionManager;
    private ArrayList commands = new ArrayList();

    public ContentElementsOrderDialog(Shell parent, ContentElement contentElement, IActionManager actionManager) {
        super(parent);
        this.contentElement = contentElement;
        this.actionManager = actionManager;
        this.allSteps = null;
    }

    protected Control createDialogArea(Composite parent) {
        this.baseComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.baseComposite.setLayout((Layout)gridLayout);
        this.baseComposite.setLayoutData((Object)new GridData());
        this.createLabel(this.baseComposite, " ", 4);
        this.createLabel(this.baseComposite, " ", 1);
        this.createLabel(this.baseComposite, AuthoringUIResources.ContentElementsOrderDialog_ContentElement_text, 3);
        this.createLabel(this.baseComposite, " ", 1);
        this.ctrl_steps = new Table(this.baseComposite, 2050);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        gridData.heightHint = 400;
        this.ctrl_steps.setLayoutData((Object)gridData);
        this.initProviders();
        this.stepsTableViewer = new TableViewer(this.ctrl_steps);
        this.stepsTableViewer.setContentProvider((IContentProvider)this.stepsViewerContentProvider);
        this.stepsTableViewer.setLabelProvider((IBaseLabelProvider)this.stepsViewerLabelProvider);
        Composite orderButtonPane = new Composite(this.baseComposite, 0);
        GridData gridData2 = new GridData(68);
        gridData2.horizontalSpan = 1;
        orderButtonPane.setLayoutData((Object)gridData2);
        orderButtonPane.setLayout((Layout)new GridLayout());
        this.ctrl_up = this.createButton(orderButtonPane, AuthoringUIText.UP_BUTTON_TEXT);
        this.ctrl_up.setLayoutData((Object)new GridData(768));
        this.ctrl_down = this.createButton(orderButtonPane, AuthoringUIText.DOWN_BUTTON_TEXT);
        this.ctrl_down.setLayoutData((Object)new GridData(768));
        this.ctrl_up.setEnabled(false);
        this.ctrl_down.setEnabled(false);
        this.createLabel(this.baseComposite, " ", 4);
        this.createLine(this.baseComposite, 4);
        super.getShell().setText(AuthoringUIResources.ContentElementsOrderDialog_description_text);
        this.addListeners();
        this.loadData();
        return this.baseComposite;
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private Label createLabel(Composite parent, String text, int nCol) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = nCol;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void initProviders() {
        this.stepsViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (ContentElementsOrderDialog.this.allSteps == null) {
                    ContentElementsOrderDialog.this.allSteps = new ContentElementOrderList(ContentElementsOrderDialog.this.contentElement, 2);
                }
                return ContentElementsOrderDialog.this.allSteps.toArray();
            }
        };
        this.stepsViewerLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public boolean isExternal(Object element) {
                return !((CustomCategory)ContentElementsOrderDialog.this.contentElement).getCategorizedElements().contains(element);
            }
        };
    }

    public void addListeners() {
        this.stepsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ContentElementsOrderDialog.this.stepsTableViewer.getSelection();
                if (selection.size() > 0 && !TngUtil.isLocked((EObject)ContentElementsOrderDialog.this.contentElement)) {
                    if (ContentElementsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)ContentElementsOrderDialog.this.contentElement) && selection.size() == 1) {
                        ContentElementsOrderDialog.this.ctrl_up.setEnabled(true);
                    } else {
                        ContentElementsOrderDialog.this.ctrl_up.setEnabled(false);
                    }
                    if (ContentElementsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() < ContentElementsOrderDialog.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)ContentElementsOrderDialog.this.contentElement) && selection.size() == 1) {
                        ContentElementsOrderDialog.this.ctrl_down.setEnabled(true);
                    } else {
                        ContentElementsOrderDialog.this.ctrl_down.setEnabled(false);
                    }
                }
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ContentElementsOrderDialog.this.stepsTableViewer.getSelection();
                ArrayList moveUpItems = new ArrayList();
                moveUpItems.addAll(selection.toList());
                EReference feature = UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
                MoveInCategoryCommand cmd = new MoveInCategoryCommand((ContentCategory)((CustomCategory)ContentElementsOrderDialog.this.contentElement), moveUpItems, (EStructuralFeature)feature, ModelStructure.DEFAULT.customCategoryPath, true, 1);
                ContentElementsOrderDialog.this.actionManager.execute((IResourceAwareCommand)cmd);
                ContentElementsOrderDialog.this.commands.add(cmd);
                ContentElementsOrderDialog.this.stepsTableViewer.refresh();
                if (ContentElementsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)ContentElementsOrderDialog.this.contentElement)) {
                    ContentElementsOrderDialog.this.ctrl_up.setEnabled(true);
                } else {
                    ContentElementsOrderDialog.this.ctrl_up.setEnabled(false);
                }
                if (ContentElementsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() < ContentElementsOrderDialog.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)ContentElementsOrderDialog.this.contentElement)) {
                    ContentElementsOrderDialog.this.ctrl_down.setEnabled(true);
                } else {
                    ContentElementsOrderDialog.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ContentElementsOrderDialog.this.stepsTableViewer.getSelection();
                ArrayList moveDownItems = new ArrayList();
                moveDownItems.addAll(selection.toList());
                EReference feature = UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
                MoveInCategoryCommand cmd = new MoveInCategoryCommand((ContentCategory)((CustomCategory)ContentElementsOrderDialog.this.contentElement), moveDownItems, (EStructuralFeature)feature, ModelStructure.DEFAULT.customCategoryPath, true, 0);
                ContentElementsOrderDialog.this.actionManager.execute((IResourceAwareCommand)cmd);
                ContentElementsOrderDialog.this.commands.add(cmd);
                ContentElementsOrderDialog.this.stepsTableViewer.refresh();
                if (ContentElementsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)ContentElementsOrderDialog.this.contentElement)) {
                    ContentElementsOrderDialog.this.ctrl_up.setEnabled(true);
                } else {
                    ContentElementsOrderDialog.this.ctrl_up.setEnabled(false);
                }
                if (ContentElementsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() < ContentElementsOrderDialog.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)ContentElementsOrderDialog.this.contentElement)) {
                    ContentElementsOrderDialog.this.ctrl_down.setEnabled(true);
                } else {
                    ContentElementsOrderDialog.this.ctrl_down.setEnabled(false);
                }
            }
        });
    }

    private void loadData() {
        this.stepsTableViewer.setInput((Object)this.contentElement);
    }

    protected void okPressed() {
        this.allSteps.apply();
        super.okPressed();
    }

    protected void cancelPressed() {
        if (!this.commands.isEmpty()) {
            int i = this.commands.size() - 1;
            while (i > -1) {
                Object cmd = this.commands.get(i);
                if (cmd instanceof MoveInCategoryCommand) {
                    ((MoveInCategoryCommand)cmd).undo();
                }
                --i;
            }
        }
        super.cancelPressed();
    }
}

