/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.authoring.ui.dialogs.ChangeHistoryDialog;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.util.ConvertGuidanceType;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class DescriptionFormPage
extends BaseFormPage
implements IRefreshable {
    protected static final String NOT_APPLICABLE_TEXT = AuthoringUIResources.notApplicable_text;
    protected static final String CONTRIBUTES_TEXT = AuthoringUIResources.contributes_text;
    private static final String LOCAL_CONTRIBUTES_TEXT = AuthoringUIResources.localContributes_text;
    protected static final String EXTENDS_TEXT = AuthoringUIResources.extends_text;
    protected static final String REPLACES_TEXT = AuthoringUIResources.replaces_text;
    protected static final String LOCAL_REPLACES_TEXT = AuthoringUIResources.localReplaces_text;
    protected static final ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngUtil.umaItemProviderAdapterFactory);
    protected Section formSection;
    protected Composite sectionComposite;
    protected Composite expandedComposite;
    protected Section generalSection;
    protected Section variabilitySection;
    protected Composite generalComposite;
    protected Composite variabilityComposite;
    protected Section versionSection;
    protected Composite versionComposite;
    protected Section iconSection;
    protected Composite iconComposite;
    private Canvas pane1;
    private Canvas pane3;
    protected Section detailSection;
    protected Composite detailComposite;
    protected Section notationSection;
    protected Composite notationComposite;
    protected Section tailoringSection;
    protected Composite tailoringComposite;
    protected Text ctrl_name;
    protected Text ctrl_presentation_name;
    protected Label ctrl_type_label;
    protected Button ctrl_type_button;
    protected Text ctrl_brief_desc;
    protected IMethodRichText ctrl_full_desc;
    protected IMethodRichText ctrl_key;
    protected IMethodRichTextEditor ctrl_expanded;
    protected ComboViewer viewer_variability;
    protected Combo ctrl_variability;
    protected Label label_base;
    protected TableViewer base_viewer;
    protected Table ctrl_base;
    protected Button ctrl_base_button;
    private IMethodRichText activeControl;
    private Text ctrl_authors;
    private Text ctrl_change_date;
    private Text ctrl_change_desc;
    private Button view_history_button;
    private Text ctrl_version;
    protected Label label_copyright;
    protected TableViewer copyright_viewer;
    protected Table ctrl_copyright;
    private Button copyright_button;
    private Button copyright_button_deselect;
    protected ImageHyperlink expandDetailLink;
    protected Label expandDetailLabel;
    protected ImageHyperlink expandNotationLink;
    protected Label expandNotationLabel;
    protected ImageHyperlink expandTailoringLink;
    protected Label expandTailoringLabel;
    protected IMethodRichText ctrl_purpose;
    protected Text ctrl_external_id;
    private Image shapeImage;
    private Image nodeImage;
    protected Button ctrl_select_shapeIcon_button;
    protected Button ctrl_clear_shapeIcon_button;
    protected Button ctrl_select_nodeIcon_button;
    protected Button ctrl_clear_nodeIcon_button;
    protected ImageHyperlink expandVersionLink;
    protected Label expandVersionLabel;
    protected ImageHyperlink expandLink;
    protected Label expandLabel;
    private String lastChangeHistory = "";
    protected IStructuredContentProvider contentProviderVariability;
    protected IStructuredContentProvider contentProviderBase;
    protected ILabelProvider labelProviderVariability = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            VariabilityType varObject = (VariabilityType)object;
            if (varObject == VariabilityType.NA_LITERAL) {
                return NOT_APPLICABLE_TEXT;
            }
            if (varObject == VariabilityType.CONTRIBUTES_LITERAL) {
                return CONTRIBUTES_TEXT;
            }
            if (varObject == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
                return LOCAL_CONTRIBUTES_TEXT;
            }
            if (varObject == VariabilityType.EXTENDS_LITERAL) {
                return EXTENDS_TEXT;
            }
            if (varObject == VariabilityType.REPLACES_LITERAL) {
                return REPLACES_TEXT;
            }
            if (varObject == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
                return LOCAL_REPLACES_TEXT;
            }
            return null;
        }
    };
    protected ILabelProvider labelProviderBase = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getColumnText(Object object, int columnIndex) {
            return TngUtil.getLabelWithPath((Object)object);
        }
    };
    protected IActionManager actionMgr;
    protected IStructuredContentProvider copyrightContentProvider;
    private ILabelProvider copyrightLabelProviderBase = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    protected ModifyListener modelModifyListener;
    protected ModifyListener contentModifyListener;
    protected boolean descExpandFlag = false;
    protected boolean generalSectionExpandFlag = false;
    protected boolean detailSectionExpandFlag = false;
    protected boolean notationSectionExpandFlag = false;
    protected boolean tailoringSectionExpandFlag = false;
    protected boolean versionSectionExpandFlag = false;
    protected boolean elementSectionExpandFlag = false;
    protected boolean iconSectionExpandFlag = false;
    protected boolean fullDescOn = true;
    protected boolean keyConsiderationOn = true;
    protected boolean briefDescOn = true;
    protected boolean elementTypeOn = false;
    protected boolean contentFieldOn = false;
    protected boolean versionSectionOn = true;
    protected boolean anyAttributeModified = false;
    protected boolean generalSectionOn = true;
    protected boolean notationSectionOn = false;
    protected boolean detailSectionOn = true;
    protected boolean tailoringSectionOn = false;
    protected boolean variabilitySectionOn = true;
    protected boolean purposeOn = false;
    protected boolean externalIdOn = false;
    protected boolean iconSectionOn = false;
    protected static final int GENERAL_SECTION_ID = 1;
    protected static final int DETAIL_SECTION_ID = 2;
    protected static final int VERSION_SECTION_ID = 3;
    protected static final int NOTATION_SECTION_ID = 4;
    protected static final int TAILORING_SECTION_ID = 5;
    private int warningCount = 1;
    private int SECTIONS = 0;
    private static int SHAPEICON_WIDTH_MAX = 32;
    private static int SHAPEICON_HEIGHT_MAX = 32;
    private static int NODEICON_WIDTH_MAX = 16;
    private static int NODEICON_HEIGHT_MAX = 16;
    protected IFilter filter;
    private boolean disposed;
    public String generalSectionDescription;
    public String detailSectionDescription;
    public String tailoringSectionDescription;
    public String notationSectionDescription;
    public String variabilitySectionDescription;
    public String iconSectionDescription;
    public String versionSectionDescription;
    static /* synthetic */ Class class$0;

    protected IFilter getFilter() {
        return this.filter;
    }

    protected Object getContentElement() {
        return null;
    }

    protected void initContentProviderBase() {
        this.contentProviderBase = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<VariabilityElement> base_selected_list = new ArrayList<VariabilityElement>();
                if (DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement() != null) {
                    base_selected_list.add(DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement());
                }
                return base_selected_list.toArray();
            }

            public void notifyChanged(Notification notification) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.epf.uma.VariabilityElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                switch (notification.getFeatureID((Class)clazz)) {
                    case 7: {
                        super.notifyChanged(notification);
                    }
                }
            }
        };
        this.base_viewer.setContentProvider((IContentProvider)this.contentProviderBase);
    }

    public DescriptionFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.contentProviderVariability = this.contentElement instanceof ContentCategory ? new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<VariabilityType> variabilityTypesList = new ArrayList<VariabilityType>();
                variabilityTypesList.add(VariabilityType.NA_LITERAL);
                variabilityTypesList.add(VariabilityType.CONTRIBUTES_LITERAL);
                variabilityTypesList.add(VariabilityType.REPLACES_LITERAL);
                return variabilityTypesList.toArray();
            }
        } : new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<VariabilityType> variabilityTypesList = new ArrayList<VariabilityType>();
                variabilityTypesList.add(VariabilityType.NA_LITERAL);
                variabilityTypesList.add(VariabilityType.CONTRIBUTES_LITERAL);
                variabilityTypesList.add(VariabilityType.EXTENDS_LITERAL);
                variabilityTypesList.add(VariabilityType.REPLACES_LITERAL);
                return variabilityTypesList.toArray();
            }
        };
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createEditorContent(this.toolkit);
        this.setContextHelp();
        this.setFormTextWithVariableInfo();
        this.loadData();
        this.addListeners();
    }

    private void setFormTextWithVariableInfo() {
        UIHelper.setFormText(this.form, (MethodElement)this.contentElement);
    }

    public String getLabel(VariabilityElement object, String alternativeLabel, boolean preferBase) {
        String label = TngUtil.getLabel((Object)object, (String)alternativeLabel);
        if (preferBase && object.getVariabilityBasedOnElement() != null) {
            VariabilityType type = object.getVariabilityType();
            String variabilityTxt = null;
            if (type == VariabilityType.CONTRIBUTES_LITERAL) {
                variabilityTxt = AuthoringUIResources.contributes_to_text;
            } else if (type == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
                variabilityTxt = AuthoringUIResources.localContributes_text;
            } else if (type == VariabilityType.EXTENDS_LITERAL) {
                variabilityTxt = AuthoringUIResources.extends_text;
            } else if (type == VariabilityType.REPLACES_LITERAL) {
                variabilityTxt = AuthoringUIResources.replaces_text;
            } else if (type == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
                variabilityTxt = AuthoringUIResources.localReplaces_text;
            }
            if (variabilityTxt != null) {
                StringBuffer strBuf = new StringBuffer(label).append(" (").append(variabilityTxt).append(" '").append(TngUtil.getLabel((Object)object.getVariabilityBasedOnElement(), (String)alternativeLabel)).append("'");
                MethodPlugin basePlugin = UmaUtil.getMethodPlugin((EObject)object.getVariabilityBasedOnElement());
                if (basePlugin != null) {
                    strBuf.append(" in '").append(basePlugin.getName()).append("')");
                }
                label = strBuf.toString();
            }
        }
        return label;
    }

    protected void createEditorContent(FormToolkit toolkit) {
        this.createFormComposites(toolkit);
        this.loadSectionDescription();
        if (this.generalSectionOn) {
            this.createGeneralSection(toolkit);
            ++this.SECTIONS;
        }
        if (this.detailSectionOn) {
            this.createDetailSection(toolkit);
            ++this.SECTIONS;
        }
        if (this.notationSectionOn) {
            this.createNotationSection(toolkit);
            ++this.SECTIONS;
        }
        if (this.tailoringSectionOn) {
            this.createTailoringSection(toolkit);
            ++this.SECTIONS;
        }
        if (this.versionSectionOn) {
            this.createVersionSection(toolkit);
            this.createVersionSectionContent();
            ++this.SECTIONS;
        }
        if (this.variabilitySectionOn) {
            this.createVariabilitySection(toolkit);
            ++this.SECTIONS;
        }
        if (this.iconSectionOn) {
            this.createIconSection(toolkit);
            this.createIconSectionContent();
            ++this.SECTIONS;
        }
        toolkit.paintBordersFor(this.variabilityComposite);
        toolkit.paintBordersFor(this.expandedComposite);
        toolkit.paintBordersFor(this.generalComposite);
        toolkit.paintBordersFor(this.versionComposite);
    }

    private void createFormComposites(FormToolkit toolkit) {
        this.formSection = toolkit.createSection(this.form.getBody(), 4096);
        TableWrapData td = new TableWrapData(256);
        this.formSection.setLayoutData((Object)td);
        this.formSection.setLayout((Layout)new TableWrapLayout());
        this.sectionComposite = toolkit.createComposite((Composite)this.formSection, 0);
        this.sectionComposite.setLayoutData((Object)new TableWrapData(256));
        this.sectionComposite.setLayout((Layout)new TableWrapLayout());
        this.formSection.setClient((Control)this.sectionComposite);
        this.expandedComposite = toolkit.createComposite((Composite)this.formSection, 0);
        td = new TableWrapData(256);
        this.expandedComposite.setLayoutData((Object)td);
        this.expandedComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedComposite.setVisible(false);
        this.expandLink = toolkit.createImageHyperlink(this.expandedComposite, 0);
        this.expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandLink.setToolTipText(AuthoringUIResources.closeRTE);
        this.expandLink.setUnderlined(false);
        this.expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DescriptionFormPage.this.toggle(e);
            }
        });
        this.expandLabel = DescriptionFormPage.createLabel(toolkit, this.expandedComposite, "");
    }

    protected void createGeneralSection(FormToolkit toolkit) {
        this.generalSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.GENERAL_INFO_SECTION_NAME, this.getGeneralSectionDescription());
        this.generalComposite = this.createComposite(toolkit, this.generalSection);
        ((GridLayout)this.generalComposite.getLayout()).numColumns = 4;
        this.createGeneralSectionContent();
    }

    private void createGeneralSectionContent() {
        this.ctrl_name = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.NAME_TEXT, -1, 4);
        this.ctrl_presentation_name = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.PRESENTATION_NAME_TEXT, -1, 4);
        if (this.elementTypeOn) {
            DescriptionFormPage.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.TYPE_TEXT, 2);
            this.ctrl_type_label = DescriptionFormPage.createLabel(this.toolkit, this.generalComposite, "");
            GridData gridData = new GridData(1);
            gridData.horizontalSpan = 1;
            this.ctrl_type_label.setBackground(Display.getCurrent().getSystemColor(19));
            this.ctrl_type_label.setLayoutData((Object)gridData);
            if (this.contentElement instanceof Guidance) {
                this.ctrl_type_button = this.toolkit.createButton(this.generalComposite, AuthoringUIText.CHANGE_TYPE_BUTTON_TEXT, 8);
                gridData = new GridData(1);
                gridData.horizontalSpan = 1;
                this.ctrl_type_button.setLayoutData((Object)gridData);
                if (ConvertGuidanceType.getValidNewGuidanceTypes((Guidance)((Guidance)this.contentElement)) == null) {
                    this.ctrl_type_button.setVisible(false);
                }
            }
        }
        if (this.externalIdOn) {
            this.ctrl_external_id = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.UNIQUE_ID_TEXT, -1, 4);
        }
        if (this.briefDescOn) {
            this.ctrl_brief_desc = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT, 40, 18);
        }
    }

    protected void createVariabilitySection(FormToolkit toolkit) {
        this.variabilitySection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.VARIABILITY_SECTION_NAME, this.getVariabilitySectionDescription());
        this.variabilityComposite = this.createComposite(toolkit, this.variabilitySection);
        this.ctrl_variability = this.createComboWithLabel(toolkit, this.variabilityComposite, AuthoringUIText.VARIABILITY_TYPE_TEXT);
        this.viewer_variability = new ComboViewer(this.ctrl_variability);
        this.viewer_variability.getCombo().setLayoutData((Object)new GridData(1));
        this.viewer_variability.setContentProvider((IContentProvider)this.contentProviderVariability);
        this.viewer_variability.setLabelProvider((IBaseLabelProvider)this.labelProviderVariability);
        this.viewer_variability.setInput((Object)this.contentElement);
        toolkit.createLabel(this.variabilityComposite, "", 0);
        this.label_base = DescriptionFormPage.createLabel(toolkit, this.variabilityComposite, AuthoringUIText.BASE_ELEMENT_TEXT);
        this.ctrl_base = DescriptionFormPage.createTable(toolkit, this.variabilityComposite, 12, 768, 5, 300, 1, 1);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.heightHint = 24;
        this.ctrl_base.setLayoutData((Object)gridData);
        this.base_viewer = new TableViewer(this.ctrl_base);
        this.initContentProviderBase();
        this.base_viewer.setLabelProvider((IBaseLabelProvider)this.labelProviderBase);
        this.base_viewer.setInput((Object)this.contentElement);
        this.ctrl_base_button = toolkit.createButton(this.variabilityComposite, AuthoringUIText.SELECT_BUTTON_TEXT, 64);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (DescriptionFormPage.this.ctrl_name.isDisposed()) {
                        return;
                    }
                    DescriptionFormPage.this.ctrl_name.setFocus();
                    ContentDescription contentDescription = DescriptionFormPage.this.contentElement.getPresentation();
                    if (contentDescription.getChangeDate() == null) {
                        DescriptionFormPage.this.ctrl_name.setSelection(0, DescriptionFormPage.this.ctrl_name.getText().length());
                    }
                }
            });
        }
    }

    protected void refresh(boolean editable) {
        this.ctrl_name.setEditable(editable);
        this.ctrl_presentation_name.setEditable(editable);
        if (this.briefDescOn) {
            this.ctrl_brief_desc.setEditable(editable);
        }
        if (this.purposeOn) {
            this.ctrl_purpose.setEditable(editable);
        }
        if (this.fullDescOn) {
            this.ctrl_full_desc.setEditable(editable);
        }
        if (this.keyConsiderationOn) {
            this.ctrl_key.setEditable(editable);
        }
        if (this.externalIdOn) {
            this.ctrl_external_id.setEditable(editable);
        }
        if (this.elementTypeOn) {
            this.ctrl_type_button.setEnabled(editable);
        }
        if (this.variabilitySectionOn) {
            this.ctrl_variability.setEnabled(editable);
            this.ctrl_base_button.setEnabled(editable);
            if (((IStructuredSelection)this.viewer_variability.getSelection()).getFirstElement() == VariabilityType.NA_LITERAL) {
                this.ctrl_base_button.setEnabled(false);
            }
        }
        if (this.versionSectionOn) {
            this.ctrl_change_date.setEditable(false);
            this.ctrl_change_desc.setEditable(editable);
            this.ctrl_authors.setEditable(editable);
            this.ctrl_version.setEditable(editable);
            this.copyright_button.setEnabled(editable);
            this.setCopyrightButtonDeselect();
        }
        if (this.iconSectionOn) {
            this.ctrl_select_shapeIcon_button.setEnabled(editable);
            this.ctrl_clear_shapeIcon_button.setEnabled(editable && this.contentElement.getShapeicon() != null);
            this.ctrl_select_nodeIcon_button.setEnabled(editable);
            this.ctrl_clear_nodeIcon_button.setEnabled(editable && this.contentElement.getNodeicon() != null);
        }
        if (this.ctrl_expanded != null) {
            this.ctrl_expanded.setEditable(editable);
        }
    }

    protected void createDetailSection(FormToolkit toolkit) {
        this.detailSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.DETAIL_SECTION_NAME, this.getDetailSectionDescription());
        this.detailComposite = this.createComposite(toolkit, this.detailSection);
        this.createDetailSectionContent();
        toolkit.paintBordersFor(this.detailComposite);
    }

    private void createDetailSectionContent() {
        if (this.purposeOn) {
            this.ctrl_purpose = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.PURPOSE_TEXT, 40, 400, 2);
        }
        if (this.fullDescOn) {
            this.ctrl_full_desc = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.MAIN_DESCRIPTION_TEXT, 100, 400, 2);
        }
        if (this.keyConsiderationOn) {
            this.ctrl_key = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.KEY_CONSIDERATIONS_TEXT, 40, 400, 2);
        }
    }

    protected void createNotationSection(FormToolkit toolkit) {
        this.notationSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.NOTATION_SECTION_NAME, this.getNotationSectionDescription());
        this.notationComposite = this.createComposite(toolkit, this.notationSection);
        this.createNotationSectionContent();
        toolkit.paintBordersFor(this.notationComposite);
    }

    protected void createNotationSectionContent() {
    }

    protected void createTailoringSection(FormToolkit toolkit) {
        this.tailoringSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.TAILORING_SECTION_NAME, this.getTailoringSectionDescription());
        this.tailoringComposite = this.createComposite(toolkit, this.tailoringSection);
        this.createTailoringSectionContent();
        toolkit.paintBordersFor(this.tailoringComposite);
    }

    protected void createTailoringSectionContent() {
    }

    protected void addListeners() {
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.modelModifyListener = editor.createModifyListener((EObject)this.contentElement);
        this.contentModifyListener = editor.createModifyListener((EObject)this.contentElement.getPresentation());
        this.actionMgr = editor.getActionManager();
        this.form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (DescriptionFormPage.this.ctrl_expanded != null) {
                    ((GridData)DescriptionFormPage.this.ctrl_expanded.getLayoutData()).heightHint = DescriptionFormPage.this.getRichTextEditorHeight();
                    ((GridData)DescriptionFormPage.this.ctrl_expanded.getLayoutData()).widthHint = DescriptionFormPage.this.getRichTextEditorWidth();
                }
                DescriptionFormPage.this.formSection.layout(true, true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.form.getParent().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (DescriptionFormPage.this.disposed) {
                    return;
                }
                DescriptionFormPage.this.refresh(!TngUtil.isLocked((EObject)DescriptionFormPage.this.contentElement));
                DescriptionFormPage.this.setFormTextWithVariableInfo();
                if (DescriptionFormPage.this.variabilitySectionOn) {
                    DescriptionFormPage.this.base_viewer.refresh();
                }
                if (DescriptionFormPage.this.versionSectionOn) {
                    DescriptionFormPage.this.copyright_viewer.refresh();
                }
            }
        });
        if (this.generalSectionOn) {
            this.addGeneralSectionListeners();
        }
        if (this.detailSectionOn) {
            this.addDetailSectionListeners();
        }
        if (this.versionSectionOn) {
            this.addVersionSectionListeners();
        }
        if (this.iconSectionOn) {
            this.addIconSectionListeners();
        }
        this.viewer_variability.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean status;
                IStructuredSelection selection = (IStructuredSelection)DescriptionFormPage.this.viewer_variability.getSelection();
                if (DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement() != null && !(status = editor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)((VariabilityType)selection.getFirstElement()), -1))) {
                    return;
                }
                if (selection.getFirstElement() == VariabilityType.NA_LITERAL) {
                    if (DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement() != null && !(status = editor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement(), null, -1))) {
                        return;
                    }
                    DescriptionFormPage.this.ctrl_base_button.setEnabled(false);
                    DescriptionFormPage.this.base_viewer.refresh();
                } else {
                    ArrayList<VariabilityElement> selectionBaseList = new ArrayList<VariabilityElement>();
                    VariabilityElement base = DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement();
                    selectionBaseList.add(base);
                    DescriptionFormPage.this.ctrl_base_button.setEnabled(true);
                    DescriptionFormPage.this.base_viewer.refresh();
                }
                DescriptionFormPage.this.setFormTextWithVariableInfo();
            }
        });
        this.ctrl_base_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DescriptionFormPage.this.filter = DescriptionFormPage.this.getFilter();
                if (DescriptionFormPage.this.filter != null) {
                    ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), DescriptionFormPage.this.filter, DescriptionFormPage.this.getContentElement(), LibraryUIText.getUIText((MethodElement)DescriptionFormPage.this.contentElement, (boolean)true));
                    fd.setViewerSelectionSingle(true);
                    fd.setBlockOnOpen(true);
                    fd.setTitle(LibraryUIText.getUIText((MethodElement)DescriptionFormPage.this.contentElement, (boolean)true));
                    fd.open();
                    fd.getSelectedItems();
                    if (fd.getSelectedItems().size() > 0) {
                        boolean status = editor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement(), (Object)((VariabilityElement)fd.getSelectedItems().get(0)), -1);
                        if (!status) {
                            return;
                        }
                        boolean bl = editor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)((VariabilityType)((IStructuredSelection)DescriptionFormPage.this.viewer_variability.getSelection()).getFirstElement()), -1);
                    }
                }
                DescriptionFormPage.this.setFormTextWithVariableInfo();
                if (DescriptionFormPage.this.ctrl_base != null && !DescriptionFormPage.this.ctrl_base.isDisposed()) {
                    DescriptionFormPage.this.ctrl_base.redraw();
                }
                if (DescriptionFormPage.this.base_viewer != null && !DescriptionFormPage.this.base_viewer.getControl().isDisposed()) {
                    DescriptionFormPage.this.base_viewer.refresh();
                }
            }
        });
    }

    private void addGeneralSectionListeners() {
        this.ctrl_name.addModifyListener(this.modelModifyListener);
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }

            public void focusLost(FocusEvent e) {
                String name = DescriptionFormPage.this.ctrl_name.getText().trim();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, DescriptionFormPage.this.contentElement.getName())) {
                    return;
                }
                if (name.equals(DescriptionFormPage.this.contentElement.getName())) {
                    return;
                }
                IValidator validator = IValidatorFactory.INSTANCE.createNameValidator((NamedElement)DescriptionFormPage.this.contentElement, (AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
                String msg = validator.isValid(name);
                if (msg == null) {
                    name = StrUtil.makeValidFileName((String)DescriptionFormPage.this.ctrl_name.getText());
                    if (!name.equals(DescriptionFormPage.this.contentElement.getName())) {
                        Resource contentResource;
                        boolean success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)name, -1);
                        if (!success) {
                            return;
                        }
                        if (ContentDescriptionFactory.hasPresentation((MethodElement)DescriptionFormPage.this.contentElement) && (contentResource = DescriptionFormPage.this.contentElement.getPresentation().eResource()) != null) {
                            ((MethodElementEditor)DescriptionFormPage.this.getEditor()).addResourceToAdjustLocation(contentResource);
                        }
                        DescriptionFormPage.this.setFormTextWithVariableInfo();
                        DescriptionFormPage.this.ctrl_name.setText(name);
                    }
                } else {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameError_title, msg);
                    DescriptionFormPage.this.ctrl_name.setText(DescriptionFormPage.this.contentElement.getName());
                    DescriptionFormPage.this.ctrl_name.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            12.access$0(this.this$1).ctrl_name.setFocus();
                            12.access$0(this.this$1).ctrl_name.selectAll();
                        }
                    });
                }
            }

            static /* synthetic */ DescriptionFormPage access$0(12 var0) {
                return var0.DescriptionFormPage.this;
            }
        });
        this.ctrl_presentation_name.addModifyListener(this.modelModifyListener);
        this.ctrl_presentation_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                boolean success;
                String oldContent = DescriptionFormPage.this.contentElement.getPresentationName();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_presentation_name.getText());
                if (!newContent.equals(oldContent) && (success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), (Object)newContent, -1))) {
                    DescriptionFormPage.this.ctrl_presentation_name.setText(newContent);
                }
            }

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName());
            }
        });
        if (this.briefDescOn) {
            this.ctrl_brief_desc.addModifyListener(this.modelModifyListener);
            this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
                }

                public void focusLost(FocusEvent e) {
                    boolean success;
                    String oldContent = DescriptionFormPage.this.contentElement.getBriefDescription();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                        return;
                    }
                    String newContent = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_brief_desc.getText());
                    if (!newContent.equals(oldContent) && (success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)newContent, -1))) {
                        DescriptionFormPage.this.ctrl_brief_desc.setText(newContent);
                    }
                }
            });
        }
        if (this.elementTypeOn && this.contentElement instanceof Guidance) {
            this.ctrl_type_button.addListener(13, new Listener(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void handleEvent(Event event) {
                    Guidance newGuidance;
                    MethodElementEditor editor = (MethodElementEditor)DescriptionFormPage.this.getEditor();
                    if (editor.isDirty()) {
                        String title = AuthoringUIResources.descriptionTabGuidanceWarningDialog_title;
                        String message = AuthoringUIResources.descriptionTabGuidanceWarningDialog_message1;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(title, message);
                        return;
                    }
                    if (!(DescriptionFormPage.this.contentElement instanceof Guidance)) {
                        if (!editor.isDirty()) return;
                        String title = AuthoringUIResources.descriptionTabGuidanceWarningDialog_title;
                        String message = AuthoringUIResources.descriptionTabGuidanceWarningDialog_message2;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(title, message);
                        return;
                    }
                    MethodElementDeleteAction deleteAction = new MethodElementDeleteAction();
                    deleteAction.setEditingDomain(LibraryView.getView().getEditingDomain());
                    deleteAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)DescriptionFormPage.this.contentElement));
                    Command cmd = deleteAction.createCommand(Collections.singleton(DescriptionFormPage.this.contentElement));
                    if (!(cmd instanceof DeleteMethodElementCommand)) return;
                    try {
                        newGuidance = ConvertGuidanceType.convertGuidance((Guidance)((Guidance)DescriptionFormPage.this.contentElement), null, (DeleteMethodElementCommand)((DeleteMethodElementCommand)cmd));
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        try {
                            cmd.dispose();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    {
                        Object var6_12 = null;
                    }
                    try {}
                    catch (Exception exception) {}
                    cmd.dispose();
                    if (newGuidance == null) return;
                    EditorChooser.getInstance().closeEditor(DescriptionFormPage.this.contentElement);
                    EditorChooser.getInstance().openEditor(newGuidance);
                }
            });
        }
    }

    private void addDetailSectionListeners() {
        if (this.fullDescOn) {
            this.ctrl_full_desc.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_full_desc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription());
            this.ctrl_full_desc.addModifyListener(this.contentModifyListener);
            this.ctrl_full_desc.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = DescriptionFormPage.this.descExpandFlag ? DescriptionFormPage.this.ctrl_expanded : DescriptionFormPage.this.ctrl_full_desc;
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: control=" + control);
                    }
                    if (!control.getModified()) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: content not modified, exit");
                        }
                        return;
                    }
                    String oldContent = DescriptionFormPage.this.contentElement.getPresentation().getMainDescription();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: restored old content, exit");
                        }
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent)) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: saving modified content");
                        }
                        boolean success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), (Object)newContent, -1);
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: saved status=" + success);
                        }
                        if (success && DescriptionFormPage.this.isVersionSectionOn()) {
                            DescriptionFormPage.this.updateChangeDate();
                        }
                    }
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: exit");
                    }
                }
            });
        }
        if (this.keyConsiderationOn) {
            this.ctrl_key.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_key.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations());
            this.ctrl_key.addModifyListener(this.contentModifyListener);
            this.ctrl_key.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = DescriptionFormPage.this.descExpandFlag ? DescriptionFormPage.this.ctrl_expanded : DescriptionFormPage.this.ctrl_key;
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: control=" + control);
                    }
                    if (!control.getModified()) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: content not modified, exit");
                        }
                        return;
                    }
                    String oldContent = DescriptionFormPage.this.contentElement.getPresentation().getKeyConsiderations();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: restored old content, exit");
                        }
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent)) {
                        boolean success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations(), (Object)newContent, -1);
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: saved status=" + success);
                        }
                        if (success && DescriptionFormPage.this.isVersionSectionOn()) {
                            DescriptionFormPage.this.updateChangeDate();
                        }
                    }
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: exit");
                    }
                }
            });
        }
    }

    protected void loadData() {
        if (this.generalSectionOn) {
            this.loadGeneralSectionData();
        }
        if (this.detailSectionOn) {
            this.loadDetailSectionData();
        }
        if (this.notationSectionOn) {
            this.loadNotationSectionData();
        }
        if (this.tailoringSectionOn) {
            this.loadTailoringSectionData();
        }
        if (this.versionSectionOn) {
            this.loadVersionSectionData();
        }
        if (this.iconSectionOn) {
            this.loadIconSectionData();
        }
        if (this.variabilitySectionOn) {
            this.variabilitySectionData();
        }
        this.form.getBody().layout(true, true);
    }

    private void loadGeneralSectionData() {
        String name = this.contentElement.getName();
        String presentationName = this.contentElement.getPresentationName();
        this.ctrl_name.setText(name == null ? "" : name);
        this.ctrl_presentation_name.setText(presentationName == null ? "" : presentationName);
        if (this.elementTypeOn) {
            String type = LibraryUIText.getUIText((MethodElement)this.contentElement);
            this.ctrl_type_label.setText(type == null ? "" : type);
        }
        if (this.briefDescOn) {
            String brief_desc = this.contentElement.getBriefDescription();
            this.ctrl_brief_desc.setText(brief_desc == null ? "" : brief_desc);
        }
    }

    private void loadDetailSectionData() {
        if (this.fullDescOn) {
            String full_desc = this.contentElement.getPresentation().getMainDescription();
            this.ctrl_full_desc.setText(full_desc == null ? "" : full_desc);
        }
        if (this.keyConsiderationOn) {
            String keyConsiderations = this.contentElement.getPresentation().getKeyConsiderations();
            this.ctrl_key.setText(keyConsiderations == null ? "" : keyConsiderations);
        }
    }

    private void loadTailoringSectionData() {
    }

    private void loadNotationSectionData() {
    }

    private void variabilitySectionData() {
        VariabilityType variabilityType = this.contentElement.getVariabilityType();
        ArrayList<VariabilityType> selectionVariabilityList = new ArrayList<VariabilityType>();
        selectionVariabilityList.add(variabilityType);
        StructuredSelection newVariabilitySelection = new StructuredSelection(selectionVariabilityList);
        this.viewer_variability.setSelection((ISelection)newVariabilitySelection, true);
    }

    protected void toggle(HyperlinkEvent e) {
        if (this.ctrl_expanded == null) {
            this.ctrl_expanded = this.createRichTextEditor(this.toolkit, this.expandedComposite, 578, 1808, this.getRichTextEditorHeight(), this.getRichTextEditorWidth(), 2);
            this.ctrl_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.expandedComposite.setVisible(false);
            this.sectionComposite.setVisible(true);
            this.formSection.setClient((Control)this.sectionComposite);
            this.enableSections(true);
            IMethodRichText richText = this.getActiveRichTextControl();
            richText.setText(this.ctrl_expanded.getText());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.removeListener(listener.getEventType(), listener.getListener());
            }
            if (this.ctrl_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_expanded);
            }
            richText.setFocus();
        } else {
            this.sectionComposite.setVisible(false);
            this.expandedComposite.setVisible(true);
            this.formSection.setClient((Control)this.expandedComposite);
            this.enableSections(false);
            this.expandLabel.setText((String)((ImageHyperlink)e.getSource()).getData("Title"));
            IMethodRichText richText = (IMethodRichText)e.getHref();
            this.ctrl_expanded.setText(richText.getText());
            this.ctrl_expanded.setModalObject(richText.getModalObject());
            this.ctrl_expanded.setModalObjectFeature(richText.getModalObjectFeature());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.addListener(listener.getEventType(), listener.getListener());
            }
            boolean editable = !TngUtil.isLocked((EObject)this.contentElement);
            this.ctrl_expanded.setEditable(editable);
            if (editable) {
                this.ctrl_expanded.setFocus();
            }
            this.setActiveRichTextControl(richText);
        }
        this.form.getBody().layout(true, true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private void setActiveRichTextControl(IMethodRichText ctrl) {
        this.activeControl = ctrl;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    public void setBriefDescOn(boolean briefDescOn) {
        this.briefDescOn = briefDescOn;
    }

    public void setFullDescOn(boolean fullDescOn) {
        this.fullDescOn = fullDescOn;
    }

    public void setKeyConsiderationOn(boolean keyConsiderationOn) {
        this.keyConsiderationOn = keyConsiderationOn;
    }

    public void setElementTypeOn(boolean elementTypeOn) {
        this.elementTypeOn = elementTypeOn;
    }

    public boolean isAnyAttributeModified() {
        return this.anyAttributeModified;
    }

    public void setAnyAttributeModified(boolean anyAttributeModified) {
        this.anyAttributeModified = anyAttributeModified;
    }

    public boolean isVersionSectionOn() {
        return this.versionSectionOn;
    }

    public void setVersionSectionOn(boolean versionSectionOn) {
        this.versionSectionOn = versionSectionOn;
    }

    private void createVersionSection(FormToolkit toolkit) {
        this.versionSection = toolkit.createSection(this.sectionComposite, 450);
        TableWrapData td = new TableWrapData(256);
        this.versionSection.setLayoutData((Object)td);
        this.versionSection.setText(AuthoringUIText.VERSION_INFO_SECTION_NAME);
        this.versionSection.setDescription(this.getVersionSectionDescription());
        this.versionSection.setLayout((Layout)new GridLayout());
        this.versionComposite = toolkit.createComposite((Composite)this.versionSection);
        this.versionComposite.setLayoutData((Object)new GridData(768));
        this.versionComposite.setLayout((Layout)new GridLayout(4, false));
        this.versionSection.setClient((Control)this.versionComposite);
    }

    private void createVersionSectionContent() {
        this.ctrl_version = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.versionComposite, AuthoringUIText.VERSION_TEXT, -1, 4);
        this.ctrl_change_date = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DATE_TEXT, -1, 4);
        this.ctrl_change_date.setEditable(false);
        this.ctrl_change_desc = DescriptionFormPage.createTextEditWithLabel2(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DESCRIPTION_TEXT);
        GridData gridData = new GridData(769);
        gridData.heightHint = 40;
        gridData.widthHint = 300;
        this.ctrl_change_desc.setLayoutData((Object)gridData);
        Composite viewHistoryButtonPane = DescriptionFormPage.createComposite(this.toolkit, this.versionComposite, 128, 1, 1, 2);
        GridData gridData2 = new GridData(128);
        viewHistoryButtonPane.setLayoutData((Object)gridData2);
        this.view_history_button = this.toolkit.createButton(viewHistoryButtonPane, AuthoringUIText.VIEW_HISTORY_BUTTON_TEXT, 8);
        this.ctrl_authors = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.versionComposite, AuthoringUIText.AUTHORS_TEXT, 40, 2);
        this.label_copyright = DescriptionFormPage.createLabel(this.toolkit, this.versionComposite, AuthoringUIText.COPYRIGHT_TEXT, 2);
        this.ctrl_copyright = DescriptionFormPage.createTable(this.toolkit, this.versionComposite, 12, 769, 5, 400, 1, 1);
        gridData2 = new GridData(769);
        gridData2.heightHint = 24;
        this.ctrl_copyright.setLayoutData((Object)gridData2);
        this.copyright_viewer = new TableViewer(this.ctrl_copyright);
        this.initContentProviderCopyright();
        this.copyright_viewer.setLabelProvider((IBaseLabelProvider)this.copyrightLabelProviderBase);
        this.copyright_viewer.setInput((Object)this.contentElement);
        Composite buttonpane = DescriptionFormPage.createComposite(this.toolkit, this.versionComposite, 128, 1, 1, 2);
        GridData gridData3 = new GridData(128);
        buttonpane.setLayoutData((Object)gridData3);
        this.copyright_button = this.toolkit.createButton(buttonpane, AuthoringUIText.SELECT_BUTTON_TEXT, 64);
        this.copyright_button_deselect = this.toolkit.createButton(buttonpane, AuthoringUIText.DESELECT_BUTTON_TEXT, 64);
        this.setCopyrightButtonDeselect();
        this.toolkit.paintBordersFor(this.versionComposite);
        this.toolkit.paintBordersFor(viewHistoryButtonPane);
    }

    private void initContentProviderCopyright() {
        this.copyrightContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<SupportingMaterial> list = new ArrayList<SupportingMaterial>();
                if (DescriptionFormPage.this.contentElement.getPresentation().getCopyrightStatement() != null) {
                    list.add(DescriptionFormPage.this.contentElement.getPresentation().getCopyrightStatement());
                }
                return list.toArray();
            }

            public void notifyChanged(Notification notification) {
            }
        };
        this.copyright_viewer.setContentProvider((IContentProvider)this.copyrightContentProvider);
    }

    protected void addVersionSectionListeners() {
        this.ctrl_version.addModifyListener(this.contentModifyListener);
        this.ctrl_version.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Version());
            }

            public void focusLost(FocusEvent e) {
                boolean status;
                String oldContent = DescriptionFormPage.this.contentElement.getPresentation().getVersion();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_version.getText());
                if (!newContent.equals(oldContent) && (status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Version(), (Object)newContent, -1))) {
                    DescriptionFormPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_authors.addModifyListener(this.contentModifyListener);
        this.ctrl_authors.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Authors());
            }

            public void focusLost(FocusEvent e) {
                boolean status;
                String oldContent = DescriptionFormPage.this.contentElement.getPresentation().getAuthors();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_authors.getText());
                if (!newContent.equals(oldContent) && (status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Authors(), (Object)newContent, -1))) {
                    DescriptionFormPage.this.updateChangeDate();
                }
            }
        });
        this.copyright_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean status;
                TableItem item;
                ContentFilter filter = new ContentFilter(this){
                    final /* synthetic */ 22 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected boolean childAccept(Object obj) {
                        if (obj instanceof Guidance) {
                            return obj instanceof SupportingMaterial;
                        }
                        return false;
                    }
                };
                ArrayList<Object> alreadyExsting = new ArrayList<Object>();
                if (DescriptionFormPage.this.ctrl_copyright.getItemCount() > 0 && (item = DescriptionFormPage.this.ctrl_copyright.getItems()[0]).getData() != null) {
                    alreadyExsting.add(item.getData());
                }
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, DescriptionFormPage.this.contentElement, FilterConstants.SUPPORTING_MATERIALS, alreadyExsting);
                fd.setViewerSelectionSingle(true);
                fd.setBlockOnOpen(true);
                fd.setTitle(FilterConstants.SUPPORTING_MATERIALS);
                fd.open();
                fd.getSelectedItems();
                if (fd.getSelectedItems().size() > 0 && !(status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), (Object)((SupportingMaterial)fd.getSelectedItems().get(0)), -1))) {
                    return;
                }
                DescriptionFormPage.this.copyright_viewer.refresh();
                DescriptionFormPage.this.setCopyrightButtonDeselect();
            }
        });
        this.ctrl_change_desc.addModifyListener(this.contentModifyListener);
        this.ctrl_change_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDescription());
            }

            public void focusLost(FocusEvent e) {
                String oldContent = DescriptionFormPage.this.contentElement.getPresentation().getChangeDescription();
                char delimiter = AuthoringUIResources.ChangeHistoryDialog_delimiter.charAt(0);
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = DescriptionFormPage.this.ctrl_change_desc.getText();
                if (!(newContent = newContent.replace(delimiter, ' ')).equals(DescriptionFormPage.this.lastChangeHistory)) {
                    DescriptionFormPage.this.lastChangeHistory = newContent;
                    if (oldContent != null && !StrUtil.isBlank((String)oldContent)) {
                        newContent = String.valueOf(oldContent) + delimiter + newContent;
                    }
                    DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDescription(), (Object)newContent, -1);
                }
            }
        });
        this.view_history_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeHistoryDialog dlg = new ChangeHistoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (MethodElement)DescriptionFormPage.this.contentElement);
                dlg.open();
            }
        });
        this.copyright_button_deselect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), null, -1);
                if (status) {
                    DescriptionFormPage.this.copyright_viewer.refresh();
                    DescriptionFormPage.this.setCopyrightButtonDeselect();
                }
            }
        });
    }

    protected void updateChangeDate() {
        Date currentDate;
        String newContent;
        Date changeDate = this.contentElement.getPresentation().getChangeDate();
        DateFormat df = DateFormat.getDateInstance((int)0);
        String oldContent = "";
        if (changeDate != null) {
            oldContent = df.format(changeDate);
        }
        if (!(newContent = df.format(currentDate = new Date())).equals(oldContent)) {
            boolean status = this.actionMgr.doAction(1, (EObject)this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDate(), (Object)currentDate, -1);
            if (!status) {
                return;
            }
            this.ctrl_change_date.setText(newContent);
        }
    }

    protected void loadVersionSectionData() {
        ContentDescription contentDescription = this.contentElement.getPresentation();
        this.ctrl_version.setText(contentDescription.getVersion() == null ? "" : contentDescription.getVersion());
        this.ctrl_authors.setText(contentDescription.getAuthors() == null ? "" : contentDescription.getAuthors());
        this.ctrl_change_desc.setText("");
        this.ctrl_change_date.setText(contentDescription.getChangeDate() == null ? "" : DateFormat.getDateInstance((int)0).format(contentDescription.getChangeDate()));
    }

    protected void toggle(HyperlinkEvent e, int id) {
        this.toggle(e);
    }

    public boolean isIconSectionOn() {
        return this.iconSectionOn;
    }

    public void setIconSectionOn(boolean iconSectionOn) {
        this.iconSectionOn = iconSectionOn;
    }

    protected void createIconSection(FormToolkit toolkit) {
        this.iconSection = toolkit.createSection(this.sectionComposite, 450);
        TableWrapData td = new TableWrapData(256);
        this.iconSection.setLayoutData((Object)td);
        this.iconSection.setText(AuthoringUIText.ICON_SECTION_NAME);
        this.iconSection.setDescription(this.getIconSectionDescription());
        this.iconSection.setLayout((Layout)new GridLayout());
        this.iconComposite = toolkit.createComposite((Composite)this.iconSection);
        this.iconComposite.setLayoutData((Object)new GridData(768));
        this.iconComposite.setLayout((Layout)new GridLayout(3, true));
        this.iconSection.setClient((Control)this.iconComposite);
    }

    private void createIconSectionContent() {
        Composite shapeIconComposite = DescriptionFormPage.createComposite(this.toolkit, this.iconComposite, 1);
        shapeIconComposite.setLayoutData((Object)new GridData());
        shapeIconComposite.setLayout((Layout)new GridLayout(2, true));
        DescriptionFormPage.createLabelWithNoWrap(this.toolkit, shapeIconComposite, AuthoringUIResources.DescriptionFormPage_ShapeIconPreview_Label, 1, 2);
        this.pane1 = new Canvas(shapeIconComposite, 2048);
        GridData gridData = new GridData(1);
        gridData.heightHint = 60;
        gridData.widthHint = 60;
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 1;
        this.pane1.setLayoutData((Object)gridData);
        this.pane1.setBackground(ColorConstants.lightGray);
        Composite pane2 = DescriptionFormPage.createCompositeForButtons(this.toolkit, shapeIconComposite);
        this.ctrl_select_shapeIcon_button = this.toolkit.createButton(pane2, AuthoringUIResources.DescriptionFormPage_ShapeIconPreview_SelectButtonLabel, 0);
        this.ctrl_clear_shapeIcon_button = this.toolkit.createButton(pane2, AuthoringUIResources.DescriptionFormPage_ShapeIconPreview_ClearButtonLabel, 0);
        if (this.contentElement.getShapeicon() == null) {
            this.ctrl_clear_shapeIcon_button.setEnabled(false);
        } else {
            this.ctrl_clear_shapeIcon_button.setEnabled(true);
        }
        Composite nodeIconComposite = DescriptionFormPage.createComposite(this.toolkit, this.iconComposite, 1);
        nodeIconComposite.setLayoutData((Object)new GridData(768));
        nodeIconComposite.setLayout((Layout)new GridLayout(2, false));
        DescriptionFormPage.createLabelWithNoWrap(this.toolkit, nodeIconComposite, AuthoringUIResources.DescriptionFormPage_NodeIconPreview_Label, 1, 2);
        this.pane3 = new Canvas(nodeIconComposite, 2048);
        GridData gridData2 = new GridData(1);
        gridData2.heightHint = 40;
        gridData2.widthHint = 40;
        gridData2.verticalSpan = 1;
        gridData2.horizontalSpan = 1;
        this.pane3.setLayoutData((Object)gridData2);
        this.pane3.setBackground(ColorConstants.lightGray);
        Composite pane4 = DescriptionFormPage.createCompositeForButtons(this.toolkit, nodeIconComposite);
        this.ctrl_select_nodeIcon_button = this.toolkit.createButton(pane4, AuthoringUIResources.DescriptionFormPage_NodeIconPreview_SelectButtonLabel, 0);
        this.ctrl_clear_nodeIcon_button = this.toolkit.createButton(pane4, AuthoringUIResources.DescriptionFormPage_NodeIconPreview_ClearButtonLabel, 0);
        if (this.contentElement.getNodeicon() == null) {
            this.ctrl_clear_nodeIcon_button.setEnabled(false);
        } else {
            this.ctrl_clear_nodeIcon_button.setEnabled(true);
        }
        this.toolkit.paintBordersFor((Composite)this.pane1);
        this.toolkit.paintBordersFor(pane2);
        this.toolkit.paintBordersFor((Composite)this.pane3);
        this.toolkit.paintBordersFor(pane4);
    }

    protected void addIconSectionListeners() {
        this.ctrl_select_shapeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){
            File libDirFile = new File(LibraryService.getInstance().getCurrentMethodLibraryPath());

            public void widgetSelected(SelectionEvent e) {
                String filename;
                String imageFile;
                FileDialog fileChooser;
                URI shapeIconUri;
                block10: {
                    shapeIconUri = null;
                    fileChooser = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    fileChooser.setText(AuthoringUIResources.DescriptionFormPage_IconFileChooserDialog_title);
                    fileChooser.setFilterExtensions(new String[]{"*.gif; *.jpg; *.png; *.ico; *.bmp"});
                    fileChooser.setFilterNames(new String[]{"Image (gif, jpeg, png, ico, bmp)"});
                    imageFile = null;
                    filename = null;
                    while (true) {
                        imageFile = fileChooser.open();
                        filename = fileChooser.getFileName();
                        if (imageFile == null) break;
                        if (new File(imageFile).exists()) {
                            ImageData imageData = new ImageData(imageFile);
                            if (imageData.width > SHAPEICON_WIDTH_MAX || imageData.height > SHAPEICON_HEIGHT_MAX) {
                                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageTooBigDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageTooBigDialog_template, imageFile, new Integer(SHAPEICON_WIDTH_MAX), new Integer(SHAPEICON_HEIGHT_MAX)));
                                continue;
                            }
                            break block10;
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_template, imageFile));
                    }
                    return;
                }
                if (imageFile != null && imageFile.length() > 0) {
                    try {
                        boolean status;
                        String url = DescriptionFormPage.this.copyResourceToLib(filename, fileChooser.getFilterPath(), (MethodElement)DescriptionFormPage.this.contentElement);
                        File file = new File(url);
                        shapeIconUri = new URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)file, (File)this.libDirFile)));
                        if (shapeIconUri != null && !(status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Shapeicon(), (Object)shapeIconUri, -1))) {
                            return;
                        }
                        DescriptionFormPage.this.shapeImage = new Image((Device)Display.getCurrent(), file.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        shapeIconUri = null;
                        DescriptionFormPage.this.shapeImage = null;
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                        if (ex instanceof IOException) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_copying_file_title, AuthoringUIResources.err_copying_file_error, AuthoringUIResources.err_copying_file_reason, ex.getMessage());
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_processing_file_title, AuthoringUIResources.err_processing_file_description, (Throwable)ex);
                    }
                }
                if (DescriptionFormPage.this.shapeImage != null) {
                    DescriptionFormPage.this.pane1.redraw();
                    DescriptionFormPage.this.ctrl_clear_shapeIcon_button.setEnabled(true);
                } else {
                    DescriptionFormPage.this.ctrl_clear_shapeIcon_button.setEnabled(false);
                }
            }
        });
        this.ctrl_clear_shapeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Shapeicon(), null, -1);
                if (!status) {
                    return;
                }
                DescriptionFormPage.this.pane1.redraw();
                DescriptionFormPage.this.ctrl_clear_shapeIcon_button.setEnabled(false);
            }
        });
        this.ctrl_select_nodeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){
            File libDirFile = new File(LibraryService.getInstance().getCurrentMethodLibraryPath());

            public void widgetSelected(SelectionEvent e) {
                String filename;
                String imageFile;
                FileDialog fileChooser;
                URI nodeIconUri;
                block10: {
                    nodeIconUri = null;
                    fileChooser = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    fileChooser.setText(AuthoringUIResources.DescriptionFormPage_IconFileChooserDialog_title);
                    fileChooser.setFilterExtensions(new String[]{"*.gif; *.jpg; *.png; *.ico; *.bmp"});
                    fileChooser.setFilterNames(new String[]{"Image (gif, jpeg, png, ico, bmp)"});
                    imageFile = null;
                    filename = null;
                    while (true) {
                        imageFile = fileChooser.open();
                        filename = fileChooser.getFileName();
                        if (imageFile == null) break;
                        if (new File(imageFile).exists()) {
                            ImageData imageData = new ImageData(imageFile);
                            if (imageData.width > NODEICON_WIDTH_MAX || imageData.height > NODEICON_HEIGHT_MAX) {
                                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageTooBigDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageTooBigDialog_template, imageFile, new Integer(NODEICON_WIDTH_MAX), new Integer(NODEICON_HEIGHT_MAX)));
                                continue;
                            }
                            break block10;
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_template, imageFile));
                    }
                    return;
                }
                if (imageFile != null && imageFile.length() > 0) {
                    try {
                        boolean status;
                        String url = DescriptionFormPage.this.copyResourceToLib(filename, fileChooser.getFilterPath(), (MethodElement)DescriptionFormPage.this.contentElement);
                        File file = new File(url);
                        nodeIconUri = new URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)file, (File)this.libDirFile)));
                        if (nodeIconUri != null && !(status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Nodeicon(), (Object)nodeIconUri, -1))) {
                            return;
                        }
                        DescriptionFormPage.this.nodeImage = new Image((Device)Display.getCurrent(), file.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        nodeIconUri = null;
                        DescriptionFormPage.this.nodeImage = null;
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                        if (ex instanceof IOException) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_copying_file_title, AuthoringUIResources.err_copying_file_error, AuthoringUIResources.err_copying_file_reason, ex.getMessage());
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_processing_file_title, AuthoringUIResources.err_processing_file_description, (Throwable)ex);
                    }
                }
                if (DescriptionFormPage.this.nodeImage != null) {
                    DescriptionFormPage.this.pane3.redraw();
                    DescriptionFormPage.this.ctrl_clear_nodeIcon_button.setEnabled(true);
                } else {
                    DescriptionFormPage.this.ctrl_clear_nodeIcon_button.setEnabled(false);
                }
            }
        });
        this.ctrl_clear_nodeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Nodeicon(), null, -1);
                if (!status) {
                    return;
                }
                DescriptionFormPage.this.pane3.redraw();
                DescriptionFormPage.this.ctrl_clear_nodeIcon_button.setEnabled(false);
            }
        });
    }

    protected String copyResourceToLib(String sFileName, String sFilePath, MethodElement methodElement) throws IOException {
        File libDirs = new File(LibraryService.getInstance().getCurrentMethodLibraryPath());
        String resourceLoc = String.valueOf(libDirs.getAbsolutePath()) + File.separator + MethodLibraryPersister.getResourcePath((MethodElement)methodElement);
        File sFile = new File(String.valueOf(sFilePath) + File.separator + sFileName);
        StringBuffer resourceFile = new StringBuffer(resourceLoc).append(File.separator).append(sFileName);
        File formatFile = new File(resourceFile.toString());
        FileUtil.copyfile((File)sFile, (File)formatFile);
        return resourceFile.toString();
    }

    protected void loadIconSectionData() {
        this.pane1.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                String path;
                Rectangle clientRect = DescriptionFormPage.this.pane1.getClientArea();
                e.gc.setClipping(clientRect);
                e.gc.setBackground(Display.getCurrent().getSystemColor(15));
                e.gc.fillRectangle(clientRect);
                URI uri = DescriptionFormPage.this.contentElement.getShapeicon();
                if (uri != null && (path = DescriptionFormPage.this.contentElement.getShapeicon().getPath()) != null) {
                    try {
                        File file = new File(path);
                        if (!file.exists()) {
                            if (!file.isAbsolute()) {
                                path = String.valueOf(LibraryService.getInstance().getCurrentMethodLibraryPath()) + File.separator + path;
                            }
                            file = new File(path);
                        }
                        if (file.exists()) {
                            if (DescriptionFormPage.this.shapeImage == null) {
                                DescriptionFormPage.this.shapeImage = new Image((Device)Display.getCurrent(), path);
                            }
                            clientRect = DescriptionFormPage.this.pane1.getClientArea();
                            e.gc.setClipping(clientRect);
                            e.gc.setBackground(Display.getCurrent().getSystemColor(15));
                            e.gc.fillRectangle(clientRect);
                            e.gc.drawImage(DescriptionFormPage.this.shapeImage, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().x, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().y, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().width, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().height, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().x, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().y, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().width, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().height);
                        } else if (DescriptionFormPage.this.warningCount == 1) {
                            String msg = AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadShapeIconWarning, (Object[])new Object[]{DescriptionFormPage.this.contentElement.getName(), path});
                            MsgBox.showWarning((String)msg);
                            DescriptionFormPage descriptionFormPage = DescriptionFormPage.this;
                            descriptionFormPage.warningCount = descriptionFormPage.warningCount + 1;
                        }
                    }
                    catch (Exception ex) {
                        AuthoringUIPlugin.getDefault().getLogger().logError(AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadShapeIconError, (Object[])new Object[]{ex.getMessage()}));
                    }
                }
            }
        });
        this.pane1.redraw();
        this.pane3.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                String path;
                Rectangle clientRect = DescriptionFormPage.this.pane3.getClientArea();
                e.gc.setClipping(clientRect);
                e.gc.setBackground(Display.getCurrent().getSystemColor(15));
                e.gc.fillRectangle(clientRect);
                URI uri = DescriptionFormPage.this.contentElement.getNodeicon();
                if (uri != null && (path = DescriptionFormPage.this.contentElement.getNodeicon().getPath()) != null) {
                    try {
                        File file = new File(path);
                        if (!file.exists()) {
                            if (!file.isAbsolute()) {
                                path = String.valueOf(LibraryService.getInstance().getCurrentMethodLibraryPath()) + File.separator + path;
                            }
                            file = new File(path);
                        }
                        if (file.exists()) {
                            if (DescriptionFormPage.this.nodeImage == null) {
                                DescriptionFormPage.this.nodeImage = new Image((Device)Display.getCurrent(), path);
                            }
                            clientRect = DescriptionFormPage.this.pane3.getClientArea();
                            e.gc.setClipping(clientRect);
                            e.gc.setBackground(Display.getCurrent().getSystemColor(15));
                            e.gc.fillRectangle(clientRect);
                            e.gc.drawImage(DescriptionFormPage.this.nodeImage, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().x, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().y, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().width, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().height, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().x, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().y, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().width, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().height);
                        } else if (DescriptionFormPage.this.warningCount == 1) {
                            String msg = AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadNodeIconWarning, (Object[])new Object[]{DescriptionFormPage.this.contentElement.getName(), path});
                            MsgBox.showWarning((String)msg);
                            DescriptionFormPage descriptionFormPage = DescriptionFormPage.this;
                            descriptionFormPage.warningCount = descriptionFormPage.warningCount + 1;
                        }
                    }
                    catch (Exception ex) {
                        AuthoringUIPlugin.getDefault().getLogger().logError(AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadNodeIconError, (Object[])new Object[]{ex.getMessage()}));
                    }
                }
            }
        });
        this.pane3.redraw();
    }

    protected void enableSections(boolean enable) {
        if (this.generalSectionOn) {
            this.generalSection.setVisible(enable);
            if (enable) {
                this.generalSection.setExpanded(this.generalSectionExpandFlag);
            } else {
                this.generalSectionExpandFlag = this.generalSection.isExpanded();
                this.generalSection.setExpanded(enable);
            }
        }
        if (this.detailSectionOn) {
            this.detailSection.setVisible(enable);
            if (enable) {
                this.detailSection.setExpanded(this.detailSectionExpandFlag);
            } else {
                this.detailSectionExpandFlag = this.detailSection.isExpanded();
                this.detailSection.setExpanded(enable);
            }
        }
        if (this.notationSectionOn) {
            this.notationSection.setVisible(enable);
            if (enable) {
                this.notationSection.setExpanded(this.notationSectionExpandFlag);
            } else {
                this.notationSectionExpandFlag = this.notationSection.isExpanded();
                this.notationSection.setExpanded(enable);
            }
        }
        if (this.tailoringSectionOn) {
            this.tailoringSection.setVisible(enable);
            if (enable) {
                this.tailoringSection.setExpanded(this.tailoringSectionExpandFlag);
            } else {
                this.tailoringSectionExpandFlag = this.tailoringSection.isExpanded();
                this.tailoringSection.setExpanded(enable);
            }
        }
        if (this.versionSectionOn) {
            this.versionSection.setVisible(enable);
            if (enable) {
                this.versionSection.setExpanded(this.versionSectionExpandFlag);
            } else {
                this.versionSectionExpandFlag = this.versionSection.isExpanded();
                this.versionSection.setExpanded(enable);
            }
        }
        if (this.iconSectionOn) {
            this.iconSection.setVisible(enable);
            if (enable) {
                this.iconSection.setExpanded(this.iconSectionExpandFlag);
            } else {
                this.iconSectionExpandFlag = this.iconSection.isExpanded();
                this.iconSection.setExpanded(enable);
            }
        }
        if (this.variabilitySectionOn) {
            this.variabilitySection.setVisible(enable);
            if (enable) {
                this.variabilitySection.setExpanded(this.elementSectionExpandFlag);
            } else {
                this.elementSectionExpandFlag = this.variabilitySection.isExpanded();
                this.variabilitySection.setExpanded(enable);
            }
        }
    }

    public void dispose() {
        if (this.shapeImage != null) {
            this.shapeImage.dispose();
        }
        if (this.nodeImage != null) {
            this.nodeImage.dispose();
        }
        if (this.labelProviderVariability != null) {
            this.labelProviderVariability.dispose();
        }
        if (this.contentProviderVariability != null) {
            this.contentProviderVariability.dispose();
        }
        if (this.labelProviderBase != null) {
            this.labelProviderBase.dispose();
        }
        if (this.copyrightLabelProviderBase != null) {
            this.copyrightLabelProviderBase.dispose();
        }
        super.dispose();
        this.disposed = true;
    }

    public int getRichTextEditorHeight() {
        return this.form.getBounds().height - 96;
    }

    public int getRichTextEditorWidth() {
        return Math.max(560, this.form.getBounds().width - 64);
    }

    private void setCopyrightButtonDeselect() {
        if (this.contentElement.getPresentation().getCopyrightStatement() != null) {
            this.copyright_button_deselect.setEnabled(this.contentElement.getPresentation().getCopyrightStatement().getName() != null);
        } else {
            this.copyright_button_deselect.setEnabled(false);
        }
        if (TngUtil.isLocked((EObject)this.contentElement)) {
            this.copyright_button_deselect.setEnabled(false);
        }
    }

    private void setContextHelp() {
        if (this.sectionComposite != null) {
            EditorsContextHelper.setHelp((Control)this.sectionComposite.getParent(), this.getContentElement());
        }
        if (this.expandedComposite != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.expandedComposite, AuthoringUIHelpContexts.RICH_TEXT_EDITOR_CONTEXT_ID);
        }
    }

    public void refreshName(String newName) {
        if (newName != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            this.ctrl_name.removeModifyListener(this.modelModifyListener);
            this.ctrl_name.setText(newName);
            this.ctrl_name.addModifyListener(this.modelModifyListener);
            this.setFormTextWithVariableInfo();
        }
    }

    public void loadSectionDescription() {
    }

    protected String getDetailSectionDescription() {
        if (this.detailSectionDescription != null) {
            return this.detailSectionDescription;
        }
        return AuthoringUIText.DETAIL_SECTION_DESC;
    }

    protected String getGeneralSectionDescription() {
        if (this.generalSectionDescription != null) {
            return this.generalSectionDescription;
        }
        return AuthoringUIText.GENERAL_INFO_SECTION_DESC;
    }

    protected String getTailoringSectionDescription() {
        if (this.tailoringSectionDescription != null) {
            return this.tailoringSectionDescription;
        }
        return AuthoringUIText.TAILORING_SECTION_DESC;
    }

    protected String getNotationSectionDescription() {
        if (this.notationSectionDescription != null) {
            return this.notationSectionDescription;
        }
        return AuthoringUIText.NOTATION_SECTION_DESC;
    }

    protected String getVariabilitySectionDescription() {
        if (this.variabilitySectionDescription != null) {
            return this.variabilitySectionDescription;
        }
        return AuthoringUIText.VARIABILITY_SECTION_DESC;
    }

    private String getIconSectionDescription() {
        if (this.iconSectionDescription != null) {
            return this.iconSectionDescription;
        }
        return AuthoringUIText.ICON_SECTION_DESC;
    }

    private String getVersionSectionDescription() {
        if (this.versionSectionDescription != null) {
            return this.versionSectionDescription;
        }
        return AuthoringUIText.VERSION_INFO_SECTION_DESC;
    }

    public Text getCtrl_brief_desc() {
        return this.ctrl_brief_desc;
    }

    public void setCtrl_brief_desc(Text ctrl_brief_desc) {
        this.ctrl_brief_desc = ctrl_brief_desc;
    }

    public IMethodRichText getCtrl_full_desc() {
        return this.ctrl_full_desc;
    }

    public void setCtrl_full_desc(IMethodRichText ctrl_full_desc) {
        this.ctrl_full_desc = ctrl_full_desc;
    }

    public Text getCtrl_presentation_name() {
        return this.ctrl_presentation_name;
    }

    public void setCtrl_presentation_name(Text ctrl_presentation_name) {
        this.ctrl_presentation_name = ctrl_presentation_name;
    }

    public IMethodRichTextEditor getCtrl_expanded() {
        return this.ctrl_expanded;
    }

    public void setCtrl_expanded(IMethodRichTextEditor ctrl_expanded) {
        this.ctrl_expanded = ctrl_expanded;
    }

    public IMethodRichText getCtrl_key() {
        return this.ctrl_key;
    }

    public void setCtrl_key(IMethodRichText ctrl_key) {
        this.ctrl_key = ctrl_key;
    }
}

