/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.FeatureHierarchyElement;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class JobRoot {
    private IInstallFeatureOperation job;
    private FeatureHierarchyElement[] elements;

    public JobRoot(IInstallFeatureOperation job) {
        this.job = job;
    }

    public IInstallFeatureOperation getJob() {
        return this.job;
    }

    public FeatureHierarchyElement[] getElements() {
        if (this.elements == null) {
            this.computeElements();
        }
        return this.elements;
    }

    public IFeature[] getUnconfiguredOptionalFeatures(IInstallConfiguration config, IConfiguredSite targetSite) {
        ArrayList unconfiguredOptionalFeatures = new ArrayList();
        this.getUnconfiguredOptionalFeatures(unconfiguredOptionalFeatures, config, targetSite, this.getElements(), UpdateUtils.isPatch(this.job.getFeature()));
        IFeature[] unconfiguredOptionalFeaturesArray = new IFeature[unconfiguredOptionalFeatures.size()];
        unconfiguredOptionalFeatures.toArray(unconfiguredOptionalFeaturesArray);
        return unconfiguredOptionalFeaturesArray;
    }

    private void getUnconfiguredOptionalFeatures(ArrayList unconfiguredOptionalFeatures, IInstallConfiguration config, IConfiguredSite targetSite, FeatureHierarchyElement[] optionalElements, boolean isPatch) {
        int i = 0;
        while (i < optionalElements.length) {
            FeatureHierarchyElement[] children = optionalElements[i].getChildren(true, isPatch, config);
            this.getUnconfiguredOptionalFeatures(unconfiguredOptionalFeatures, config, targetSite, children, isPatch);
            if (!optionalElements[i].isEnabled(config)) {
                unconfiguredOptionalFeatures.add(optionalElements[i].getFeature());
            }
            ++i;
        }
    }

    private void computeElements() {
        try {
            IFeature oldFeature = this.job.getOldFeature();
            IFeature newFeature = this.job.getFeature();
            ArrayList list = new ArrayList();
            boolean patch = UpdateUtils.isPatch(newFeature);
            FeatureHierarchyElement.computeElements(oldFeature, newFeature, oldFeature != null, patch, SiteManager.getLocalSite().getCurrentConfiguration(), list);
            this.elements = new FeatureHierarchyElement[list.size()];
            list.toArray(this.elements);
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].setRoot(this);
                ++i;
            }
        }
        catch (CoreException e) {
            UpdateUtils.logException(e);
        }
    }
}

