/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.LibraryDiffManager;
import org.eclipse.epf.importing.services.ResourceScanner;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IFileManager;

public class LibraryImportManager {
    private Map renameElementMap = new HashMap();
    private Map setElementMap = null;
    private LibraryDiffManager diffMgr;
    private ElementDiffTree rootTree;
    private MethodLibrary baseLibrary = null;
    private MethodLibrary importingLibrary = null;
    private Map replacedElementMap = new HashMap();
    private List newElements = new ArrayList();
    private List deletedElements = new ArrayList();
    private boolean debug = ImportPlugin.getDefault().isDebugging();
    List checkedList = new ArrayList();
    IStatus fileCheckedOutStatus = null;
    List newResources = new ArrayList();
    ResourceScanner resScanner;
    static MethodElement newCont = null;
    static MethodElement newElem = null;
    private List processedNewElements = new ArrayList();

    public LibraryImportManager(LibraryDiffManager diffMgr, List checkedItems) {
        this.diffMgr = diffMgr;
        this.rootTree = diffMgr.getDiffTree();
        if (checkedItems != null) {
            this.checkedList.addAll(checkedItems);
            Iterator it = checkedItems.iterator();
            while (it.hasNext()) {
                MethodPackage pkg;
                List children;
                ElementDiffTree diffTree = (ElementDiffTree)it.next();
                MethodElement e = diffTree.getBaseElement();
                if (e != null) {
                    this.checkedList.add(e);
                }
                if (e instanceof ProcessComponent) {
                    LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)e), (List)this.checkedList);
                }
                if (e instanceof MethodPackage && (children = ((MethodPackage)e).getChildPackages()).size() == 1 && TngUtil.isRootCutomCategoryPackage((MethodPackage)(pkg = (MethodPackage)children.get(0)))) {
                    this.checkedList.add(pkg);
                }
                if ((e = diffTree.getImportElement()) != null) {
                    this.checkedList.add(e);
                }
                if (e instanceof ProcessComponent) {
                    LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)e), (List)this.checkedList);
                }
                if (!diffTree.isNew()) continue;
                if (e instanceof MethodPlugin) {
                    this.checkedList.addAll(LibraryUtil.getAllPackages((MethodPlugin)((MethodPlugin)e)));
                    continue;
                }
                if (!(e instanceof MethodPackage)) continue;
                LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)e), (List)this.checkedList);
            }
        } else {
            this.checkedList = null;
        }
        this.init();
        this.baseLibrary = (MethodLibrary)this.rootTree.getBaseElement();
        this.importingLibrary = (MethodLibrary)this.rootTree.getImportElement();
        this.resScanner = new ResourceScanner(LibraryUtil.getLibraryRootPath((MethodLibrary)this.importingLibrary), LibraryUtil.getLibraryRootPath((MethodLibrary)this.baseLibrary));
    }

    private void init() {
    }

    private boolean isSelected(ElementDiffTree diffTree) {
        if (this.checkedList == null || this.checkedList.contains(diffTree)) {
            return true;
        }
        MethodElement e = diffTree.getBaseElement();
        if (e == null) {
            e = diffTree.getImportElement();
        }
        return this.isSelected(e);
    }

    private boolean isSelected(MethodElement e) {
        if (this.checkedList == null || e instanceof ContentDescription || e.eContainer() instanceof ContentDescription || e instanceof MethodLibrary) {
            return true;
        }
        if (this.checkedList.size() == 0) {
            return false;
        }
        if (e instanceof MethodConfiguration) {
            return this.checkedList.contains(e);
        }
        MethodElement o = (MethodElement)LibraryUtil.getSelectable((EObject)e);
        if (o == null) {
            return false;
        }
        if (o instanceof MethodLibrary) {
            return true;
        }
        return this.checkedList.contains(o);
    }

    public void doMerge(boolean replaceExisting, IProgressMonitor monitor) throws Exception {
        if (this.debug) {
            System.out.println("Merging configuration ...");
        }
        if (this.debug) {
            System.out.println("loading library ...");
        }
        LibraryUtil.loadAll((MethodLibrary)this.baseLibrary);
        LibraryUtil.loadAll((MethodLibrary)this.importingLibrary);
        LibraryUtil.detachFromResource((MethodLibrary)this.importingLibrary);
        this.importingLibrary.setName("ImportingLib: " + this.importingLibrary.getName());
        if (this.debug) {
            System.out.println("Process configuration diff tree ...");
        }
        ArrayList oldResources = new ArrayList(this.baseLibrary.eResource().getResourceSet().getResources());
        this.processDiffTree(this.rootTree, replaceExisting);
        this.handleSetElements();
        if (this.debug) {
            System.out.println("perform integrity checking ...");
        }
        this.doIntegrityCheck();
        this.handleNewResources(oldResources);
        LibraryImportManager.handleNameReplace(this.renameElementMap);
        if (this.debug) {
            System.out.println("check out files ...");
        }
        this.deleteResoruces();
        final List modifiedFiles = this.getModifiedResources(this.baseLibrary);
        modifiedFiles.addAll(this.resScanner.getFilesTobeReplaced());
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                LibraryImportManager.this.fileCheckedOutStatus = FileModifyChecker.checkModify(modifiedFiles);
            }
        });
        if (this.fileCheckedOutStatus.isOK()) {
            if (this.debug) {
                System.out.println("copying resource files ...");
            }
            this.resScanner.execute();
            if (this.debug) {
                System.out.println("saving library ...");
            }
            LibraryUtil.saveLibrary((MethodLibrary)this.baseLibrary, (boolean)false, (boolean)false);
        } else {
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    String title = ImportResources.importConfigWizard_title;
                    String msg = ImportResources.ImportConfigurationWizard_ERR_Import_configuration;
                    new MsgDialog((AbstractPlugin)ImportPlugin.getDefault()).displayError(title, msg, LibraryImportManager.this.fileCheckedOutStatus);
                }
            });
            if (this.debug) {
                System.out.println("Checkout files failed ...");
            }
        }
        if (this.debug) {
            System.out.println("Merging configuration done...");
        }
    }

    private void handleNewResources(List oldResources) {
        Iterator it = this.baseLibrary.eResource().getResourceSet().getResources().iterator();
        while (it.hasNext()) {
            Resource res = (Resource)it.next();
            if (oldResources.contains(res)) continue;
            this.logNewResource(res);
        }
    }

    private void processDiffTree(ElementDiffTree diffTree, boolean replaceExisting) throws Exception {
        List children;
        if (diffTree == null || !this.isSelected(diffTree)) {
            return;
        }
        int state = diffTree.getDiffState();
        MethodElement base = diffTree.getBaseElement();
        MethodElement imp = diffTree.getImportElement();
        if (replaceExisting && state == 4) {
            if (base instanceof MethodConfiguration) {
                this.doReplaceConfiguration((MethodConfiguration)base, (MethodConfiguration)imp);
            } else if (base instanceof MethodPlugin) {
                this.doReplacePlugin((MethodPlugin)base, (MethodPlugin)imp);
            } else if (base instanceof MethodPackage) {
                this.doReplacePackage((MethodPackage)base, (MethodPackage)imp);
            } else if (this.debug) {
                System.out.println("What is this: " + LibraryUtil.getTypeName((MethodElement)base));
            }
        } else if (state == 1) {
            this.doAdd((EObject)diffTree.getBaseParentElement(), diffTree.getImportElement());
        }
        if (state != 1 && (children = diffTree.getChildren()) != null && children.size() > 0) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.processDiffTree((ElementDiffTree)it.next(), replaceExisting);
            }
        }
    }

    private void doReplaceConfiguration(MethodConfiguration oldObj, MethodConfiguration newObj) {
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        List properties = oldObj.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object newValue = newObj.eGet(feature);
                this.setFeatureValue((MethodElement)oldObj, feature, newValue, false);
                ++i;
            }
        }
    }

    private void doReplacePlugin(MethodPlugin oldObj, MethodPlugin newObj) {
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        List properties = oldObj.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue((MethodElement)oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    private void doReplacePackage(MethodPackage oldObj, MethodPackage newObj) {
        List properties;
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        if (this.debug) {
            System.out.println("Replacing package " + LibraryUtil.getTypeName((MethodElement)oldObj));
        }
        if ((properties = oldObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue((MethodElement)oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    private void doReplaceElement(MethodElement oldObj, MethodElement newObj) {
        List properties;
        if (this.isReplaced(oldObj)) {
            return;
        }
        if (this.diffMgr.selectable(oldObj)) {
            return;
        }
        if (!this.isSelected(oldObj)) {
            return;
        }
        if (oldObj instanceof ContentDescription && newObj instanceof ContentDescription && LibraryUtil.isIdentical((MethodElement)((ContentDescription)oldObj), (MethodElement)((ContentDescription)newObj))) {
            Resource res;
            if (this.debug && (res = oldObj.eResource()) != null) {
                System.out.println("Identical element not replaced: " + res.getURI().toFileString());
            }
            this.scanResources(oldObj, true);
            return;
        }
        this.setReplaced(oldObj);
        if (this.debug) {
            System.out.println("Replacing element " + LibraryUtil.getTypeName((MethodElement)oldObj));
        }
        if ((properties = oldObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages() && feature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() && !feature.isDerived()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue(oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFeatureValue(MethodElement element, EStructuralFeature feature, Object newValue, boolean doDelete) {
        if (this.canIgnore(feature)) {
            return;
        }
        oldNotify = element.eDeliver();
        try {
            try {
                block27: {
                    block29: {
                        block28: {
                            block26: {
                                block25: {
                                    element.eSetDeliver(false);
                                    if (!this.canReset(feature)) break block25;
                                    element.eSet(feature, newValue);
                                    ** GOTO lbl-1000
                                }
                                if (!feature.isMany() || !(newValue instanceof List)) break block26;
                                oldValue = (List)element.eGet(feature);
                                diff = new ElementListDiff(oldValue, (List)newValue);
                                if (doDelete && diff.deletedItems.size() > 0) {
                                    oldValue.removeAll(diff.deletedItems);
                                    this.logRemovedElements(diff.deletedItems);
                                    if (this.debug) {
                                        System.out.println("  Deleting feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", values: " + diff.deletedItems);
                                    }
                                }
                                if (diff.newItems.size() > 0) {
                                    itn = diff.newItems.iterator();
                                    while (true) {
                                        if (!itn.hasNext()) {
                                            if (!this.debug) break;
                                            System.out.println("  Adding feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", values: " + diff.newItems);
                                            break;
                                        }
                                        newObj = (MethodElement)itn.next();
                                        if (!this.isSelected(newObj)) continue;
                                        oldObj = this.diffMgr.getExistingElement(newObj.getGuid());
                                        if (oldObj == null) {
                                            oldValue.add(newObj);
                                            this.logNewElement(newObj);
                                            continue;
                                        }
                                        oldValue.add(oldObj);
                                        this.doReplaceElement(oldObj, newObj);
                                    }
                                }
                                if (diff.oldNewMap.size() > 0) {
                                    it = diff.oldNewMap.entrySet().iterator();
                                    while (it.hasNext()) {
                                        entry = it.next();
                                        oldObj = (MethodElement)entry.getKey();
                                        if (!this.isSelected(oldObj)) continue;
                                        newObj = (MethodElement)entry.getValue();
                                        if (this.canReset(oldObj)) {
                                            if (this.debug) {
                                                System.out.println("  Resetting feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", value: " + LibraryUtil.getTypeName((MethodElement)oldObj));
                                            }
                                            EcoreUtil.replace((EObject)element, (EStructuralFeature)feature, (Object)oldObj, (Object)newObj);
                                            this.logResetElement(newObj);
                                            continue;
                                        }
                                        this.doReplaceElement(oldObj, newObj);
                                    }
                                }
                                ** GOTO lbl-1000
                            }
                            if (!(newValue instanceof MethodElement)) break block27;
                            o = (MethodElement)element.eGet(feature);
                            n = (MethodElement)newValue;
                            if (o != null && !this.isSelected(o) || !this.isSelected(n)) ** GOTO lbl-1000
                            if (this.debug) {
                                System.out.println("  Replacinging feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", value: " + LibraryUtil.getTypeName((MethodElement)o));
                            }
                            if (!(newValue instanceof ContentDescription)) break block28;
                            if (o.eContainer() != null || n.eContainer() != null) {
                                if (o.eContainer() == null) {
                                    element.eSet(feature, (Object)o);
                                }
                                this.doReplaceElement(o, n);
                            }
                            ** GOTO lbl-1000
                        }
                        if (!this.canReset(n)) break block29;
                        element.eSet(feature, newValue);
                        this.logNewElement(n);
                        ** GOTO lbl-1000
                    }
                    if (o != null && n != null && o.getGuid().equals(n.getGuid())) {
                        this.doReplaceElement(o, n);
                    } else {
                        this.registerSetElement(element, feature, newValue);
                        element.eSet(feature, newValue);
                        this.logNewElement(n);
                    }
                    ** GOTO lbl-1000
                }
                if (feature == UmaPackage.eINSTANCE.getNamedElement_Name()) {
                    if (!(newValue instanceof String)) {
                        throw new UnsupportedOperationException();
                    }
                    oldName = (String)element.eGet(feature);
                    if (!newValue.equals(oldName)) {
                        LibraryImportManager.ensureUniqueNameForExistingElement(element, oldName, (String)newValue, this.renameElementMap);
                    }
                } else {
                    element.eSet(feature, newValue);
                    this.scanResources(element, feature, newValue);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Throwable var13_16) {
            var12_17 = null;
            element.eSetDeliver(oldNotify);
            throw var13_16;
        }
lbl-1000:
        // 10 sources

        {
            var12_18 = null;
        }
        element.eSetDeliver(oldNotify);
    }

    private void scanResources(MethodElement element, boolean recursive) {
        if (element == null) {
            return;
        }
        List properties = element.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature instanceof EAttribute) {
                    Object value = element.eGet(feature);
                    this.scanResources(element, feature, value);
                }
                ++i;
            }
        }
        if (!recursive) {
            return;
        }
        TreeIterator it = element.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj instanceof MethodLibrary || obj instanceof MethodPlugin || obj instanceof MethodPackage || obj instanceof MethodConfiguration || !(obj instanceof MethodElement)) continue;
            this.scanResources((MethodElement)obj, false);
        }
    }

    private void scanResources(MethodElement element, EStructuralFeature feature, Object newValue) {
        if (feature == UmaPackage.eINSTANCE.getGuidanceDescription_Attachments()) {
            String urls = (String)newValue;
            if (urls != null && urls.length() != 0) {
                StringTokenizer st = new StringTokenizer(urls, "|");
                while (st.hasMoreTokens()) {
                    String url = st.nextToken();
                    this.resScanner.copyResource(element, url);
                }
            }
        } else if (newValue instanceof String) {
            this.resScanner.scan(element, newValue.toString());
        } else if (newValue instanceof URI) {
            this.resScanner.copyResource(((URI)newValue).getPath());
        }
    }

    private void doAdd(EObject owner, MethodElement newObj) throws Exception {
        if (this.debug) {
            System.out.println("Adding element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if (owner == null) {
            return;
        }
        LibraryImportManager.ensureUniqueName(owner, newObj, this.renameElementMap);
        boolean error = false;
        if (owner instanceof MethodLibrary) {
            if (newObj instanceof MethodPlugin) {
                MethodPlugin plugin = (MethodPlugin)newObj;
                ((MethodLibrary)owner).getMethodPlugins().add(plugin);
                LibraryUtil.saveLibrary((MethodLibrary)((MethodLibrary)owner), (boolean)false, (boolean)false);
            } else if (newObj instanceof MethodConfiguration) {
                ((MethodLibrary)owner).getPredefinedConfigurations().add(newObj);
                LibraryUtil.saveLibrary((MethodLibrary)((MethodLibrary)owner), (boolean)false, (boolean)false);
            } else {
                error = true;
            }
        } else if (owner instanceof MethodPackage && owner.eContainer() != null && newObj instanceof MethodPackage) {
            ((MethodPackage)owner).getChildPackages().add(newObj);
        } else {
            error = true;
        }
        if (error) {
            String msg = "can't add " + LibraryUtil.getTypeName((MethodElement)newObj) + " to " + LibraryUtil.getTypeName((MethodElement)((MethodPackage)owner));
            ImportPlugin.getDefault().getLogger().logError(msg);
            if (this.debug) {
                System.out.println(msg);
            }
        } else {
            this.logNewElement(newObj);
        }
    }

    private void doIntegrityCheck() {
        while (this.newElements.size() > 0) {
            MethodElement newObj = (MethodElement)this.newElements.remove(0);
            try {
                if (newObj instanceof DiagramElement) {
                    this.fixDiagram((DiagramElement)newObj);
                    continue;
                }
                this.fixNewElementReferences(newObj);
            }
            catch (Exception e) {
                if (this.debug) {
                    System.out.println("Exception while fixing new element " + LibraryUtil.getTypeName((MethodElement)newObj));
                }
                e.printStackTrace();
            }
        }
        List configs = this.baseLibrary.getPredefinedConfigurations();
        Iterator it = configs.iterator();
        while (it.hasNext()) {
            MethodConfiguration config = (MethodConfiguration)it.next();
            LibraryUtil.validateMethodConfiguration((MethodConfiguration)config);
        }
    }

    private void fixNewElementReferences(MethodElement newObj) {
        List properties;
        if (this.processedNewElements.contains(newObj)) {
            return;
        }
        this.processedNewElements.add(newObj);
        if (this.debug) {
            System.out.println("Fixing element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if ((properties = newObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object value = newObj.eGet(feature);
                if (value instanceof List) {
                    Iterator it = new ArrayList((List)value).iterator();
                    while (it.hasNext()) {
                        Object o = it.next();
                        this.fixNewElementFeatureValue(newObj, feature, o);
                    }
                } else {
                    this.fixNewElementFeatureValue(newObj, feature, value);
                }
                ++i;
            }
        }
    }

    private void fixDiagram(DiagramElement newObj) {
        List properties;
        if (this.processedNewElements.contains(newObj)) {
            return;
        }
        this.processedNewElements.add(newObj);
        if (this.debug) {
            System.out.println("Fixing diagram element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if ((properties = newObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object value = newObj.eGet(feature);
                if (value instanceof List) {
                    Iterator it = new ArrayList((List)value).iterator();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof MethodElement)) continue;
                        if (feature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                            this.fixNewElementFeatureValue((MethodElement)newObj, feature, o);
                            continue;
                        }
                        if (!(o instanceof DiagramElement)) continue;
                        this.fixDiagram((DiagramElement)o);
                    }
                } else if (value instanceof MethodElement) {
                    if (feature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                        this.fixNewElementFeatureValue((MethodElement)newObj, feature, value);
                    } else if (value instanceof DiagramElement) {
                        this.fixDiagram((DiagramElement)value);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixNewElementFeatureValue(MethodElement element, EStructuralFeature feature, Object obj) {
        if (!(obj instanceof MethodElement)) {
            return;
        }
        if (this.debug) {
            System.out.println("fixing element feature value " + LibraryUtil.getTypeName((MethodElement)element) + ", feature=" + feature.getName());
        }
        boolean oldNotify = element.eDeliver();
        try {
            block12: {
                try {
                    element.eSetDeliver(false);
                    MethodElement newObj = (MethodElement)obj;
                    MethodElement oldObj = this.getReplaced(newObj.getGuid());
                    if (oldObj == null) {
                        oldObj = this.diffMgr.getExistingElement(newObj.getGuid());
                    }
                    if (oldObj == null) {
                        this.fixNewElementReferences(newObj);
                        break block12;
                    }
                    try {
                        EcoreUtil.replace((EObject)element, (EStructuralFeature)feature, (Object)newObj, (Object)oldObj);
                    }
                    catch (Exception exception) {
                        EcoreUtil.remove((EObject)element, (EStructuralFeature)feature, (Object)newObj);
                        if (this.debug) {
                            System.out.println("Replaceing feature value failed for element [" + LibraryUtil.getTypeName((MethodElement)element) + "], feature [" + feature.getName() + "], value=" + newObj + ". The feature value is removed. ");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            element.eSetDeliver(oldNotify);
            throw throwable;
        }
        element.eSetDeliver(oldNotify);
    }

    private boolean canReset(MethodElement e) {
        boolean reset = false;
        if (e == null || e instanceof DiagramElement) {
            reset = true;
        }
        return reset;
    }

    private boolean canReset(EStructuralFeature feature) {
        return false;
    }

    private boolean canIgnore(EStructuralFeature feature) {
        if (feature == UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable()) {
            return true;
        }
        return feature == UmaPackage.eINSTANCE.getArtifact_ContainerArtifact();
    }

    private boolean isReplaced(MethodElement oldObj) {
        return this.replacedElementMap.containsKey(oldObj.getGuid());
    }

    private void setReplaced(MethodElement oldObj) {
        String guid = oldObj.getGuid();
        if (!this.replacedElementMap.containsKey(guid)) {
            this.replacedElementMap.put(guid, oldObj);
            this.setModified((EObject)oldObj);
        }
    }

    private MethodElement getReplaced(String guid) {
        return (MethodElement)this.replacedElementMap.get(guid);
    }

    private void copyNewElementResources(MethodElement newObj) {
        this.scanResources(newObj, true);
    }

    private void logNewElement(MethodElement newObj) {
        if (!this.newElements.contains(newObj) && this.diffMgr.getExistingElement(newObj.getGuid()) == null) {
            this.newElements.add(newObj);
            this.copyNewElementResources(newObj);
            this.setModified((EObject)newObj);
        }
    }

    private void logResetElement(MethodElement newObj) {
        if (!this.newElements.contains(newObj)) {
            this.newElements.add(newObj);
            this.setModified((EObject)newObj);
        }
    }

    private void logNewResource(Resource res) {
        if (res != null) {
            res.setModified(true);
            String file = res.getURI().toFileString();
            if (!this.newResources.contains(file)) {
                this.newResources.add(file);
            }
        }
    }

    private void logRemovedElements(List items) {
        if (items == null || items.size() == 0) {
            return;
        }
        Iterator it = items.iterator();
        while (it.hasNext()) {
            MethodElement e = (MethodElement)it.next();
            if (e.eContainer() != null || this.deletedElements.contains(e)) continue;
            this.deletedElements.add(e);
        }
    }

    private void setModified(EObject obj) {
        Resource res;
        if (obj != null && (res = obj.eResource()) != null) {
            if (!res.isModified()) {
                res.setModified(true);
            }
            if (this.debug && res.isModified()) {
                System.out.println("Modified: " + res.getURI().toFileString());
            }
        }
    }

    private List getModifiedResources(MethodLibrary lib) {
        ArrayList<String> modifiedList = new ArrayList<String>();
        Resource res = lib.eResource();
        if (res != null) {
            ResourceSet resSet = res.getResourceSet();
            Iterator it = resSet.getResources().iterator();
            while (it.hasNext()) {
                String file;
                res = (Resource)it.next();
                if (res == null || !res.isModified() || this.newResources.contains(file = res.getURI().toFileString())) continue;
                if (this.debug) {
                    System.out.println("Resource modified: " + file);
                }
                modifiedList.add(file);
            }
        }
        return modifiedList;
    }

    private void deleteResoruces() {
        if (this.deletedElements.size() == 0) {
            return;
        }
        IFileManager fileMgr = ContentDescriptionFactory.getFileManager();
        Iterator it = this.deletedElements.iterator();
        while (it.hasNext()) {
            Resource res;
            MethodElement e = (MethodElement)it.next();
            ContentDescription obj = null;
            if (e instanceof DescribableElement) {
                obj = ((DescribableElement)e).getPresentation();
            } else if (e instanceof ContentDescription) {
                obj = e;
            }
            if (obj == null || (res = obj.eResource()) == null) continue;
            String file = res.getURI().toFileString();
            if (this.debug) {
                System.out.println("deleting resource: " + file);
            }
            if (fileMgr.delete(file) || !this.debug) continue;
            System.out.println("unable to delete file: " + file);
        }
    }

    public static void handleNameReplace(Map renameElementMap) {
        MethodElement element;
        Object[] val;
        Map.Entry entry;
        Iterator it = renameElementMap.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            val = (Object[])entry.getValue();
            element = (MethodElement)val[0];
            String newName = val.length == 4 ? element.getGuid() : (String)val[1];
            LibraryImportManager.rename(element, newName);
            if (val.length != 4) continue;
            element = (MethodElement)val[2];
            newName = (String)val[3];
            LibraryImportManager.rename(element, newName);
            element = (MethodElement)val[0];
            newName = (String)val[1];
            LibraryImportManager.rename(element, newName);
        }
        it = renameElementMap.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            val = (Object[])entry.getValue();
            element = (MethodElement)val[0];
            element.eResource().setModified(true);
        }
    }

    private static void rename(MethodElement element, String newName) {
        if (newName.equals(element.getName())) {
            return;
        }
        if (element instanceof ContentDescription || element.eResource() == null) {
            element.setName(newName);
            if (element instanceof ProcessComponent) {
                Process proc = ((ProcessComponent)element).getProcess();
                proc.setName(newName);
            }
        } else {
            LibraryView.runRename((NamedElement)element, (String)newName);
        }
    }

    private void registerSetElement(MethodElement element, EStructuralFeature feature, Object newValue) {
        String guid0 = ((MethodElement)newValue).getGuid();
        String guid1 = element.getGuid();
        Object[] val = new Object[]{feature, newValue, element};
        if (this.setElementMap == null) {
            this.setElementMap = new HashMap();
        }
        this.setElementMap.put(String.valueOf(element.getName()) + guid0 + guid1, val);
    }

    private void handleSetElements() {
        if (this.setElementMap == null) {
            return;
        }
        Iterator it = this.setElementMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object[] val = (Object[])entry.getValue();
            EStructuralFeature feature = (EStructuralFeature)val[0];
            MethodElement newValue = (MethodElement)val[1];
            MethodElement element = (MethodElement)val[2];
            String guid = newValue.getGuid();
            MethodElement mergedValue = (MethodElement)this.replacedElementMap.get(guid);
            if (mergedValue == null || mergedValue == newValue) continue;
            element.eSet(feature, (Object)mergedValue);
        }
    }

    public static void ensureUniqueName(EObject owner, MethodElement newObj, Map renameElementMap) {
        String name;
        if (owner == null) {
            return;
        }
        Class<?> cls = newObj.getClass();
        HashMap<String, MethodElement> nameMap = new HashMap<String, MethodElement>();
        int i = 0;
        while (i < owner.eContents().size()) {
            Object oldObj = owner.eContents().get(i);
            if (oldObj.getClass() == cls && oldObj != newObj) {
                MethodElement oldElem = (MethodElement)oldObj;
                nameMap.put(oldElem.getName(), oldElem);
            }
            ++i;
        }
        String renamed = name = newObj.getName();
        while (nameMap.containsKey(renamed)) {
            renamed = String.valueOf(renamed) + "_renamed";
        }
        if (renamed != name) {
            newObj.setName(renamed);
            Object[] entryVal = new Object[]{newObj, name, nameMap.get(name), renamed};
            renameElementMap.put(newObj.getGuid(), entryVal);
        }
    }

    public static void ensureUniqueNameForExistingElement(MethodElement element, String oldName, String newName, Map renameElementMap) {
        EObject elementOwner = element.eContainer();
        if (elementOwner != null) {
            element.setName(newName);
            LibraryImportManager.ensureUniqueName(elementOwner, element, renameElementMap);
            if (!element.getName().equals(newName)) {
                return;
            }
            element.setName(oldName);
        }
        Object[] entryVal = new Object[]{element, newName};
        renameElementMap.put(element.getGuid(), entryVal);
    }

    public class ElementListDiff {
        List newItems = new ArrayList();
        List deletedItems = new ArrayList();
        Map oldNewMap = new LinkedHashMap();

        public ElementListDiff(List oldList, List newList) {
            Map newListGuidMap = this.getGuidMap(newList);
            this.newItems.addAll(newList);
            Iterator it = oldList.iterator();
            while (it.hasNext()) {
                MethodElement oldObj = (MethodElement)it.next();
                String guid = oldObj.getGuid();
                Object newObj = newListGuidMap.get(guid);
                if (newObj != null) {
                    this.oldNewMap.put(oldObj, newObj);
                    this.newItems.remove(newObj);
                    continue;
                }
                this.deletedItems.add(oldObj);
            }
        }

        private Map getGuidMap(List items) {
            HashMap<String, MethodElement> m = new HashMap<String, MethodElement>();
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement e = (MethodElement)it.next();
                m.put(e.getGuid(), e);
            }
            return m;
        }
    }
}

