/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.richtext.RichTextResources;

public class FontStyle {
    private static final String NAME_NORMAL = RichTextResources.fontStyle_normal;
    private static final String NAME_SECTION_HEADING = RichTextResources.fontStyle_sectionHeading;
    private static final String NAME_SUBSECTION_HEADING = RichTextResources.fontStyle_subsectionHeading;
    private static final String NAME_SUB_SUBSECTION_HEADING = RichTextResources.fontStyle_subSubsectionHeading;
    private static final String NAME_QUOTE = RichTextResources.fontStyle_quote;
    private static final String NAME_CODE_SAMPLE = RichTextResources.fontStyle_codeSample;
    private static final String VALUE_NORMAL = "<p>";
    private static final String VALUE_SECTION_HEADING = "<h3>";
    private static final String VALUE_SUBSECTION_HEADING = "<h4>";
    private static final String VALUE_SUB_SUBSECTION_HEADING = "<h5>";
    private static final String VALUE_QUOTE = "<quote>";
    private static final String VALUE_CODE_SAMPLE = "<code>";
    public static final FontStyle NORMAL = new FontStyle(NAME_NORMAL, "<p>");
    public static final FontStyle SECTION_HEADING = new FontStyle(NAME_SECTION_HEADING, "<h3>");
    public static final FontStyle SUBSECTION_HEADING = new FontStyle(NAME_SUBSECTION_HEADING, "<h4>");
    public static final FontStyle SUB_SUBSECTION_HEADING = new FontStyle(NAME_SUB_SUBSECTION_HEADING, "<h5>");
    public static final FontStyle QUOTE = new FontStyle(NAME_QUOTE, "<quote>");
    public static final FontStyle CODE_SAMPLE = new FontStyle(NAME_CODE_SAMPLE, "<code>");
    private static final List FONT_STYLES = new ArrayList();
    private String name;
    private String value;

    static {
        FONT_STYLES.add(NORMAL);
        FONT_STYLES.add(SECTION_HEADING);
        FONT_STYLES.add(SUBSECTION_HEADING);
        FONT_STYLES.add(SUB_SUBSECTION_HEADING);
        FONT_STYLES.add(QUOTE);
        FONT_STYLES.add(CODE_SAMPLE);
    }

    public FontStyle(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static FontStyle getFontStyle(int index) {
        FontStyle result = (FontStyle)FONT_STYLES.get(index);
        if (result != null) {
            return result;
        }
        return NORMAL;
    }
}

