/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import com.ibm.icu.util.Calendar;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.core.history.LocalFileHistory;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.CompareRevisionAction;
import org.eclipse.team.internal.ui.actions.OpenRevisionAction;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.DateHistoryCategory;
import org.eclipse.team.internal.ui.history.DialogHistoryPageSite;
import org.eclipse.team.internal.ui.history.LocalHistoryTableProvider;
import org.eclipse.team.internal.ui.history.MessageHistoryCategory;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.IProgressConstants;

public class LocalHistoryPage
extends HistoryPage {
    IFile file;
    IFileRevision currentFileRevision;
    LocalFileHistory localFileHistory;
    IFileRevision[] entries;
    TreeViewer treeViewer;
    boolean shutdown = false;
    private boolean groupingOn;
    private boolean compareMode = false;
    protected LocalHistoryTableProvider historyTableProvider;
    private RefreshFileHistory refreshFileHistoryJob;
    private Composite localComposite;
    private Action groupByDateMode;
    private Action collapseAll;
    private Action compareModeAction;
    private Action getContentsAction;
    private CompareRevisionAction compareAction;
    private OpenRevisionAction openAction;
    private HistoryResourceListener resourceListener;
    private IFileRevision currentSelection;

    public boolean inputSet() {
        IFile tempFile;
        this.currentFileRevision = null;
        this.file = tempFile = this.getFile();
        if (tempFile == null) {
            return false;
        }
        this.treeViewer.setInput(null);
        this.localFileHistory = new LocalFileHistory(this.file);
        if (this.refreshFileHistoryJob == null) {
            this.refreshFileHistoryJob = new RefreshFileHistory();
        }
        this.refreshHistory(true);
        return true;
    }

    private IFile getFile() {
        Object obj = this.getInput();
        if (obj instanceof IFile) {
            return (IFile)obj;
        }
        return null;
    }

    private void refreshHistory(boolean refetch) {
        if (this.refreshFileHistoryJob.getState() != 0) {
            this.refreshFileHistoryJob.cancel();
        }
        this.refreshFileHistoryJob.setFileHistory(this.localFileHistory);
        this.refreshFileHistoryJob.setGrouping(this.groupingOn);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        Utils.schedule(this.refreshFileHistoryJob, (IWorkbenchSite)this.getWorkbenchSite(parentSite));
    }

    private IWorkbenchPartSite getWorkbenchSite(IHistoryPageSite parentSite) {
        IWorkbenchPart part = parentSite.getPart();
        if (part != null) {
            return part.getSite();
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.localComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.localComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.localComposite.setLayoutData((Object)data);
        this.treeViewer = this.createTree(this.localComposite);
        this.contributeActions();
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (parentSite != null && parentSite instanceof DialogHistoryPageSite && this.treeViewer != null) {
            parentSite.setSelectionProvider((ISelectionProvider)this.treeViewer);
        }
        this.resourceListener = new HistoryResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener, 1);
    }

    private void contributeActions() {
        IToolBarManager tbm;
        final IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        this.groupByDateMode = new Action(TeamUIMessages.LocalHistoryPage_GroupRevisionsByDateAction, TeamUIPlugin.getImageDescriptor("obj/dates.gif")){

            public void run() {
                LocalHistoryPage.this.groupingOn = !LocalHistoryPage.this.groupingOn;
                store.setValue("org.eclipse.team.ui.group_bydate_mode", LocalHistoryPage.this.groupingOn);
                LocalHistoryPage.this.refreshHistory(false);
            }
        };
        this.groupingOn = store.getBoolean("org.eclipse.team.ui.group_bydate_mode");
        this.groupByDateMode.setChecked(this.groupingOn);
        this.groupByDateMode.setToolTipText(TeamUIMessages.LocalHistoryPage_GroupRevisionsByDateTip);
        this.groupByDateMode.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("obj/dates.gif"));
        this.groupByDateMode.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("obj/dates.gif"));
        this.collapseAll = new Action(TeamUIMessages.LocalHistoryPage_CollapseAllAction, TeamUIPlugin.getImageDescriptor("elcl16/collapseall.gif")){

            public void run() {
                LocalHistoryPage.this.treeViewer.collapseAll();
            }
        };
        this.collapseAll.setToolTipText(TeamUIMessages.LocalHistoryPage_CollapseAllTip);
        this.collapseAll.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("elcl16/collapseall.gif"));
        this.collapseAll.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("elcl16/collapseall.gif"));
        this.compareModeAction = new Action(TeamUIMessages.LocalHistoryPage_CompareModeAction, TeamUIPlugin.getImageDescriptor("eview16/compare_view.gif")){

            public void run() {
                LocalHistoryPage.this.compareMode = !LocalHistoryPage.this.compareMode;
                LocalHistoryPage.this.compareModeAction.setChecked(LocalHistoryPage.this.compareMode);
            }
        };
        this.compareModeAction.setToolTipText(TeamUIMessages.LocalHistoryPage_CompareModeTip);
        this.compareModeAction.setDisabledImageDescriptor(TeamUIPlugin.getImageDescriptor("eview16/compare_view.gif"));
        this.compareModeAction.setHoverImageDescriptor(TeamUIPlugin.getImageDescriptor("eview16/compare_view.gif"));
        this.compareModeAction.setChecked(false);
        this.getContentsAction = this.getContextMenuAction(TeamUIMessages.LocalHistoryPage_GetContents, true, new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(null, 100);
                try {
                    try {
                        if (LocalHistoryPage.this.confirmOverwrite()) {
                            IStorage currentStorage = LocalHistoryPage.this.currentSelection.getStorage((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            InputStream in = currentStorage.getContents();
                            LocalHistoryPage.this.file.setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                    }
                    catch (TeamException e) {
                        throw new CoreException(e.getStatus());
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                }
                monitor.done();
            }
        });
        this.compareAction = new CompareRevisionAction(TeamUIMessages.LocalHistoryPage_CompareAction);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalHistoryPage.this.compareAction.setCurrentFileRevision(LocalHistoryPage.this.getCurrentFileRevision());
                LocalHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)LocalHistoryPage.this.treeViewer.getSelection());
            }
        });
        this.compareAction.setPage(this);
        this.openAction = new OpenRevisionAction(TeamUIMessages.LocalHistoryPage_OpenAction);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalHistoryPage.this.openAction.selectionChanged((IStructuredSelection)LocalHistoryPage.this.treeViewer.getSelection());
            }
        });
        this.openAction.setPage(this);
        OpenStrategy handler = new OpenStrategy((Control)this.treeViewer.getTree());
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                StructuredSelection tableStructuredSelection = (StructuredSelection)LocalHistoryPage.this.treeViewer.getSelection();
                if (LocalHistoryPage.this.compareMode) {
                    StructuredSelection sel = new StructuredSelection(new Object[]{LocalHistoryPage.this.getCurrentFileRevision(), tableStructuredSelection.getFirstElement()});
                    LocalHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)sel);
                    LocalHistoryPage.this.compareAction.run();
                } else {
                    StructuredSelection sel = tableStructuredSelection;
                    LocalHistoryPage.this.openAction.selectionChanged((IStructuredSelection)sel);
                    LocalHistoryPage.this.openAction.run();
                }
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                LocalHistoryPage.this.fillTableMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.treeViewer.getTree().setMenu(menu);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (!parentSite.isModal()) {
            IPageSite pageSite;
            IWorkbenchPart part = parentSite.getPart();
            if (part != null) {
                IWorkbenchPartSite workbenchPartSite = part.getSite();
                workbenchPartSite.registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
            }
            if ((pageSite = parentSite.getWorkbenchPageSite()) != null) {
                IActionBars actionBars = pageSite.getActionBars();
                IMenuManager actionBarsMenu = actionBars.getMenuManager();
                if (actionBarsMenu != null) {
                    actionBarsMenu.removeAll();
                }
                actionBars.updateActionBars();
            }
        }
        if ((tbm = parentSite.getToolBarManager()) != null) {
            String fileNameQualifier = this.getFileNameQualifier();
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "grouping"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "grouping", (IAction)this.groupByDateMode);
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "collapse"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "collapse", (IAction)this.collapseAll);
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "collapse", (IAction)this.compareModeAction);
            tbm.update(false);
        }
    }

    private String getFileNameQualifier() {
        if (this.file != null) {
            return this.file.getFullPath().toString();
        }
        return "";
    }

    protected void fillTableMenu(IMenuManager manager) {
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        manager.add((IContributionItem)new Separator("additions"));
        if (this.file != null && !parentSite.isModal()) {
            IStructuredSelection tempSelection;
            manager.add((IAction)this.openAction);
            manager.add((IAction)this.compareAction);
            ISelection sel = this.treeViewer.getSelection();
            if (!sel.isEmpty() && sel instanceof IStructuredSelection && (tempSelection = (IStructuredSelection)sel).size() == 1) {
                manager.add((IContributionItem)new Separator("getContents"));
                manager.add((IAction)this.getContentsAction);
            }
        }
    }

    protected TreeViewer createTree(Composite parent) {
        this.historyTableProvider = new LocalHistoryTableProvider();
        TreeViewer viewer = this.historyTableProvider.createTree(parent);
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (LocalHistoryPage.this.entries != null) {
                    return LocalHistoryPage.this.entries;
                }
                if (!(inputElement instanceof IFileHistory) && !(inputElement instanceof AbstractHistoryCategory[])) {
                    return new Object[0];
                }
                if (inputElement instanceof AbstractHistoryCategory[]) {
                    return (AbstractHistoryCategory[])inputElement;
                }
                IFileHistory fileHistory = (IFileHistory)inputElement;
                LocalHistoryPage.this.entries = fileHistory.getFileRevisions();
                return LocalHistoryPage.this.entries;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                LocalHistoryPage.this.entries = null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof AbstractHistoryCategory) {
                    return ((AbstractHistoryCategory)parentElement).getRevisions();
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof AbstractHistoryCategory) {
                    return ((AbstractHistoryCategory)element).hasRevisions();
                }
                return false;
            }
        });
        return viewer;
    }

    public Control getControl() {
        return this.localComposite;
    }

    public void setFocus() {
        this.localComposite.setFocus();
    }

    public String getDescription() {
        if (this.file != null) {
            return this.file.getFullPath().toString();
        }
        return null;
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public boolean isValidInput(Object object) {
        return object instanceof IFile && !RepositoryProvider.isShared((IProject)((IFile)object).getProject());
    }

    public void refresh() {
        this.refreshHistory(true);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void dispose() {
        this.shutdown = true;
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.resourceListener = null;
        }
        if (this.refreshFileHistoryJob != null && this.refreshFileHistoryJob.getState() != 0) {
            this.refreshFileHistoryJob.cancel();
        }
    }

    public IFileRevision getCurrentFileRevision() {
        if (this.currentFileRevision != null) {
            return this.currentFileRevision;
        }
        if (this.file != null) {
            this.currentFileRevision = new LocalFileRevision(this.file);
        }
        return this.currentFileRevision;
    }

    private Action getContextMenuAction(String title, final boolean needsProgressDialog, final IWorkspaceRunnable action) {
        return new Action(title){

            public void run() {
                block9: {
                    try {
                        if (LocalHistoryPage.this.file == null) {
                            return;
                        }
                        ISelection selection = LocalHistoryPage.this.treeViewer.getSelection();
                        if (!(selection instanceof IStructuredSelection)) {
                            return;
                        }
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        Object o = ss.getFirstElement();
                        if (o instanceof AbstractHistoryCategory) {
                            return;
                        }
                        LocalHistoryPage.this.currentSelection = (IFileRevision)o;
                        if (needsProgressDialog) {
                            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(this, action){
                                final /* synthetic */ 12 this$1;
                                private final /* synthetic */ IWorkspaceRunnable val$action;
                                {
                                    this.this$1 = var1_1;
                                    this.val$action = iWorkspaceRunnable;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        this.val$action.run(monitor);
                                    }
                                    catch (CoreException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                            });
                            break block9;
                        }
                        try {
                            action.run(null);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (InvocationTargetException e) {
                        IHistoryPageSite parentSite = LocalHistoryPage.this.getHistoryPageSite();
                        Utils.handleError(parentSite.getShell(), e, null, null);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public boolean isEnabled() {
                ISelection selection = LocalHistoryPage.this.treeViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                return ss.size() == 1;
            }
        };
    }

    private boolean confirmOverwrite() {
        if (this.file != null && this.file.exists()) {
            String title = TeamUIMessages.LocalHistoryPage_OverwriteTitle;
            String msg = TeamUIMessages.LocalHistoryPage_OverwriteMessage;
            IHistoryPageSite parentSite = this.getHistoryPageSite();
            final MessageDialog dialog = new MessageDialog(parentSite.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            final int[] result = new int[1];
            parentSite.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    result[0] = dialog.open();
                }
            });
            if (result[0] != 0) {
                return false;
            }
        }
        return true;
    }

    private class HistoryResourceListener
    implements IResourceChangeListener {
        private HistoryResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            if (LocalHistoryPage.this.file == null) {
                return;
            }
            IResourceDelta resourceDelta = root.findMember(LocalHistoryPage.this.file.getFullPath());
            if (resourceDelta != null) {
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ HistoryResourceListener this$1;
                    {
                        this.this$1 = historyResourceListener;
                    }

                    public void run() {
                        HistoryResourceListener.access$1(this.this$1).refresh();
                    }
                });
            }
        }

        static /* synthetic */ LocalHistoryPage access$1(HistoryResourceListener historyResourceListener) {
            return historyResourceListener.LocalHistoryPage.this;
        }
    }

    private class RefreshFileHistory
    extends Job {
        private static final int NUMBER_OF_CATEGORIES = 4;
        private LocalFileHistory fileHistory;
        private AbstractHistoryCategory[] categories;
        private boolean grouping;
        private Object[] elementsToExpand;

        public RefreshFileHistory() {
            super(TeamUIMessages.LocalHistoryPage_FetchLocalHistoryMessage);
        }

        public void setFileHistory(LocalFileHistory fileHistory) {
            this.fileHistory = fileHistory;
        }

        public void setGrouping(boolean value) {
            this.grouping = value;
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            if (this.fileHistory != null && !LocalHistoryPage.this.shutdown) {
                try {
                    this.fileHistory.refresh(monitor);
                }
                catch (CoreException ex) {
                    status = new TeamStatus(ex.getStatus().getSeverity(), "org.eclipse.team.ui", ex.getStatus().getCode(), ex.getMessage(), (Throwable)ex, (IResource)LocalHistoryPage.this.file);
                }
                if (this.grouping) {
                    this.sortRevisions();
                }
                Utils.asyncExec(new Runnable(this){
                    final /* synthetic */ RefreshFileHistory this$1;
                    {
                        this.this$1 = refreshFileHistory;
                    }

                    public void run() {
                        RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).historyTableProvider.setFile(RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).file);
                        if (RefreshFileHistory.access$0(this.this$1)) {
                            RefreshFileHistory.access$1(this.this$1, RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.getExpandedElements());
                            RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.getTree().setRedraw(false);
                            RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.setInput((Object)RefreshFileHistory.access$2(this.this$1));
                            if (RefreshFileHistory.access$3(this.this$1).length > 0) {
                                RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.setExpandedElements(RefreshFileHistory.access$3(this.this$1));
                            } else {
                                RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.expandAll();
                                Object[] el = RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.getExpandedElements();
                                if (el != null && el.length > 0) {
                                    RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.setSelection((ISelection)new StructuredSelection(el[0]));
                                    RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.getTree().deselectAll();
                                }
                            }
                            RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.getTree().setRedraw(true);
                        } else if (RefreshFileHistory.access$4(this.this$1).getFileRevisions().length > 0) {
                            RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.setInput((Object)RefreshFileHistory.access$4(this.this$1));
                        } else {
                            RefreshFileHistory.access$6(this.this$1, new AbstractHistoryCategory[]{RefreshFileHistory.access$5(this.this$1)});
                            RefreshFileHistory.access$7((RefreshFileHistory)this.this$1).treeViewer.setInput((Object)RefreshFileHistory.access$2(this.this$1));
                        }
                    }
                }, (StructuredViewer)LocalHistoryPage.this.treeViewer);
            }
            if (status != Status.OK_STATUS) {
                this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
            }
            return status;
        }

        private void mapExpandedElements(Object[] expandedElements) {
            HashMap elementMap = new HashMap();
            int i = 0;
            while (i < expandedElements.length) {
                elementMap.put(((DateHistoryCategory)expandedElements[i]).getName(), null);
                ++i;
            }
            ArrayList<AbstractHistoryCategory> expandable = new ArrayList<AbstractHistoryCategory>();
            int i2 = 0;
            while (i2 < this.categories.length) {
                if (elementMap.containsKey(this.categories[i2].getName())) {
                    expandable.add(this.categories[i2]);
                }
                ++i2;
            }
            this.elementsToExpand = new Object[expandable.size()];
            this.elementsToExpand = expandable.toArray(new Object[expandable.size()]);
        }

        private boolean sortRevisions() {
            IFileRevision[] fileRevision = this.fileHistory.getFileRevisions();
            DateHistoryCategory[] tempCategories = new DateHistoryCategory[4];
            Calendar currentCal = Calendar.getInstance();
            tempCategories[0] = new DateHistoryCategory(TeamUIMessages.HistoryPage_Today, currentCal, null);
            Calendar yesterdayCal = Calendar.getInstance();
            yesterdayCal.roll(6, -1);
            tempCategories[1] = new DateHistoryCategory(TeamUIMessages.HistoryPage_Yesterday, yesterdayCal, null);
            Calendar monthCal = Calendar.getInstance();
            monthCal.set(5, 1);
            tempCategories[2] = new DateHistoryCategory(TeamUIMessages.HistoryPage_ThisMonth, monthCal, yesterdayCal);
            tempCategories[3] = new DateHistoryCategory(TeamUIMessages.HistoryPage_Previous, null, monthCal);
            ArrayList<AbstractHistoryCategory> finalCategories = new ArrayList<AbstractHistoryCategory>();
            int i = 0;
            while (i < 4) {
                tempCategories[i].collectFileRevisions(fileRevision, false);
                if (tempCategories[i].hasRevisions()) {
                    finalCategories.add(tempCategories[i]);
                }
                ++i;
            }
            boolean revisionsFound = true;
            if (finalCategories.size() == 0) {
                finalCategories.add(this.getErrorMessage());
                revisionsFound = false;
            }
            this.categories = finalCategories.toArray(new AbstractHistoryCategory[finalCategories.size()]);
            return revisionsFound;
        }

        private MessageHistoryCategory getErrorMessage() {
            MessageHistoryCategory messageCategory = new MessageHistoryCategory(TeamUIMessages.LocalHistoryPage_NoRevisionsFound);
            return messageCategory;
        }

        static /* synthetic */ boolean access$0(RefreshFileHistory refreshFileHistory) {
            return refreshFileHistory.grouping;
        }

        static /* synthetic */ void access$1(RefreshFileHistory refreshFileHistory, Object[] objectArray) {
            refreshFileHistory.mapExpandedElements(objectArray);
        }

        static /* synthetic */ AbstractHistoryCategory[] access$2(RefreshFileHistory refreshFileHistory) {
            return refreshFileHistory.categories;
        }

        static /* synthetic */ Object[] access$3(RefreshFileHistory refreshFileHistory) {
            return refreshFileHistory.elementsToExpand;
        }

        static /* synthetic */ LocalFileHistory access$4(RefreshFileHistory refreshFileHistory) {
            return refreshFileHistory.fileHistory;
        }

        static /* synthetic */ MessageHistoryCategory access$5(RefreshFileHistory refreshFileHistory) {
            return refreshFileHistory.getErrorMessage();
        }

        static /* synthetic */ void access$6(RefreshFileHistory refreshFileHistory, AbstractHistoryCategory[] abstractHistoryCategoryArray) {
            refreshFileHistory.categories = abstractHistoryCategoryArray;
        }

        static /* synthetic */ LocalHistoryPage access$7(RefreshFileHistory refreshFileHistory) {
            return refreshFileHistory.LocalHistoryPage.this;
        }
    }
}

