/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.wizards;

import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ExportMSPResources;
import org.eclipse.epf.export.msp.ui.wizards.ExportMSPWizard;
import org.eclipse.epf.export.msp.ui.wizards.IExportMSPWizardExtender;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SelectExportDirectoryPage
extends WizardPage
implements Listener {
    public static final String PAGE_NAME;
    private Combo templateNameCombo;
    private Combo templateDirCombo;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SelectExportDirectoryPage.this.setPageComplete(SelectExportDirectoryPage.this.isPageComplete());
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.export.msp.ui.wizards.SelectExportDirectoryPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public SelectExportDirectoryPage() {
        super(PAGE_NAME);
        this.setTitle(ExportMSPResources.selectExportDirWizardPage_title);
        this.setDescription(ExportMSPResources.selectExportDirWizardPage_text);
        this.setImageDescriptor(ExportMSPPlugin.getDefault().getImageDescriptor("full/wizban/ExportMSProject.gif"));
    }

    public void createControl(Composite parent) {
        final Shell shell = parent.getShell();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(768));
        Composite templateComposite = new Composite(composite, 0);
        templateComposite.setLayout((Layout)new GridLayout(3, false));
        templateComposite.setLayoutData((Object)new GridData(768));
        Label templateNameLabel = new Label(templateComposite, 0);
        templateNameLabel.setText(ExportMSPResources.projectNameLabel_text);
        this.templateNameCombo = new Combo(templateComposite, 2048);
        this.templateNameCombo.setLayoutData((Object)new GridData(768));
        String prevName = ExportMSPPlugin.getDefault().getPreferenceStore().getString("templateNames");
        if (prevName != null) {
            this.templateNameCombo.add(prevName);
        }
        this.templateNameCombo.addModifyListener(this.modifyListener);
        new Label(templateComposite, 0);
        Label dirLabel = new Label(templateComposite, 0);
        dirLabel.setText(ExportMSPResources.dirLabel_text);
        this.templateDirCombo = new Combo(templateComposite, 2048);
        this.templateDirCombo.setLayoutData((Object)new GridData(768));
        String savedDir = ExportMSPPlugin.getDefault().getPreferenceStore().getString("targetDirs");
        if (savedDir != null) {
            this.templateDirCombo.add(savedDir);
            this.templateDirCombo.setText(savedDir);
        }
        this.templateDirCombo.addModifyListener(this.modifyListener);
        Button browseButton = new Button(templateComposite, 0);
        browseButton.setText(ExportMSPResources.browseButton_text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    DirectoryDialog dialog = new DirectoryDialog(shell, 0);
                    String selectedDir = dialog.open();
                    if (selectedDir != null) {
                        SelectExportDirectoryPage.this.templateDirCombo.add(selectedDir, 0);
                        SelectExportDirectoryPage.this.templateDirCombo.setText(selectedDir);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.setControl((Control)composite);
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return this.templateNameCombo.getText().trim().length() > 0 && this.templateDirCombo.getText().trim().length() > 0;
    }

    public IWizardPage getNextPage() {
        IWizardPage page;
        ExportMSPWizard wizard = (ExportMSPWizard)this.getWizard();
        IExportMSPWizardExtender wizardExtender = wizard.getWizardExtender();
        if (wizardExtender != null && (page = wizardExtender.getNextPage((IWizardPage)this)) != null) {
            return page;
        }
        return null;
    }

    public String getTemplateName() {
        return this.templateNameCombo.getText();
    }

    public String getTargetDirectory() {
        return this.templateDirCombo.getText();
    }
}

