/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.StringMatcher;
import org.eclipse.ui.internal.navigator.filters.CommonFilterContentProvider;
import org.eclipse.ui.internal.navigator.filters.CommonFilterLabelProvider;
import org.eclipse.ui.internal.navigator.filters.CustomizationTab;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class CommonFiltersTab
extends CustomizationTab {
    private String initialFilterTextValue = CommonNavigatorMessages.CommonFilterSelectionDialog_enter_name_of_filte_;
    private Text filterText;
    private ILabelProvider filterLabelProvider = new CommonFilterLabelProvider();
    private CommonFilterContentProvider filterContentProvider = new CommonFilterContentProvider();
    private TablePatternFilter patternFilter = new TablePatternFilter();

    protected CommonFiltersTab(Composite parent, INavigatorContentService aContentService) {
        super(parent, aContentService);
        this.createControl();
    }

    private void createControl() {
        this.createPatternFilterText(this);
        this.createTable();
        this.createInstructionsLabel(CommonNavigatorMessages.CommonFilterSelectionDialog_Select_the_filters_to_apply);
        this.getTableViewer().setContentProvider((IContentProvider)this.filterContentProvider);
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)this.filterLabelProvider);
        this.getTableViewer().setSorter((ViewerSorter)new CommonFilterSorter());
        this.getTableViewer().setInput((Object)this.getContentService());
        this.getTableViewer().addFilter((ViewerFilter)this.patternFilter);
        this.updateFiltersCheckState();
    }

    private void createPatternFilterText(Composite composite) {
        this.filterText = new Text(composite, 2052);
        GridData filterTextGridData = new GridData(768);
        this.filterText.setLayoutData((Object)filterTextGridData);
        this.filterText.setText(this.initialFilterTextValue);
        this.filterText.setFont(composite.getFont());
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = CommonFiltersTab.this.filterText.getText();
                e.result = filterTextString.length() == 0 ? CommonFiltersTab.this.initialFilterTextValue : filterTextString;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (CommonFiltersTab.this.initialFilterTextValue.equals(CommonFiltersTab.this.filterText.getText().trim())) {
                    CommonFiltersTab.this.filterText.selectAll();
                }
            }
        });
        this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                super.mouseUp(e);
                if (CommonFiltersTab.this.initialFilterTextValue.equals(CommonFiltersTab.this.filterText.getText().trim())) {
                    CommonFiltersTab.this.filterText.selectAll();
                }
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = CommonFiltersTab.this.getTable().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    CommonFiltersTab.this.getTable().setFocus();
                } else if (e.character == '\r') {
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (CommonFiltersTab.this.getTableViewer().getTable().getItemCount() == 0) {
                        Display.getCurrent().beep();
                    } else {
                        TableItem item;
                        boolean textChanged;
                        boolean hasFocus = CommonFiltersTab.this.getTable().setFocus();
                        boolean bl = textChanged = !CommonFiltersTab.this.initialFilterTextValue.equals(CommonFiltersTab.this.filterText.getText().trim());
                        if (hasFocus && textChanged && CommonFiltersTab.this.filterText.getText().trim().length() > 0 && (item = this.getFirstHighlightedItem(CommonFiltersTab.this.getTable().getItems())) != null) {
                            CommonFiltersTab.this.getTable().setSelection(new TableItem[]{item});
                            ISelection sel = CommonFiltersTab.this.getTableViewer().getSelection();
                            CommonFiltersTab.this.getTableViewer().setSelection(sel, true);
                        }
                    }
                }
            }

            private TableItem getFirstHighlightedItem(TableItem[] items) {
                int i = 0;
                while (i < items.length) {
                    if (CommonFiltersTab.this.patternFilter.match(items[i].getText())) {
                        return items[i];
                    }
                    ++i;
                }
                return null;
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonFiltersTab.this.textChanged();
            }
        });
    }

    private void textChanged() {
        this.patternFilter.setPattern(this.filterText.getText());
        this.getTableViewer().refresh();
    }

    private void updateFiltersCheckState() {
        Object[] children = this.filterContentProvider.getElements(this.getContentService());
        INavigatorFilterService filterService = this.getContentService().getFilterService();
        int i = 0;
        while (i < children.length) {
            ICommonFilterDescriptor filterDescriptor = (ICommonFilterDescriptor)children[i];
            this.getTableViewer().setChecked(children[i], filterService.isActive(filterDescriptor.getId()));
            ++i;
        }
    }

    private class CommonFilterSorter
    extends ViewerSorter {
        private CommonFilterSorter() {
        }

        public void sort(Viewer viewer, Object[] elements) {
            Arrays.sort(elements, new Comparator(this){
                final /* synthetic */ CommonFilterSorter this$1;
                {
                    this.this$1 = commonFilterSorter;
                }

                public int compare(Object o1, Object o2) {
                    ICommonFilterDescriptor lvalue = (ICommonFilterDescriptor)o1;
                    ICommonFilterDescriptor rvalue = (ICommonFilterDescriptor)o2;
                    return lvalue.getName().compareTo(rvalue.getName());
                }
            });
        }
    }

    private class TablePatternFilter
    extends ViewerFilter {
        private StringMatcher matcher = null;

        private TablePatternFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.match(CommonFiltersTab.this.filterLabelProvider.getText(element));
        }

        protected void setPattern(String newPattern) {
            if (newPattern == null || newPattern.trim().length() == 0) {
                this.matcher = new StringMatcher("*", true, false);
            } else {
                String patternString = "*" + newPattern + "*";
                this.matcher = new StringMatcher(patternString, true, false);
            }
        }

        protected boolean match(String input) {
            if (input == null) {
                return false;
            }
            return this.matcher == null || this.matcher.match(input);
        }

        protected boolean match(TableItem tableItem) {
            if (tableItem == null || tableItem.getData() == null) {
                return false;
            }
            return this.match(CommonFiltersTab.this.filterLabelProvider.getText(tableItem.getData()));
        }
    }
}

