/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.toc.Anchor;
import org.eclipse.help.internal.toc.HrefUtil;
import org.eclipse.help.internal.toc.Link;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileParser;
import org.eclipse.help.internal.toc.TocNode;
import org.eclipse.help.internal.toc.Topic;

public class TocBuilder {
    protected Collection contributedTocFiles;
    protected Collection unprocessedTocFiles = new ArrayList();
    protected List unprocessedTocs = new ArrayList();

    public List getBuiltTocs() {
        ArrayList<Toc> tocCol = new ArrayList<Toc>(this.contributedTocFiles.size());
        Iterator it = this.contributedTocFiles.iterator();
        while (it.hasNext()) {
            TocFile tocFile = (TocFile)it.next();
            Toc toc = tocFile.getToc();
            if (toc == null || !toc.getTocFile().isPrimary() || this.isIntegrated(toc)) continue;
            tocCol.add(toc);
        }
        return tocCol;
    }

    public void build(Collection contributedTocFiles) {
        this.contributedTocFiles = contributedTocFiles;
        this.unprocessedTocFiles.addAll(contributedTocFiles);
        while (!this.unprocessedTocFiles.isEmpty()) {
            TocFile tocFile = (TocFile)this.unprocessedTocFiles.iterator().next();
            tocFile.build(this);
        }
        int remaining = this.unprocessedTocs.size();
        int i = 0;
        while (i < remaining) {
            Toc toc = (Toc)this.unprocessedTocs.get(i);
            this.buildToc(toc);
            ++i;
        }
    }

    public void buildTocFile(TocFile tocFile) {
        try {
            this.unprocessedTocFiles.remove(tocFile);
            TocFileParser parser = new TocFileParser(this);
            parser.parse(tocFile);
        }
        catch (Exception e) {
            String msg = "Error occurred processing file " + tocFile.getHref() + ".";
            HelpPlugin.logError(msg, e);
        }
    }

    public void buildAnchor(Anchor anchor) {
        anchor.getTocFile().addAnchor(anchor);
    }

    public void buildLink(Link link) {
        String linkedToc = link.getToc();
        TocFile includedTocFile = this.getTocFile(linkedToc);
        if (includedTocFile == null) {
            return;
        }
        Toc toc = includedTocFile.getToc();
        if (toc == null) {
            return;
        }
        link.addChild(toc);
    }

    public void buildTopic(Topic topic) {
    }

    public void buildToc(Toc toc) {
        String href = toc.getLink_to();
        if (href == null || href.equals("")) {
            return;
        }
        TocFile targetTocFile = this.getTocFile(href);
        if (targetTocFile == null) {
            return;
        }
        Anchor anchor = targetTocFile.getAnchor(href);
        if (anchor == null) {
            this.unprocessedTocs.add(toc);
            return;
        }
        anchor.addChild(toc);
    }

    private TocFile getTocFile(String href) {
        String plugin = HrefUtil.getPluginIDFromHref(href);
        if (plugin == null) {
            return null;
        }
        String path = HrefUtil.getResourcePathFromHref(href);
        if (path == null) {
            return null;
        }
        TocFile tocFile = null;
        Iterator it = this.contributedTocFiles.iterator();
        while (it.hasNext()) {
            tocFile = (TocFile)it.next();
            if (tocFile.getPluginID().equals(plugin) && tocFile.getHref().equals(path)) break;
            tocFile = null;
        }
        if (tocFile == null) {
            return null;
        }
        if (this.unprocessedTocFiles.contains(tocFile)) {
            this.buildTocFile(tocFile);
        }
        return tocFile;
    }

    private boolean isIntegrated(TocNode element) {
        Iterator it = element.getParents().iterator();
        while (it.hasNext()) {
            TocNode parent = (TocNode)it.next();
            if (parent instanceof Toc && ((Toc)parent).getTocFile().isPrimary()) {
                return true;
            }
            if (!this.isIntegrated(parent)) continue;
            return true;
        }
        return false;
    }
}

