/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.properties.BreakdownElementGeneralSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.Tab;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AbstractSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private BreakdownElement element;
    protected boolean editable = false;
    protected TabbedPropertySheetPage page;
    protected ProcessAuthoringConfigurator configurator = new ProcessAuthoringConfigurator(LibraryService.getInstance().getCurrentMethodConfiguration(), null);
    protected Logger logger;
    private ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        public void libraryChanged(int option, Collection collection) {
            switch (option) {
                case 8: {
                    AbstractSection.this.sectionRefresh();
                }
            }
        }
    };
    static /* synthetic */ Class class$0;

    public AbstractSection() {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.addListener(this.libraryListener);
        }
        this.logger = AuthoringUIPlugin.getDefault().getLogger();
    }

    public void createControls(Composite comp, TabbedPropertySheetPage page) {
        super.createControls(comp, page);
        this.page = page;
    }

    private void sectionRefresh() {
        ISection section;
        Tab tab;
        if (this.page != null && (tab = this.page.getCurrentTab()) != null && (section = tab.getSectionAtIndex(0)) != null && section instanceof BreakdownElementGeneralSection) {
            section.refresh();
        }
    }

    public void dispose() {
        ILibraryManager manager;
        super.dispose();
        if (this.libraryListener != null && (manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            manager.removeListener(this.libraryListener);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.initElementData(input);
    }

    private void initElementData(Object input) {
        if (input instanceof BreakdownElement) {
            this.element = (BreakdownElement)input;
            if (TngUtil.isLocked((EObject)this.element)) {
                this.editable = false;
            } else {
                this.editable = true;
                if (this.element instanceof RoleDescriptor) {
                    RoleDescriptor roleDesc = (RoleDescriptor)this.element;
                    this.editable = roleDesc.getSuperActivities() != null && roleDesc.getSuperActivities() != null;
                }
            }
        } else if (input instanceof BreakdownElementWrapperItemProvider) {
            this.element = (BreakdownElement)LibraryUtil.unwrap((Object)input);
            this.editable = false;
        }
    }

    public ISelection getSelection() {
        return EPFPropertySheetPage.getSelection();
    }

    public Object getInput() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object input = ((IStructuredSelection)selection).getFirstElement();
            return input;
        }
        return null;
    }

    public ProcessEditor getEditor() {
        return EPFPropertySheetPage.getEditor();
    }

    public ItemProviderAdapter getAdapter() {
        try {
            AdapterFactory factory = EPFPropertySheetPage.getAdapterFactory();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ItemProviderAdapter provider = (ItemProviderAdapter)factory.adapt((Notifier)this.element, (Object)clazz);
            return provider;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AdapterFactory getAdapterFactory() {
        AdapterFactory adapterFactory = EPFPropertySheetPage.getAdapterFactory();
        return adapterFactory;
    }

    public BreakdownElement getElement() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object input = ((IStructuredSelection)selection).getFirstElement();
            try {
                this.initElementData(input);
            }
            catch (Exception e) {
                this.logger.logError("Error getting element from the selection " + this.element, (Throwable)e);
                return null;
            }
            return this.element;
        }
        return null;
    }

    public TabbedPropertySheetPage getPropertySheetPage() {
        return this.page;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public List getFilteredList(List list) {
        ArrayList newList = new ArrayList();
        Iterator itor = list.iterator();
        while (itor.hasNext()) {
            if (this.configurator == null) continue;
            Object obj = itor.next();
            this.configurator.setMethodConfiguration(LibraryService.getInstance().getCurrentMethodConfiguration());
            if (!this.configurator.accept(obj)) continue;
            newList.add(obj);
        }
        return newList;
    }

    protected MethodConfiguration getDefaultConfiguration() {
        ItemProviderAdapter adapter = this.getAdapter();
        Object parent = null;
        if (adapter instanceof IBSItemProvider) {
            IBSItemProvider bsItemProvider = (IBSItemProvider)adapter;
            parent = bsItemProvider.getTopItem();
            MethodConfiguration config = ((Process)parent).getDefaultContext();
            return config;
        }
        this.logger.logError("AbstractSection::getDefaultConfiguration - IBSItemProvider is null");
        return null;
    }

    protected MethodConfiguration getConfiguration() {
        MethodConfiguration config = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (config == null) {
            return this.getDefaultConfiguration();
        }
        return config;
    }

    public String getNamePrefix() {
        return "ProcessElement: ";
    }
}

