/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public class LibraryUtil {
    public static String checkPluginName(MethodPlugin plugin, String newName) {
        String error = TngUtil.checkPluginName((String)newName);
        if (error != null) {
            return error;
        }
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        return IValidatorFactory.INSTANCE.createNameValidator((Object)lib, (NamedElement)plugin).isValid(newName);
    }

    public static boolean selectable(EObject element) {
        return element instanceof MethodLibrary || element instanceof MethodPlugin || element instanceof MethodPackage;
    }

    public static EObject getSelectable(EObject element) {
        if (element instanceof BreakdownElement) {
            ProcessPackage pkg = (ProcessPackage)element.eContainer();
            if (pkg instanceof ProcessComponent) {
                return pkg;
            }
            if (pkg != null) {
                return pkg.eContainer();
            }
            return null;
        }
        EObject parent = element;
        while (parent != null && !LibraryUtil.selectable(parent)) {
            parent = parent.eContainer();
        }
        return parent;
    }

    public static MethodPlugin getMethodPlugin(EObject element) {
        return UmaUtil.getMethodPlugin((EObject)element);
    }

    public static String getName(Object element) {
        if (element == null) {
            return LibraryResources.unknown_text;
        }
        if (element instanceof MethodElement) {
            return LibraryUtil.getFullName((MethodElement)element);
        }
        return element.toString();
    }

    public static String getFullName(MethodElement element) {
        if (LibraryUtil.selectable((EObject)element)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[").append(element.getName()).append("]");
            MethodElement parent = element;
            while ((parent = (MethodElement)parent.eContainer()) != null) {
                if (parent instanceof MethodLibrary) break;
                buffer.insert(0, "[" + parent.getName() + "].");
            }
            return buffer.toString();
        }
        return element.getName();
    }

    public static String getLocalizeTypeName(MethodElement element) {
        if (element == null) {
            return "";
        }
        if (element instanceof DescribableElement) {
            String nameStr = String.valueOf(TngUtil.getTypeText((EObject)element)) + LibraryResources.colon_with_space;
            nameStr = ((DescribableElement)element).getPresentationName() != null ? String.valueOf(nameStr) + "(" + ((DescribableElement)element).getPresentationName() + ") " + ((DescribableElement)element).getName() : String.valueOf(nameStr) + element.getName();
            return nameStr;
        }
        return LibraryUtil.getTypeName(element);
    }

    public static String getTypeName(MethodElement element) {
        return element == null ? "" : String.valueOf(element.getType().getName()) + ":" + element.getName();
    }

    public static List getMethodPlugins(MethodLibrary library) {
        ArrayList<EObject> items = new ArrayList<EObject>();
        EList elements = library.eContents();
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                EObject element = (EObject)it.next();
                if (!(element instanceof MethodPlugin)) continue;
                items.add(element);
            }
        }
        return items;
    }

    public static List getMethodPluginGuids(MethodLibrary library) {
        ArrayList<String> items = new ArrayList<String>();
        List elements = library.getMethodPlugins();
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                MethodPlugin element = (MethodPlugin)it.next();
                items.add(element.getGuid());
            }
        }
        return items;
    }

    public static MethodPlugin getMethodPlugin(MethodLibrary library, String pluginGuid) {
        if (pluginGuid == null) {
            return null;
        }
        List elements = library.getMethodPlugins();
        if (elements != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                MethodPlugin element = (MethodPlugin)it.next();
                if (!pluginGuid.equals(element.getGuid())) continue;
                return element;
            }
        }
        return null;
    }

    public static List getMethodPackages(MethodElement element) {
        ArrayList<EObject> items = new ArrayList<EObject>();
        TreeIterator it = element.eAllContents();
        while (it.hasNext()) {
            EObject e = (EObject)it.next();
            if (!(e instanceof MethodPackage)) continue;
            items.add(e);
        }
        return items;
    }

    public static Object unwrap(Object obj) {
        return TngUtil.unwrap((Object)obj);
    }

    public static Command unwrap(Command cmd) {
        return TngUtil.unwrap((Command)cmd);
    }

    public static void detachFromResource(MethodLibrary importLibraty) {
        ResourceSet resSet = null;
        Resource res = importLibraty.eResource();
        if (res != null) {
            resSet = res.getResourceSet();
        }
        if (resSet != null) {
            TreeIterator it = resSet.getAllContents();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof MultiResourceEObject)) continue;
                ((MultiResourceEObject)obj).eSetResource(null);
            }
        }
        LibraryUtil.clearProxies((EObject)importLibraty);
    }

    public static void clearProxies(EObject element) {
        if (element.eIsProxy()) {
            LibraryUtil.setProxyURI(element, null);
        } else {
            TreeIterator it = element.eAllContents();
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!o.eIsProxy()) continue;
                LibraryUtil.setProxyURI(o, null);
            }
        }
    }

    public static void setProxyURI(EObject obj, URI uri) {
        ((InternalEObject)obj).eSetProxyURI(uri);
    }

    public static void loadAll(MethodLibrary lib) {
        TreeIterator iter = lib.eAllContents();
        while (iter.hasNext()) {
            try {
                EObject element = (EObject)iter.next();
                Iterator iterator = element.eCrossReferences().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            catch (Exception e) {
                LibraryEditPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public static void loadAllProcesses(MethodLibrary lib) {
        Iterator iter = lib.getMethodPlugins().iterator();
        while (iter.hasNext()) {
            try {
                MethodPlugin plugin = (MethodPlugin)iter.next();
                TngUtil.getAllProcesses((MethodPlugin)plugin);
            }
            catch (Exception e) {
                LibraryEditPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public static void saveAll(MethodLibrary lib) throws Exception {
        LibraryUtil.saveLibrary(lib, true, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveLibrary(MethodLibrary lib, boolean saveAll, boolean refresh) throws Exception {
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)lib.eResource().getResourceSet();
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        Map saveOptions = manager != null ? manager.getSaveOptions() : new HashMap();
        Object old = saveOptions.get("REFRESH_NEW_RESOURCE");
        Object oldCheckModify = saveOptions.get("CHECK_MODIFY");
        try {
            saveOptions.put("REFRESH_NEW_RESOURCE", refresh ? "true" : "false");
            saveOptions.put("CHECK_MODIFY", "false");
            resourceSet.save(saveOptions, saveAll);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            saveOptions.put("REFRESH_NEW_RESOURCE", old);
            saveOptions.put("CHECK_MODIFY", oldCheckModify);
            throw throwable;
        }
        {
            Object var8_10 = null;
            saveOptions.put("REFRESH_NEW_RESOURCE", old);
        }
        saveOptions.put("CHECK_MODIFY", oldCheckModify);
    }

    public static MethodLibrary loadLibrary(String libraryPath) throws Exception {
        MultiFileResourceSetImpl resourceSet = new MultiFileResourceSetImpl();
        return resourceSet.loadLibrary(libraryPath);
    }

    public static File getLibraryRootPath(MethodLibrary lib) {
        Resource res = lib.eResource();
        if (res == null) {
            return null;
        }
        URI uri = res.getURI();
        String path = uri.toFileString();
        File f = new File(path);
        return f.getParentFile();
    }

    public static List getAllPackages(MethodPlugin plugin) {
        ArrayList allPkgs = new ArrayList();
        List pkgs = plugin.getMethodPackages();
        allPkgs.addAll(pkgs);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)it.next(), allPkgs);
        }
        return allPkgs;
    }

    public static void getAllChildPackages(MethodPackage pkg, List result) {
        List pkgs = pkg.getChildPackages();
        result.addAll(pkgs);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            LibraryUtil.getAllChildPackages((MethodPackage)it.next(), result);
        }
    }

    public static List getAssociatedConfigurations(MethodPlugin plugin) {
        ArrayList<MethodConfiguration> allConfigs = new ArrayList<MethodConfiguration>();
        List configs = (List)((MultiResourceEObject)plugin).getOppositeFeatureValue(AssociationHelper.MethodPlugin_MethodConfigurations);
        LibraryUtil.addUniqueItems(configs, allConfigs);
        List pkgs = LibraryUtil.getAllPackages(plugin);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            MultiResourceEObject o = (MultiResourceEObject)it.next();
            configs = (List)o.getOppositeFeatureValue(AssociationHelper.MethodPackage_MethodConfigurations);
            LibraryUtil.addUniqueItems(configs, allConfigs);
        }
        List procs = TngUtil.getAllProcesses((MethodPlugin)plugin);
        Iterator it2 = procs.iterator();
        while (it2.hasNext()) {
            Process p = (Process)it2.next();
            MethodConfiguration c = p.getDefaultContext();
            if (c != null && !allConfigs.contains(c)) {
                allConfigs.add(c);
            }
            LibraryUtil.addUniqueItems(p.getValidContext(), allConfigs);
        }
        return allConfigs;
    }

    private static void addUniqueItems(List from, List to) {
        if (from == null || to == null || from.size() == 0) {
            return;
        }
        Iterator it = from.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (to.contains(o)) continue;
            to.add(o);
        }
    }

    public static void validateMethodConfiguration(MethodConfiguration config) {
        TngUtil.validateMethodConfiguration((MethodConfiguration)config);
    }

    public static SupportingMaterial getCopyright(MethodElement element) {
        MethodPlugin p;
        SupportingMaterial sm = null;
        if (element instanceof MethodUnit) {
            sm = ((MethodUnit)element).getCopyrightStatement();
        } else if (element instanceof DescribableElement) {
            sm = ((DescribableElement)element).getPresentation().getCopyrightStatement();
        }
        if (sm == null && (p = LibraryUtil.getMethodPlugin((EObject)element)) != null) {
            sm = p.getCopyrightStatement();
        }
        return sm;
    }

    public static Collection getContainedElements(Object container, Collection elements) {
        if (container instanceof TransientGroupItemProvider) {
            container = ((TransientGroupItemProvider)container).getTarget();
        }
        ArrayList contained = new ArrayList();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof EObject) || !UmaUtil.isContainedBy((EObject)((EObject)element), (Object)container)) continue;
            contained.add(element);
        }
        return contained;
    }

    public static boolean isIdentical(MethodElement oldObj, MethodElement newObj) {
        if (oldObj == null && newObj == null) {
            return true;
        }
        if (oldObj == null || newObj == null) {
            return false;
        }
        List properties = oldObj.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object oldValue = oldObj.eGet(feature);
                Object newValue = newObj.eGet(feature);
                if (oldValue != null || newValue != null) {
                    if (oldValue == null || newValue == null) {
                        return false;
                    }
                    if (oldValue instanceof MethodElement) {
                        MethodElement olde = (MethodElement)oldValue;
                        if (olde.eContainer() == oldObj ? !LibraryUtil.isIdentical(olde, (MethodElement)newValue) : oldValue != newValue) {
                            return false;
                        }
                    } else if (oldValue instanceof List) {
                        List oldl = (List)oldValue;
                        List newl = (List)newValue;
                        if (oldl.size() != newl.size()) {
                            return false;
                        }
                        int x = 0;
                        while (x < oldl.size()) {
                            MethodElement olde;
                            Object o = oldl.get(x);
                            Object n = newl.get(x);
                            if (o instanceof MethodElement ? ((olde = (MethodElement)o).eContainer() == oldObj ? !LibraryUtil.isIdentical(olde, (MethodElement)n) : oldValue != newValue) : !o.equals(n)) {
                                return false;
                            }
                            ++x;
                        }
                    } else if (!oldValue.equals(newValue)) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isProcess(EObject e) {
        return e instanceof Process && e.eContainer() instanceof ProcessComponent;
    }
}

