/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.IConfigurationClosure;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementDependencyError;
import org.eclipse.epf.library.configuration.ErrorInfo;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.DependencyManager;
import org.eclipse.epf.library.services.ElementDependency;
import org.eclipse.epf.library.services.ElementReference;
import org.eclipse.epf.library.services.PackageDependency;
import org.eclipse.epf.library.services.PackageReference;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class ConfigurationClosure
implements IConfigurationClosure {
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodConfiguration config = null;
    protected MethodLibrary library = null;
    protected IConfigurationManager configManager = null;
    protected DependencyManager dependencyManager = null;
    protected List selected = new ArrayList();
    protected Map invalidNodesMap = new HashMap();
    protected List changedNodes = new ArrayList();

    public ConfigurationClosure(MethodConfiguration config) {
        this.config = config;
        this.configManager = LibraryService.getInstance().getConfigurationManager(config);
        if (this.configManager != null) {
            this.library = this.configManager.getMethodLibrary();
            this.dependencyManager = this.configManager.getDependencyManager();
        }
        this.selected.clear();
        this.changedNodes.clear();
        this.invalidNodesMap.clear();
        try {
            this.buildList((EObject)this.library);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public IConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    public MethodConfiguration getConfiguration() {
        return this.config;
    }

    public MethodLibrary getLibrary() {
        return this.library;
    }

    private void buildList(EObject input) {
        LibraryUtil.validateMethodConfiguration(this.config);
        this.selected.addAll(this.config.getMethodPluginSelection());
        this.selected.addAll(this.config.getMethodPackageSelection());
        this.setSelections(this.selected.toArray());
    }

    public void setSelections(Object[] elements) {
        if (elements == null) {
            return;
        }
        this.selected.clear();
        this.changedNodes.clear();
        this.invalidNodesMap.clear();
        this.beginUpdate();
        int i = 0;
        while (i < elements.length) {
            Object e = elements[i];
            if (!this.selected.contains(e)) {
                if (e instanceof EObject) {
                    this.add((EObject)e, false);
                    if (e instanceof ProcessComponent) {
                        this.selectProcessPackages((Activity)((ProcessComponent)e).getProcess());
                    }
                } else {
                    this.selected.add(e);
                }
            }
            ++i;
        }
        this.endUpdate();
    }

    private void selectProcessPackages(Activity a) {
        if (a == null) {
            return;
        }
        Iterator it = a.getBreakdownElements().iterator();
        while (it.hasNext()) {
            BreakdownElement e = (BreakdownElement)it.next();
            EObject pkg = e.eContainer();
            if (!this.selected.contains(pkg)) {
                this.selected.add(pkg);
                this.changedNodes.add(pkg);
            }
            if (!(e instanceof Activity)) continue;
            this.selectProcessPackages((Activity)e);
        }
    }

    private void add(EObject element, boolean addChildren) {
        EList elements;
        EObject parent;
        if (!LibraryUtil.selectable(element)) {
            return;
        }
        if (!this.selected.contains(element)) {
            this.selected.add(element);
            this.addChanged(element);
            if (element instanceof MethodPlugin) {
                this.selectSystemPackages((MethodPlugin)element);
            }
        }
        if ((parent = element.eContainer()) != null && !this.selected.contains(parent)) {
            this.add(parent, false);
        }
        if (addChildren && (elements = element.eContents()) != null) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                EObject child = (EObject)it.next();
                this.add(child, true);
            }
        }
    }

    private void addChanged(Object element) {
        if (!this.changedNodes.contains(element)) {
            this.changedNodes.add(element);
        }
    }

    private void selectSystemPackages(MethodPlugin plugin) {
        List pkgs = TngUtil.getAllSystemPackages((MethodPlugin)plugin);
        Iterator it = pkgs.iterator();
        while (it.hasNext()) {
            EObject pkg = (EObject)it.next();
            this.add(pkg, false);
        }
    }

    public boolean isSelected(Object input) {
        return input instanceof MethodLibrary || input == this.config || this.selected.contains(input);
    }

    public ElementDependencyError getError(Object element) {
        return this.getError(element, false);
    }

    private ElementDependencyError getError(Object element, boolean create) {
        ElementDependencyError error = (ElementDependencyError)this.invalidNodesMap.get(element);
        if (error == null && create) {
            error = new ElementDependencyError(element);
            this.invalidNodesMap.put(element, error);
        }
        return error;
    }

    public boolean hasError() {
        Iterator it = this.invalidNodesMap.values().iterator();
        while (it.hasNext()) {
            ElementDependencyError error = (ElementDependencyError)it.next();
            if (!error.isError()) continue;
            return true;
        }
        return false;
    }

    public boolean hasProblem() {
        return this.invalidNodesMap.size() > 0;
    }

    public List getAllErrors() {
        ArrayList errors = new ArrayList();
        Iterator it = this.invalidNodesMap.values().iterator();
        while (it.hasNext()) {
            ElementDependencyError error = (ElementDependencyError)it.next();
            errors.addAll(error.getAll());
        }
        return errors;
    }

    public Object[] getDependencyErrors() {
        return this.invalidNodesMap.values().toArray();
    }

    public List getInvalidElements() {
        return new ArrayList(this.invalidNodesMap.keySet());
    }

    private void removeError(Object element) {
        if (this.invalidNodesMap.containsKey(element)) {
            this.invalidNodesMap.remove(element);
            if (!this.changedNodes.contains(element)) {
                this.changedNodes.add(element);
            }
        }
    }

    public List getChangedElements() {
        ArrayList items = new ArrayList(this.changedNodes);
        Iterator it = this.invalidNodesMap.keySet().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (items.contains(item)) continue;
            items.add(item);
        }
        return items;
    }

    public Object[] getSelection() {
        return this.selected.toArray();
    }

    public void beginUpdate() {
        this.changedNodes.clear();
    }

    public void endUpdate() {
        Iterator it = new ArrayList(this.changedNodes).iterator();
        while (it.hasNext()) {
            Object changedElement = it.next();
            PackageDependency dependency = this.dependencyManager.getDependency((MethodElement)changedElement);
            if (dependency == null) continue;
            if (this.isSelected(changedElement)) {
                this.validateSelected(dependency);
                continue;
            }
            this.validateUnSelected(dependency);
        }
        if (debug) {
            System.out.println("There are (" + this.invalidNodesMap.size() + ") errors");
        }
    }

    private void validateSelected(ElementDependency dependency) {
        List refs;
        Object changedElement = dependency.getElement();
        this.removeError(changedElement);
        if (changedElement instanceof MethodLibrary) {
            return;
        }
        List dependents = dependency.getDependents();
        if (dependents != null && dependents.size() > 0) {
            Iterator itr = dependents.iterator();
            while (itr.hasNext()) {
                Object element = itr.next();
                ElementDependencyError error = this.getError(element, false);
                if (error == null) continue;
                error.removeError(changedElement);
                if (error.size() != 0) continue;
                this.removeError(element);
                this.updateParentsForErrors((EObject)element);
            }
        }
        if ((refs = dependency.getReferences()) != null && refs.size() > 0) {
            Iterator itr = refs.iterator();
            while (itr.hasNext()) {
                PackageReference ref = (PackageReference)itr.next();
                Object element = ref.getRefElement();
                if (element instanceof MethodLibrary) continue;
                if (!this.isSelected(element) && !this.canIgnore(ref)) {
                    String message;
                    int errorType = 0;
                    if (ref.hasBaseReference()) {
                        errorType = 1;
                        message = LibraryResources.configClosureWarning_msg2;
                    } else {
                        errorType = 2;
                        message = LibraryResources.configClosureWarning_msg3;
                    }
                    ElementDependencyError error = this.getError(changedElement, true);
                    error.addError(new ErrorInfo(errorType, message, changedElement, element, 16));
                    continue;
                }
                ElementDependencyError error = this.getError(changedElement, false);
                if (error == null) continue;
                error.removeError(element);
            }
        }
        this.updateParentsForErrors((EObject)changedElement);
    }

    private void validateUnSelected(ElementDependency dependency) {
        List dependents;
        Object element;
        Iterator itr;
        Object changedElement = dependency.getElement();
        this.removeError(changedElement);
        if (changedElement instanceof MethodLibrary) {
            return;
        }
        List refs = dependency.getReferences();
        if (refs != null && refs.size() > 0) {
            itr = refs.iterator();
            while (itr.hasNext()) {
                ElementReference ref = (ElementReference)itr.next();
                element = ref.getRefElement();
                ElementDependencyError error = this.getError(element, false);
                if (error == null) continue;
                error.removeError(changedElement);
                if (error.size() != 0) continue;
                this.removeError(element);
                this.updateParentsForErrors((EObject)element);
            }
        }
        if ((dependents = dependency.getDependents()) != null && dependents.size() > 0) {
            itr = dependents.iterator();
            while (itr.hasNext()) {
                element = itr.next();
                if (element instanceof MethodLibrary) continue;
                if (this.isSelected(element)) {
                    PackageDependency childDep = this.dependencyManager.getDependency((MethodElement)element);
                    this.validateSelected(childDep);
                    continue;
                }
                this.removeError(changedElement);
            }
        }
        this.updateParentsForErrors((EObject)changedElement);
    }

    private void updateParentError(EObject parent, EObject element, int errorType) {
        if (parent == null || parent instanceof MethodLibrary) {
            return;
        }
        if (parent instanceof MethodPackage && ConfigurationHelper.isGlobalPackage((MethodPackage)parent)) {
            this.updateParentError(parent.eContainer(), element, errorType);
            return;
        }
        ElementDependencyError error = this.getError(parent, false);
        if (error != null && error.size() > 0) {
            error.removeError(element);
        }
        if (errorType != 0) {
            error = this.getError(parent, true);
            String message = LibraryResources.configClosureWarning_msg1;
            error.addError(new ErrorInfo(errorType, message, parent, element, 0));
        } else if (error != null && error.size() == 0) {
            this.removeError(parent);
        }
        this.updateParentError(parent.eContainer(), element, errorType);
    }

    private void updateParentsForErrors(EObject element) {
        int errorType = 0;
        ElementDependencyError error = this.getError(element);
        if (error != null && error.size() > 0) {
            if (error.isError() || error.isChildError()) {
                errorType = 4;
            } else if (error.isWarning() || error.isChildWarning()) {
                errorType = 8;
            }
        }
        this.updateParentError(element.eContainer(), element, errorType);
    }

    public void makeClosure() {
        while (this.hasError()) {
            this.fixProblems(true);
        }
    }

    public void fixProblems() {
        while (this.hasProblem()) {
            this.fixProblems(false);
        }
    }

    private void fixProblems(boolean errorOnly) {
        ArrayList currentSelected = new ArrayList(this.selected);
        List errors = this.getAllErrors();
        if (errors.size() > 0) {
            this.invalidNodesMap.clear();
            Iterator it = errors.iterator();
            while (it.hasNext()) {
                ErrorInfo error = (ErrorInfo)it.next();
                EObject ownerElement = (EObject)error.getOwnerElement();
                EObject causeElement = (EObject)error.getCauseElement();
                this.addChanged(ownerElement);
                this.addChanged(causeElement);
                if (error.isChildError() || error.isChildWarning() || error.isWarning() && errorOnly) continue;
                boolean ownerSelected = currentSelected.contains(ownerElement);
                boolean causeSelected = currentSelected.contains(causeElement);
                if (!ownerSelected) {
                    this.selectErrorElement(ownerElement);
                    continue;
                }
                if (causeSelected) continue;
                this.selectErrorElement(causeElement);
            }
        }
        this.endUpdate();
    }

    private void selectErrorElement(EObject element) {
        if (LibraryUtil.selectable(element)) {
            this.add(element, true);
        }
    }

    public void saveMethodConfiguration() {
        List plugins = this.config.getMethodPluginSelection();
        List packages = this.config.getMethodPackageSelection();
        plugins.clear();
        packages.clear();
        Iterator it = this.selected.iterator();
        while (it.hasNext()) {
            EObject element = (EObject)it.next();
            if (element instanceof MethodPlugin) {
                if (plugins.contains(element)) continue;
                plugins.add(element);
                continue;
            }
            if (!(element instanceof MethodPackage) || ConfigurationHelper.isGlobalPackage((MethodPackage)element) || packages.contains(element)) continue;
            packages.add(element);
        }
    }

    public MethodLibrary packageLibrary(boolean removeBrokenReferences) {
        this.processSelection((EObject)this.library, removeBrokenReferences);
        List configs = this.library.getPredefinedConfigurations();
        configs.clear();
        configs.add(this.config);
        return this.library;
    }

    private void processSelection(EObject element, boolean removeBrokenReferences) {
        EList elements;
        Iterator it;
        EList references;
        if (removeBrokenReferences && (references = element.eCrossReferences()) != null) {
            it = new ArrayList(references).iterator();
            while (it.hasNext()) {
                EObject ref = (EObject)it.next();
                EObject pkgRef = LibraryUtil.getSelectable(ref);
                if (pkgRef == null || this.isSelected(pkgRef)) continue;
                this.removeReference(element, ref);
            }
        }
        if ((elements = element.eContents()) != null) {
            it = new ArrayList(elements).iterator();
            while (it.hasNext()) {
                EObject child = (EObject)it.next();
                if (LibraryUtil.selectable(child) && !this.isSelected(child)) {
                    EcoreUtil.remove((EObject)child);
                    continue;
                }
                this.processSelection(child, removeBrokenReferences);
            }
        }
    }

    private void removeReference(EObject ownerElement, EObject refElement) {
        AdapterFactoryContentProvider provider = this.configManager.getContentProvider();
        IPropertySource ps = provider.getPropertySource((Object)ownerElement);
        IPropertyDescriptor[] pds = ps.getPropertyDescriptors();
        if (pds != null && pds.length > 0) {
            int i = 0;
            while (i < pds.length) {
                IPropertyDescriptor descriptor = pds[i];
                Object id = descriptor.getId();
                Object value = ps.getPropertyValue(id);
                IPropertySource source = provider.getPropertySource(value);
                if (source != null) {
                    value = source.getEditableValue();
                }
                if (value instanceof EList) {
                    EList refList = (EList)value;
                    if (refList.contains((Object)refElement)) {
                        if (debug) {
                            System.out.println("Reference [" + LibraryUtil.getName(refElement) + "] removed from [" + LibraryUtil.getName(ownerElement) + "]'s reference list");
                        }
                        refList.remove((Object)refElement);
                        ps.setPropertyValue(id, (Object)refList);
                    }
                } else if (value instanceof MethodElement) {
                    if (debug) {
                        System.out.println("Reference [" + LibraryUtil.getName(refElement) + "] removed from [" + LibraryUtil.getName(ownerElement) + "]");
                    }
                    ps.setPropertyValue(id, null);
                }
                ++i;
            }
        }
    }

    public void dispose() {
        this.configManager = null;
        this.config = null;
        this.library = null;
        this.dependencyManager = null;
        this.selected.clear();
        this.changedNodes.clear();
        this.invalidNodesMap.clear();
    }

    private boolean canIgnore(PackageReference pkgRef) {
        return pkgRef.canIgnore();
    }
}

