/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

public class ErrorInfo {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int CHILD_ERROR = 4;
    public static final int CHILD_WARNING = 8;
    public static final int REFERENCE_TO = 16;
    public static final int REFERENCED_BY = 32;
    private int errorType;
    private Object ownerElement;
    private Object causeElement;
    private String errorMessage;
    private int relation = 0;

    public ErrorInfo(int errorType, String message, Object ownerElement, Object causeElement, int relation) {
        this.ownerElement = ownerElement;
        this.causeElement = causeElement;
        this.errorType = errorType;
        this.errorMessage = message;
        this.relation = relation;
    }

    public int getRelation() {
        return this.relation;
    }

    public Object getOwnerElement() {
        return this.ownerElement;
    }

    public Object getCauseElement() {
        return this.causeElement;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public boolean isError() {
        return (this.errorType & 1) > 0;
    }

    public boolean isWarning() {
        return (this.errorType & 2) > 0;
    }

    public boolean isChildError() {
        return (this.errorType & 4) > 0;
    }

    public boolean isChildWarning() {
        return (this.errorType & 8) > 0;
    }
}

