/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.IOppositeFeatureLoader;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElementDescription;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public class TypeConverter {
    private static final Comparator activityFeatureComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 == UmaPackage.Literals.BREAKDOWN_ELEMENT__SUPER_ACTIVITIES) {
                return -1;
            }
            return 0;
        }
    };

    public static final EObject convert(EObject object, EClass newType, Map oldFeatureToNewFeatureMap, Comparator featureComparator, Set modifiedResources) {
        TypeConversionCommand cmd = TypeConverter.createTypeConversionCommand(object, newType, oldFeatureToNewFeatureMap, featureComparator);
        try {
            cmd.execute();
            modifiedResources.addAll(cmd.getModifiedResources());
            EObject eObject = (EObject)cmd.getResult().iterator().next();
            Object var6_7 = null;
            cmd.dispose();
            return eObject;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            cmd.dispose();
            throw throwable;
        }
    }

    public static final TypeConversionCommand createTypeConversionCommand(EObject object, EClass newType, Map oldFeatureToNewFeatureMap, Comparator featureComparator) {
        return TypeConverter.createTypeConversionCommand(object, newType, oldFeatureToNewFeatureMap, featureComparator, false, false);
    }

    public static final TypeConversionCommand createTypeConversionCommand(EObject object, EClass newType, Map oldFeatureToNewFeatureMap, Comparator featureComparator, boolean removeIncomingReferences, boolean removeVariability) {
        TypeConversionCommand cmd = new TypeConversionCommand(object);
        EObject newObject = TypeConverter.prepareConvert(object, newType, oldFeatureToNewFeatureMap, featureComparator, removeIncomingReferences, removeVariability, cmd);
        EObject container = object.eContainer();
        if (container != null) {
            EReference ref = object.eContainmentFeature();
            if (ref.isMany()) {
                List list = (List)container.eGet((EStructuralFeature)ref);
                int index = list.indexOf(object);
                cmd.append((Command)new SetCommand(null, container, (EStructuralFeature)ref, (Object)newObject, index));
            } else {
                cmd.append((Command)new SetCommand(null, container, (EStructuralFeature)ref, (Object)newObject));
            }
        }
        cmd.setResult(Collections.singletonList(newObject));
        return cmd;
    }

    private static ContentResourceScanner createScanner(EObject object) {
        if (object instanceof ContentDescription && !(object instanceof BreakdownElementDescription)) {
            File oldResourcePath = new File(LibraryService.getInstance().getCurrentMethodLibraryPath(), MethodLibraryPersister.getElementPath((MethodElement)((MethodElement)object)));
            ContentResourceScanner scanner = new ContentResourceScanner(oldResourcePath);
            return scanner;
        }
        return null;
    }

    public static final EObject prepareConvert(EObject object, EClass newType, Map oldFeatureToNewFeatureMap, Comparator featureComparator, boolean removeIncomingReferences, boolean removeVariability, TypeConversionCommand compoundCommand) {
        Iterator iter;
        MethodElement me;
        Collection oppositeFeatures;
        EObject newObject = UmaFactory.eINSTANCE.create(newType);
        if (object instanceof MethodElement && !(oppositeFeatures = (me = (MethodElement)object).getOppositeFeatures()).isEmpty()) {
            List<EObject> collection = Collections.singletonList(object);
            iter = ExtensionManager.getOppositeFeatureLoaders().iterator();
            while (iter.hasNext()) {
                IOppositeFeatureLoader loader = (IOppositeFeatureLoader)iter.next();
                loader.loadOppositeFeatures(collection);
            }
            Map referencerToFeatureListMap = AssociationHelper.getReferenceMap((MethodElement)me);
            Iterator iter2 = referencerToFeatureListMap.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                EObject referencer = (EObject)entry.getKey();
                Iterator iterator = ((Collection)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    EReference feature = (EReference)iterator.next();
                    if (!removeIncomingReferences && feature.getEType().isInstance((Object)newObject)) {
                        if (feature.isMany()) {
                            List list = (List)referencer.eGet((EStructuralFeature)feature);
                            int index = list.indexOf(object);
                            compoundCommand.append((Command)new SetCommand(null, referencer, (EStructuralFeature)feature, (Object)newObject, index));
                            continue;
                        }
                        compoundCommand.append((Command)new SetCommand(null, referencer, (EStructuralFeature)feature, (Object)newObject));
                        continue;
                    }
                    if (feature.isMany()) {
                        compoundCommand.append((Command)new RemoveCommand(null, referencer, (EStructuralFeature)feature, (Object)object));
                        continue;
                    }
                    compoundCommand.append((Command)new SetCommand(null, referencer, (EStructuralFeature)feature, feature.getDefaultValue()));
                }
            }
        }
        EList newObjectFeatures = newType.getEAllStructuralFeatures();
        ArrayList objectFeatures = new ArrayList(object.eClass().getEAllStructuralFeatures());
        if (removeVariability) {
            objectFeatures.remove(UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT);
            objectFeatures.remove(UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE);
        }
        if (featureComparator != null) {
            Collections.sort(objectFeatures, featureComparator);
        }
        ContentResourceScanner scanner = TypeConverter.createScanner(object);
        iter = objectFeatures.iterator();
        while (iter.hasNext()) {
            String str;
            Object feature = (EStructuralFeature)iter.next();
            if (!newObjectFeatures.contains(feature)) {
                Object f;
                feature = oldFeatureToNewFeatureMap != null ? ((f = oldFeatureToNewFeatureMap.get(feature)) != null && newObjectFeatures.contains(f) ? (EStructuralFeature)f : null) : null;
            }
            if (feature == null || !feature.isChangeable()) continue;
            boolean featureHandled = false;
            if (feature instanceof EReference) {
                EReference oppositeRef;
                EReference ref = (EReference)feature;
                if (ref == UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION) {
                    if (ContentDescriptionFactory.hasPresentation((MethodElement)((MethodElement)object))) {
                        ContentDescription content = (ContentDescription)object.eGet((EStructuralFeature)ref);
                        EClass contentDescType = ContentDescriptionFactory.getContentDescriptionType((EClass)newType);
                        if (contentDescType != null && contentDescType != content.eClass()) {
                            EObject newContent = TypeConverter.prepareConvert((EObject)content, contentDescType, null, null, removeIncomingReferences, removeVariability, compoundCommand);
                            EObject container = content.eContainer();
                            if (container != null) {
                                compoundCommand.append((Command)new SetCommand(null, object, (EStructuralFeature)ref, null));
                                Resource resource = content.eResource();
                                if (resource != null) {
                                    compoundCommand.modifiedResources.add(content.eResource());
                                }
                            }
                            content = (ContentDescription)newContent;
                        } else {
                            compoundCommand.resourceCopyTasks.add(new ResourceCopyTask(TypeConverter.createScanner((EObject)content), (MethodElement)content, null, ""));
                        }
                        compoundCommand.append((Command)new SetCommand(null, newObject, (EStructuralFeature)ref, (Object)content));
                    }
                    featureHandled = true;
                } else if (!ref.isContainment() && ref.getEOpposite() != null && (oppositeRef = ref.getEOpposite()).isMany()) {
                    Object value = object.eGet((EStructuralFeature)ref);
                    if (value != null) {
                        if (ref.isMany()) {
                            Iterator iterator = ((Collection)value).iterator();
                            while (iterator.hasNext()) {
                                EObject otherEnd = (EObject)iterator.next();
                                List list = (List)otherEnd.eGet((EStructuralFeature)oppositeRef);
                                int index = list.indexOf(object);
                                compoundCommand.append((Command)new SetCommand(null, otherEnd, (EStructuralFeature)oppositeRef, (Object)newObject, index));
                            }
                        } else {
                            EObject otherEnd = (EObject)value;
                            List list = (List)otherEnd.eGet((EStructuralFeature)oppositeRef);
                            int index = list.indexOf(object);
                            compoundCommand.append((Command)new SetCommand(null, otherEnd, (EStructuralFeature)oppositeRef, (Object)newObject, index));
                        }
                    }
                    featureHandled = true;
                }
            }
            if (featureHandled) continue;
            Object value = object.eGet(feature);
            if (scanner != null && value instanceof String && object instanceof MethodElement && !StrUtil.isBlank((String)(str = (String)value))) {
                compoundCommand.resourceCopyTasks.add(new ResourceCopyTask(scanner, (MethodElement)object, str, ""));
            }
            compoundCommand.append((Command)new SetCommand(null, newObject, feature, value));
        }
        return newObject;
    }

    public static Activity convertActivity(Activity oldActivity, EClass newType) {
        if (newType == oldActivity.eClass()) {
            return null;
        }
        HashSet modifiedResources = new HashSet();
        Activity newActivity = (Activity)TypeConverter.convert((EObject)oldActivity, newType, null, activityFeatureComparator, modifiedResources);
        if (!modifiedResources.isEmpty()) {
            IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
            try {
                Iterator iter = modifiedResources.iterator();
                while (iter.hasNext()) {
                    Resource res = (Resource)iter.next();
                    persister.save(res);
                }
                persister.commit();
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertActivityError_title, NLS.bind((String)LibraryResources.saveConvertedActivityError_msg, (Object)newActivity.getName()), LibraryResources.error_reason, (Throwable)e);
                persister.rollback();
            }
        }
        return newActivity;
    }

    public static EClass getActivityType(int typeID) {
        switch (typeID) {
            case 52: {
                return UmaPackage.Literals.ACTIVITY;
            }
            case 56: {
                return UmaPackage.Literals.ITERATION;
            }
            case 57: {
                return UmaPackage.Literals.PHASE;
            }
        }
        return null;
    }

    private static class ResourceCopyTask {
        ContentResourceScanner scanner;
        MethodElement owner;
        String content;
        String contentPath;

        public ResourceCopyTask(ContentResourceScanner scanner, MethodElement owner, String content, String contentPath) {
            this.scanner = scanner;
            this.owner = owner;
            this.content = content;
            this.contentPath = contentPath;
        }
    }

    public static class TypeConversionCommand
    extends CompoundCommand
    implements IResourceAwareCommand {
        private Collection result;
        private EObject object;
        private HashSet modifiedResources;
        private boolean gotModifiedResources;
        private List resourceCopyTasks;
        private Resource resource;
        private Collection illegalReferencers;

        public TypeConversionCommand(EObject object) {
            this.object = object;
            this.modifiedResources = new HashSet();
            this.resource = object.eResource();
            if (this.resource != null) {
                this.modifiedResources.add(this.resource);
            }
            this.resourceCopyTasks = new ArrayList();
        }

        public void dispose() {
            if (this.illegalReferencers != null) {
                this.illegalReferencers.clear();
            }
            if (this.modifiedResources != null) {
                this.modifiedResources.clear();
            }
            if (this.resourceCopyTasks != null) {
                this.resourceCopyTasks.clear();
            }
            super.dispose();
        }

        public Collection getIllegalReferencers() {
            if (this.illegalReferencers == null) {
                this.getModifiedResources();
            }
            return this.illegalReferencers;
        }

        public void copyResources() {
            if (!this.resourceCopyTasks.isEmpty()) {
                Iterator iter = this.resourceCopyTasks.iterator();
                while (iter.hasNext()) {
                    ResourceCopyTask t = (ResourceCopyTask)iter.next();
                    File newResourcePath = new File(LibraryService.getInstance().getCurrentMethodLibraryPath(), MethodLibraryPersister.getElementPath((MethodElement)t.owner));
                    t.scanner.setTargetRootPath(newResourcePath);
                    if (t.content != null) {
                        t.scanner.resolveResources(t.owner, t.content, t.contentPath);
                        continue;
                    }
                    Iterator iterator = t.owner.eClass().getEAllAttributes().iterator();
                    while (iterator.hasNext()) {
                        EAttribute attribute = (EAttribute)iterator.next();
                        Object value = t.owner.eGet((EStructuralFeature)attribute);
                        if (!(value instanceof String)) continue;
                        t.scanner.resolveResources(t.owner, (String)value, t.contentPath);
                    }
                }
            }
        }

        public Collection getModifiedResources() {
            if (!this.gotModifiedResources) {
                this.illegalReferencers = new HashSet();
                Iterator iter = this.commandList.iterator();
                while (iter.hasNext()) {
                    EObject value;
                    Resource ownerResource;
                    EObject owner;
                    Command cmd = (Command)iter.next();
                    if (cmd instanceof RemoveCommand) {
                        RemoveCommand removeCommand = (RemoveCommand)cmd;
                        owner = removeCommand.getOwner();
                        ownerResource = owner.eResource();
                        if (ownerResource != null && ownerResource != this.resource) {
                            this.modifiedResources.add(ownerResource);
                        }
                        if (ownerResource == null || owner == this.object || UmaUtil.isContainedBy((EObject)owner, (Object)this.object)) continue;
                        this.illegalReferencers.add(owner);
                        continue;
                    }
                    if (!(cmd instanceof SetCommand)) continue;
                    SetCommand setCommand = (SetCommand)cmd;
                    owner = setCommand.getOwner();
                    ownerResource = owner.eResource();
                    if (ownerResource != null && ownerResource != this.resource && setCommand.getValue() instanceof EObject && ((value = (EObject)setCommand.getValue()) != this.object || !UmaUtil.isContainedBy((EObject)value, (Object)this.object))) {
                        this.modifiedResources.add(ownerResource);
                    }
                    if (ownerResource == null || owner == this.object || UmaUtil.isContainedBy((EObject)owner, (Object)this.object) || setCommand.getValue() != setCommand.getFeature().getDefaultValue()) continue;
                    this.illegalReferencers.add(owner);
                }
                this.gotModifiedResources = true;
            }
            return this.modifiedResources;
        }

        private void setResult(Collection result) {
            this.result = result;
        }

        public Collection getResult() {
            return this.result;
        }
    }
}

