/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.richtext.dialogs.AddTableDialog;
import org.eclipse.epf.richtext.html.Table;
import org.eclipse.swt.widgets.Display;

public class AddTableAction
extends RichTextAction {
    public AddTableAction() {
        this.setImage(RichTextImages.IMG_ADD_TABLE);
        this.setDisabledImage(RichTextImages.DISABLED_IMG_ADD_TABLE);
        this.setToolTipText(RichTextResources.addTableAction_toolTipText);
        this.setEnabled(true);
    }

    public void execute(IRichText richText) {
        if (richText != null) {
            AddTableDialog dialog = new AddTableDialog(Display.getCurrent().getActiveShell());
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                Table table = dialog.getTable();
                int rows = table.getRows();
                int cols = table.getColumns();
                int width = table.getWidth();
                int tableheaders = table.getTableHeaders();
                String summary = table.getSummary();
                String caption = table.getCaption();
                if (rows > 0 && cols > 0) {
                    richText.executeCommand("addTable", new String[]{"" + rows, "" + cols, "" + width, summary, caption, "" + tableheaders});
                }
            }
        }
    }
}

