/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class TableDragAndDropEffect
extends DragAndDropEffect {
    Table table;
    int scrollIndex;
    long scrollBeginTime;
    TableItem dropHighlight;
    static final int SCROLL_HYSTERESIS = 200;

    TableDragAndDropEffect(Table table) {
        this.table = table;
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    Widget getItem(int x, int y) {
        Rectangle area;
        Point coordinates = new Point(x, y);
        TableItem item = this.table.getItem(coordinates = this.table.toControl(coordinates));
        if (item == null && (area = this.table.getClientArea()).contains(coordinates)) {
            int x1 = area.x;
            while (x1 < area.x + area.width) {
                Point pt = new Point(x1, coordinates.y);
                item = this.table.getItem(pt);
                if (item != null) break;
                ++x1;
            }
        }
        return item;
    }

    ImageData getDragSourceImage(int x, int y) {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            return null;
        }
        int tableImageList = OS.SendMessage(this.table.handle, 4098, 1, 0);
        if (tableImageList != 0) {
            int count = Math.min(selection.length, 10);
            Rectangle bounds = selection[0].getBounds(0);
            int i = 1;
            while (i < count) {
                bounds = bounds.union(selection[i].getBounds(0));
                ++i;
            }
            int hDC = OS.GetDC(0);
            int hDC1 = OS.CreateCompatibleDC(hDC);
            int bitmap = OS.CreateCompatibleBitmap(hDC, bounds.width, bounds.height);
            int hOldBitmap = OS.SelectObject(hDC1, bitmap);
            RECT rect = new RECT();
            rect.right = bounds.width;
            rect.bottom = bounds.height;
            int hBrush = OS.GetStockObject(0);
            OS.FillRect(hDC1, rect, hBrush);
            int i2 = 0;
            while (i2 < count) {
                TableItem selected = selection[i2];
                Rectangle cell = selected.getBounds(0);
                POINT pt = new POINT();
                int imageList = OS.SendMessage(this.table.handle, 4129, this.table.indexOf(selected), pt);
                OS.ImageList_Draw(imageList, 0, hDC1, cell.x - bounds.x, cell.y - bounds.y, 4);
                OS.ImageList_Destroy(imageList);
                ++i2;
            }
            OS.SelectObject(hDC1, hOldBitmap);
            OS.DeleteDC(hDC1);
            OS.ReleaseDC(0, hDC);
            Display display = this.table.getDisplay();
            Image image = Image.win32_new(display, 0, bitmap);
            ImageData imageData = image.getImageData();
            image.dispose();
            return imageData;
        }
        return null;
    }

    void showDropTargetEffect(int effect, int x, int y) {
        effect = this.checkEffect(effect);
        int handle = this.table.handle;
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = coordinates.x;
        pinfo.y = coordinates.y;
        OS.SendMessage(handle, 4114, 0, pinfo);
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (pinfo.iItem != -1 && this.scrollIndex == pinfo.iItem && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int top = Math.max(0, OS.SendMessage(handle, 4135, 0, 0));
                int count = OS.SendMessage(handle, 4100, 0, 0);
                int index = this.scrollIndex - 1 < top ? Math.max(0, this.scrollIndex - 1) : Math.min(count - 1, this.scrollIndex + 1);
                boolean scroll = true;
                if (pinfo.iItem == top) {
                    scroll = pinfo.iItem != index;
                } else {
                    RECT itemRect = new RECT();
                    itemRect.left = 0;
                    if (OS.SendMessage(handle, 4110, pinfo.iItem, itemRect) != 0) {
                        RECT rect = new RECT();
                        OS.GetClientRect(handle, rect);
                        POINT pt = new POINT();
                        pt.x = itemRect.left;
                        pt.y = itemRect.top;
                        if (OS.PtInRect(rect, pt)) {
                            pt.y = itemRect.bottom;
                            if (OS.PtInRect(rect, pt)) {
                                scroll = false;
                            }
                        }
                    }
                }
                if (scroll) {
                    OS.SendMessage(handle, 4115, index, 0);
                    this.table.redraw();
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 200L;
            this.scrollIndex = pinfo.iItem;
        }
        if (pinfo.iItem != -1 && (effect & 1) != 0) {
            TableItem item = this.table.getItem(pinfo.iItem);
            if (this.dropHighlight != item) {
                LVITEM lvItem = new LVITEM();
                lvItem.stateMask = 8;
                OS.SendMessage(handle, 4139, -1, lvItem);
                lvItem.state = 8;
                OS.SendMessage(handle, 4139, pinfo.iItem, lvItem);
                this.dropHighlight = item;
            }
        } else if (this.dropHighlight != null) {
            LVITEM lvItem = new LVITEM();
            lvItem.stateMask = 8;
            OS.SendMessage(handle, 4139, -1, lvItem);
            this.dropHighlight = null;
        }
    }
}

