/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.gef.util.TemplateConstants;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.Property;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class FreeTextDirectEditManager
extends DirectEditManager {
    protected VerifyListener verifyListener;
    private Font scaledFont;
    protected IFigure figure;

    public FreeTextDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, IFigure figure) {
        super(source, editorType, locator);
        this.figure = figure;
    }

    protected void bringDown() {
        this.bringDown(true);
    }

    protected void bringDown(boolean check) {
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
        if (check) {
            Object wbelement;
            Node node = (Node)this.getEditPart().getModel();
            String name = "";
            if (node instanceof WorkBreakdownElementNode && (wbelement = node.getObject()) instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)wbelement))) {
                name = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)wbelement));
            }
            if (node instanceof TypedNode && ((TypedNode)node).getType() == 6) {
                GraphNode gnode = ((Node)this.getEditPart().getModel()).getGraphNode();
                name = ((Property)gnode.getProperty().get(0)).getValue();
            }
            if (name == null || name.trim().length() == 0) {
                Display.getCurrent().asyncExec((Runnable)new PromptEdit((NodeEditPart)this.getEditPart(), DiagramUIResources.err_name_empty));
            }
        }
    }

    protected void initCellEditor() {
        TextCellEditor editor = (TextCellEditor)this.getCellEditor();
        editor.setStyle(2);
        Text t = (Text)editor.getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Text text = (Text)FreeTextDirectEditManager.this.getCellEditor().getControl();
                String oldText = text.getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end, oldText.length());
                GC gc = new GC((Drawable)text);
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = text.computeSize(size.x, -1);
                }
                FreeTextDirectEditManager.this.getCellEditor().getControl().setSize(size.x, size.y);
            }
        };
        t.addVerifyListener(this.verifyListener);
        String initialLabelText = ((NodeEditPart)this.getEditPart()).getDirectEditText();
        editor.setValue((Object)initialLabelText);
        Font f = this.figure.getFont();
        FontMetrics fm = FigureUtilities.getFontMetrics((Font)f);
        int h = fm.getHeight();
        int w = fm.getAverageCharWidth();
        t.setSize(initialLabelText.length() * w + 100, h + 50);
        if (f != null) {
            t.setFont(f);
        } else {
            t.setFont(TemplateConstants.DEFAULT_FONT);
        }
        t.selectAll();
    }

    protected void unhookListeners() {
        super.unhookListeners();
        if (this.getCellEditor() != null) {
            Text text = (Text)this.getCellEditor().getControl();
            if (this.verifyListener != null) {
                text.removeVerifyListener(this.verifyListener);
            }
            this.verifyListener = null;
        }
    }

    protected String validate(String txt) {
        return null;
    }

    protected void commit() {
        String msg = this.validate((String)this.getCellEditor().getValue());
        if (msg != null) {
            this.bringDown(false);
            Display.getCurrent().asyncExec((Runnable)new PromptEdit((NodeEditPart)this.getEditPart(), msg));
            return;
        }
        super.commit();
    }

    static class PromptEdit
    implements Runnable {
        private NodeEditPart part;
        private String msg;

        PromptEdit(NodeEditPart part, String msg) {
            this.part = part;
            this.msg = msg;
        }

        public void run() {
            String title = DiagramUIResources.diagram_errorDialog_title_text0;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, this.msg);
            this.part.performDirectEdit();
        }
    }
}

