/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.util.ArrayList;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.wizards.NewMethodPluginWizardPage;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewMethodPluginWizard
extends Wizard
implements INewWizard {
    private NewMethodPluginWizardPage mainPage;
    private MethodPlugin newPlugin;

    public NewMethodPluginWizard() {
        this.setWindowTitle(AuthoringUIResources.newPluginWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mainPage = new NewMethodPluginWizardPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        if (!this.mainPage.validateName()) {
            return false;
        }
        String pluginName = this.mainPage.getPluginName();
        if (pluginName != null && pluginName.length() > 0) {
            try {
                this.newPlugin = UmaFactory.eINSTANCE.createMethodPlugin();
                this.newPlugin.setName(StrUtil.makeValidFileName((String)pluginName));
                this.newPlugin.setBriefDescription(this.mainPage.getBriefDescription());
                this.newPlugin.setAuthors(this.mainPage.getAuthors());
                Object[] referencedPlugins = this.mainPage.getReferencedPlugins();
                int i = 0;
                while (i < referencedPlugins.length) {
                    MethodPlugin plugin = (MethodPlugin)referencedPlugins[i];
                    if (plugin != null) {
                        this.newPlugin.getBases().add(plugin);
                    }
                    ++i;
                }
                ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                if (manager != null) {
                    manager.addMethodPlugin(ModelStorage.initialize((MethodPlugin)this.newPlugin));
                }
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        ArrayList<MethodPlugin> selection = new ArrayList<MethodPlugin>();
                        selection.add(NewMethodPluginWizard.this.newPlugin);
                        LibraryView.getView().setSelectionToViewer(selection);
                        EditorChooser.getInstance().openEditor(NewMethodPluginWizard.this.newPlugin);
                    }
                });
                return true;
            }
            catch (Exception e) {
                String reason = e.getMessage() != null ? e.getMessage() : AuthoringUIResources.newPluginError_reason;
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newPluginWizard_title, AuthoringUIResources.newPluginError_msg, reason, (Throwable)e);
            }
        }
        return false;
    }
}

