/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class SwitchConfigDialog {
    private MethodConfiguration recommendedConfig;
    private Shell shell;

    public SwitchConfigDialog(Shell shell, MethodConfiguration recommendedConfig) {
        this.shell = shell;
        this.recommendedConfig = recommendedConfig;
    }

    public void execute() {
        if (this.recommendedConfig == null) {
            return;
        }
        String switchConfigPref = LibraryUIPreferences.getSwitchConfig();
        if ("never".equals(switchConfigPref)) {
            LibraryService.getInstance().setCurrentMethodConfiguration(LibraryService.getInstance().getCurrentMethodConfiguration());
            return;
        }
        if (LibraryService.getInstance().getCurrentMethodConfiguration() != this.recommendedConfig) {
            String configName = this.recommendedConfig.getName();
            if ("prompt".equals(switchConfigPref)) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.shell, (String)LibraryUIResources.switchConfigDialog_title, (String)LibraryUIResources.bind(LibraryUIResources.switchConfigDialog_text, configName), null, (boolean)false, (IPreferenceStore)LibraryUIPlugin.getDefault().getPreferenceStore(), (String)"switchConfigurationOnProcessActivate");
                if (dialog.getReturnCode() == 2) {
                    MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)configName);
                    LibraryService.getInstance().setCurrentMethodConfiguration(config);
                } else {
                    LibraryService.getInstance().setCurrentMethodConfiguration(LibraryService.getInstance().getCurrentMethodConfiguration());
                }
            } else if ("always".equals(switchConfigPref)) {
                MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)configName);
                LibraryService.getInstance().setCurrentMethodConfiguration(config);
            }
        }
    }
}

