/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.MappingUtil;
import org.eclipse.epf.uma.MethodLibrary;

public class XMILibraryUtil {
    private static final String EMPTY_METHOD_LIBRARY_PATH_MSG = LibraryResources.emptyLibraryPathError_reason;
    private static final String MISSING_LIBRARY_FILE_MSG = LibraryResources.missingLibraryFileError_reason;
    private static final String COULD_NOT_LOCK_LIBRARY_MSG = LibraryResources.couldNotLockLibrary_reason;
    public static final IStatus EMPTY_METHOD_LIBRARY_PATH_STATUS = new Status(4, LibraryPlugin.getDefault().getId(), 1, EMPTY_METHOD_LIBRARY_PATH_MSG, null);
    public static final IStatus MISSING_LIBRARY_FILE_STATUS = new Status(4, LibraryPlugin.getDefault().getId(), 1, MISSING_LIBRARY_FILE_MSG, null);
    public static final IStatus COULD_NOT_LOCK_LIBRARY_STATUS = new Status(4, LibraryPlugin.getDefault().getId(), 1, COULD_NOT_LOCK_LIBRARY_MSG, null);

    static {
        try {
            new MultiFileResourceSetImpl();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean hasMethodLibrary(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        File libraryDir = new File(path);
        if (!libraryDir.exists()) {
            return false;
        }
        File libraryFile = new File(libraryDir, "library.xmi");
        return libraryFile.exists();
    }

    public static String getLibraryModelFile(String path) {
        if (!StrUtil.isBlank((String)path)) {
            String suffix;
            String libPath = new File(path).getAbsolutePath();
            if (libPath.endsWith(suffix = String.valueOf(File.separator) + "library.xmi")) {
                return libPath;
            }
            return String.valueOf(libPath) + suffix;
        }
        return path;
    }

    public static IStatus isValidLibrary(String path, boolean validateModelFile) {
        String libFullPath;
        File libFile;
        if (path == null || path.trim().length() == 0) {
            return EMPTY_METHOD_LIBRARY_PATH_STATUS;
        }
        if (validateModelFile && !(libFile = new File(XMILibraryUtil.getLibraryModelFile(path))).exists()) {
            return MISSING_LIBRARY_FILE_STATUS;
        }
        File libPath = new File(path);
        if (path.endsWith("library.xmi")) {
            libPath = libPath.getParentFile();
        }
        if ((libFullPath = libPath.getAbsolutePath()).startsWith("\\")) {
            boolean isValid = true;
            int index = libFullPath.indexOf(File.separatorChar, 2);
            if (index < 0) {
                isValid = false;
            } else {
                String uncPath = libFullPath.substring(index + 1);
                if (uncPath.length() == 0) {
                    isValid = false;
                } else {
                    uncPath = (index = libFullPath.indexOf(File.separatorChar, index + 1)) < 0 ? libFullPath : libFullPath.substring(0, index);
                    File f = new File(uncPath);
                    if (!f.exists()) {
                        isValid = false;
                    }
                }
            }
            if (!isValid) {
                return EMPTY_METHOD_LIBRARY_PATH_STATUS;
            }
        }
        IProjectDescription description = null;
        try {
            description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(libFullPath) + File.separator + ".project"));
            if (description != null) {
                return Status.OK_STATUS;
            }
        }
        catch (CoreException coreException) {}
        if (Platform.getLocation().isPrefixOf((IPath)new Path(libFullPath))) {
            return Status.OK_STATUS;
        }
        IProject project = ResourceUtil.findProject((String)libFullPath);
        if (project == null) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(libPath.getName());
        }
        return ResourcesPlugin.getWorkspace().validateProjectLocation(project, (IPath)new Path(libFullPath));
    }

    public static IStatus isValidLibrary(String path) {
        return XMILibraryUtil.isValidLibrary(path, false);
    }

    public static boolean isMethodLibraryLocked(String path) {
        return false;
    }

    public static boolean isMethodLibraryUpgradeRequired(String path) {
        return XMILibraryUtil.isMethodLibraryUpgradeRequired(path, "library.xmi");
    }

    public static boolean isMethodLibraryUpgradeRequired(String path, String libXmi) {
        return MappingUtil.conversionRequired((String)(String.valueOf(path) + File.separator + libXmi));
    }

    public static MethodLibrary createMethodLibrary(String name, String path) throws LibraryServiceException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("library.path", path);
        return LibraryService.getInstance().createMethodLibrary(name, "xmi", args);
    }

    public static MethodLibrary openMethodLibrary(String path) throws LibraryServiceException {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("library.path", path);
        return LibraryService.getInstance().openMethodLibrary("xmi", args);
    }

    public static void openMethodLibraryProject(MethodLibrary library, IProgressMonitor monitor) {
        IProject project;
        if (library != null && (project = ResourceUtil.findProject((MethodLibrary)library)) != null && !project.isOpen()) {
            try {
                project.open(128, monitor);
            }
            catch (CoreException e) {
                XMILibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }
}

