/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.VariabilityElementLabelProvider;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ConfigurationLabelProvider
extends VariabilityElementLabelProvider
implements IColorProvider {
    MethodConfiguration config = null;

    public ConfigurationLabelProvider(MethodConfiguration config, AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.config = config;
    }

    public Image getImage(Object object) {
        return super.getImage(object);
    }

    public String getText(Object object) {
        MethodElement element;
        String name = null;
        if (object instanceof MethodElement && StrUtil.isBlank((String)(name = (element = ConfigurationHelper.getCalculatedElement((MethodElement)((MethodElement)object), (MethodConfiguration)this.config)) instanceof BreakdownElement ? ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)element)) : TngUtil.getPresentationName((Object)element)))) {
            name = TngUtil.getPresentationName((Object)((MethodElement)object));
        }
        if (object instanceof FeatureValueWrapperItemProvider && StrUtil.isBlank((String)(name = TngUtil.getPresentationName((Object)(element = (MethodElement)((FeatureValueWrapperItemProvider)object).getValue()))))) {
            name = TngUtil.getPresentationName((Object)object);
        }
        if (object instanceof IWrapperItemProvider) {
            name = TngUtil.getPresentationName((Object)TngUtil.unwrap((Object)object));
        }
        if (name == null) {
            name = super.getText(object);
        }
        return name;
    }

    public void dispose() {
        this.config = null;
        super.dispose();
    }

    public Color getForeground(Object element) {
        if (this.isSuppressed(element)) {
            return Colors.SUPRESSED_ELEMENT_LABEL;
        }
        if (this.isExternal(element)) {
            return Colors.INHERITED_ELEMENT_LABEL;
        }
        return ColorConstants.listForeground;
    }

    private boolean isSuppressed(Object element) {
        Object top;
        if (element instanceof BreakdownElement) {
            Process proc = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)element));
            if (proc != null) {
                return Suppression.getSuppression((Process)proc).isSuppressed(element);
            }
        } else if (element instanceof BreakdownElementWrapperItemProvider && (top = ((BreakdownElementWrapperItemProvider)element).getTopItem()) instanceof Process) {
            return Suppression.getSuppression((Process)((Process)top)).isSuppressed(element);
        }
        return false;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public boolean isExternal(Object element) {
        return ProcessUtil.isInherited((Object)element) || ProcessUtil.isContributed((Object)element);
    }

    public Font getFont(Object element) {
        if (ProcessUtil.isInherited((Object)element)) {
            return italicFont;
        }
        if (ProcessUtil.isContributed((Object)element)) {
            return boldItalicFont;
        }
        return regularFont;
    }
}

