/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.library.configuration.ConfigurationClosure;
import org.eclipse.epf.library.configuration.ElementDependencyError;
import org.eclipse.epf.library.configuration.ErrorInfo;
import org.eclipse.epf.library.services.ElementReference;
import org.eclipse.epf.library.services.PackageDependency;
import org.eclipse.epf.library.services.PackageReference;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MessageContentProvider
implements ITreeContentProvider {
    private ConfigurationClosure closure;

    public MessageContentProvider(ConfigurationClosure closure) {
        this.closure = closure;
    }

    public Object[] getElements(Object inputElement) {
        if (this.closure == null) {
            return new Object[0];
        }
        if (inputElement instanceof ConfigurationClosure) {
            return ((ConfigurationClosure)inputElement).getDependencyErrors();
        }
        if (inputElement instanceof ElementDependencyError) {
            List errors = ((ElementDependencyError)inputElement).getAll();
            if (errors != null) {
                return errors.toArray();
            }
            return null;
        }
        if (inputElement instanceof ErrorInfo) {
            PackageDependency dep;
            ErrorInfo info = (ErrorInfo)inputElement;
            int relation = info.getRelation();
            MethodElement ownerElement = (MethodElement)info.getOwnerElement();
            MethodElement causeElement = (MethodElement)info.getCauseElement();
            PackageReference pkgRef = null;
            if (relation == 16) {
                dep = this.closure.getConfigurationManager().getDependencyManager().getDependency(ownerElement);
                pkgRef = dep.getReference((Object)causeElement, false);
            } else if (relation == 32) {
                dep = this.closure.getConfigurationManager().getDependencyManager().getDependency(causeElement);
                pkgRef = dep.getReference((Object)ownerElement, false);
            }
            if (pkgRef != null) {
                ArrayList<ErrorInfo> refErrors = new ArrayList<ErrorInfo>();
                Iterator it = pkgRef.getReferences().iterator();
                while (it.hasNext()) {
                    ElementReference ref = (ElementReference)it.next();
                    if (ref.canIgnore()) continue;
                    ErrorInfo elementError = relation == 16 ? new ErrorInfo(info.getErrorType(), "", ref.getElement(), ref.getRefElement(), relation) : new ErrorInfo(info.getErrorType(), "", ref.getRefElement(), ref.getElement(), relation);
                    refErrors.add(elementError);
                }
                return refErrors.toArray();
            }
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof ConfigurationClosure) {
            return null;
        }
        if (element instanceof ErrorInfo) {
            return this.closure;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ConfigurationClosure) {
            return true;
        }
        if (element instanceof ElementDependencyError) {
            return ((ElementDependencyError)element).size() > 0;
        }
        return element instanceof ErrorInfo && ((ErrorInfo)element).getErrorMessage().length() > 0;
    }
}

