/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.xml.AbstractSAXParser;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.xml.sax.Attributes;

public class SAXParserXMI
extends AbstractSAXParser {
    public HashMap xmiMap;
    private Stack stack;
    private MultiFileXMISaveImpl.MyEscape escape = new MultiFileXMISaveImpl.MyEscape();

    public SAXParserXMI(Logger logger) {
        super(logger, false);
    }

    public void startDocument() {
        super.startDocument();
        this.stack = new Stack();
    }

    public void endDocument() {
        super.endDocument();
    }

    public void startElement(String namespaceURL, String localName, String qname, Attributes attributes) {
        HashMap<String, Object> eMap = new HashMap<String, Object>();
        try {
            HashMap parent = (HashMap)this.stack.peek();
            ((ArrayList)parent.get("children")).add(eMap);
        }
        catch (EmptyStackException emptyStackException) {
            this.xmiMap = eMap;
        }
        eMap.put("tag", qname);
        ArrayList<String> attributeList = new ArrayList<String>();
        if (attributes.getLength() > 0) {
            int i = 0;
            while (i < attributes.getLength()) {
                attributeList.add(String.valueOf(attributes.getQName(i)) + "," + attributes.getValue(i));
                ++i;
            }
        }
        this.strBuf = new StringBuffer();
        eMap.put("attributes", attributeList);
        eMap.put("children", new ArrayList());
        this.stack.push(eMap);
    }

    public void endElement(String namespaceURL, String localName, String qname) {
        try {
            HashMap eMap = (HashMap)this.stack.peek();
            ArrayList attributeList = (ArrayList)eMap.get("attributes");
            if (attributeList.size() == 0 && this.strBuf.toString().trim().length() > 0) {
                eMap.put("content", this.escape.convertLines(this.strBuf.toString()));
            }
        }
        catch (EmptyStackException e) {
            e.printStackTrace();
        }
        this.stack.pop();
    }

    public static HashMap findElementTagofGuid(String elementTag, String guid, HashMap xmiMap) {
        HashMap eMap = SAXParserXMI.findGuid(guid, xmiMap);
        Iterator iter = ((ArrayList)eMap.get("children")).iterator();
        while (iter.hasNext()) {
            HashMap childMap = (HashMap)iter.next();
            if (!SAXParserXMI.getTag(childMap).equals(elementTag)) continue;
            return childMap;
        }
        return null;
    }

    public static HashMap getChildElementTag(String elementTag, HashMap eMap) {
        Iterator iter = ((ArrayList)eMap.get("children")).iterator();
        while (iter.hasNext()) {
            HashMap childMap = (HashMap)iter.next();
            if (!SAXParserXMI.getTag(childMap).equals(elementTag)) continue;
            return childMap;
        }
        return null;
    }

    public static String getTag(HashMap eMap) {
        String tag = "";
        if (eMap != null) {
            tag = (String)eMap.get("tag");
        }
        if (tag != null) {
            return tag;
        }
        return "";
    }

    public static String getElementContent(HashMap eMap) {
        String content = null;
        if (eMap != null) {
            content = (String)eMap.get("content");
        }
        return content;
    }

    public static HashMap findGuid(String guid, HashMap eMap) {
        ArrayList attList = (ArrayList)eMap.get("attributes");
        if (guid.equals(SAXParserXMI.getGuidOfList(attList))) {
            return eMap;
        }
        Iterator iter = ((ArrayList)eMap.get("children")).iterator();
        while (iter.hasNext()) {
            HashMap childMap = (HashMap)iter.next();
            HashMap result = SAXParserXMI.findGuid(guid, childMap);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getGuidOfList(ArrayList attList) {
        Iterator iter = attList.iterator();
        while (iter.hasNext()) {
            String attpair = (String)iter.next();
            String attname = attpair.substring(0, attpair.indexOf(","));
            String attval = attpair.substring(attpair.indexOf(",") + 1);
            if (!attname.equals("guid")) continue;
            return attval;
        }
        return null;
    }

    public static String getIdOfList(ArrayList attList) {
        Iterator iter = attList.iterator();
        while (iter.hasNext()) {
            String attpair = (String)iter.next();
            String attname = attpair.substring(0, attpair.indexOf(","));
            String attval = attpair.substring(attpair.indexOf(",") + 1);
            if (!attname.equals("id")) continue;
            return attval;
        }
        return null;
    }

    public static URI getPresentationUriOfElement(HashMap eMap) {
        Iterator iter;
        if (eMap == null) {
            return null;
        }
        String tag = SAXParserXMI.getTag(eMap);
        if (tag.equals("childPackages")) {
            ArrayList attList = (ArrayList)eMap.get("attributes");
            iter = attList.iterator();
            while (iter.hasNext()) {
                String attpair = (String)iter.next();
                String attname = attpair.substring(0, attpair.indexOf(","));
                String attval = attpair.substring(attpair.indexOf(",") + 1);
                if (!attname.equals("href")) continue;
                try {
                    URI uri = URI.createURI((String)attval);
                    return uri;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        ArrayList childList = (ArrayList)eMap.get("children");
        iter = childList.iterator();
        while (iter.hasNext()) {
            HashMap childMap = (HashMap)iter.next();
            tag = SAXParserXMI.getTag(childMap);
            if (!tag.equals("presentation")) continue;
            ArrayList attList = (ArrayList)childMap.get("attributes");
            Iterator attIter = attList.iterator();
            while (attIter.hasNext()) {
                String attpair = (String)attIter.next();
                String attname = attpair.substring(0, attpair.indexOf(","));
                String attval = attpair.substring(attpair.indexOf(",") + 1);
                if (!attname.equals("href")) continue;
                try {
                    URI uri = URI.createURI((String)attval);
                    return uri;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    public static HashMap findElementByAttribute(HashMap eMap, String attributeName, String attributeValue) {
        Iterator iter = ((ArrayList)eMap.get("children")).iterator();
        while (iter.hasNext()) {
            HashMap childMap = (HashMap)iter.next();
            HashMap result = SAXParserXMI.findElementByAttribute(childMap, attributeName, attributeValue);
            if (result == null) continue;
            return result;
        }
        iter = ((ArrayList)eMap.get("attributes")).iterator();
        while (iter.hasNext()) {
            String attpair = (String)iter.next();
            String attname = attpair.substring(0, attpair.indexOf(","));
            String attval = attpair.substring(attpair.indexOf(",") + 1);
            if (!attname.equals(attributeName) || !attval.equals(attributeValue)) continue;
            return eMap;
        }
        return null;
    }

    public static String getAttributeOfElement(HashMap eMap, String attributeName) {
        Iterator iter = ((ArrayList)eMap.get("attributes")).iterator();
        while (iter.hasNext()) {
            String attpair = (String)iter.next();
            String attname = attpair.substring(0, attpair.indexOf(","));
            String attval = attpair.substring(attpair.indexOf(",") + 1);
            if (!attname.equals(attributeName)) continue;
            return attval;
        }
        return null;
    }
}

