//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.epf.authoring.gef.edit.policies.RoleTaskFlowLayoutEditPolicy;
import org.eclipse.epf.authoring.ui.editors.ActivityDetailDiagramEditor;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

/**
 * @author Phong Nguyen Le
 * @since 1.0
 */
public class RoleTaskCompositeEditPart extends NodeContainerEditPart {

	private static final Color BG_COLOR = new Color(Display.getCurrent(), 255,
			255, 156);

	public RoleTaskCompositeEditPart(RoleTaskComposite model) {
		super(model);
	}

	protected IFigure createFigure() {
		Figure figure = new Figure();
		FlowLayout layout = new FlowLayout();
		layout.setMinorSpacing(20);
		figure.setLayoutManager(layout);
		figure.setBorder(new RaisedMarginBorder());
		figure.setBackgroundColor(BG_COLOR);
		figure.setOpaque(true);
		return figure;
	}

	/**
	 * @see org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart#handlePropertyChanged(Notification)
	 */
	protected void handlePropertyChanged(Notification msg) {
		switch (msg.getFeatureID(NodeContainer.class)) {
		case ModelPackage.NODE_CONTAINER__NODES:
			refreshChildren();

			// refresh diagram's children
			EditPart diagramEditPart = getParent();
//			if (diagramEditPart instanceof ActivityDetailDiagramEditPart) {
//				ActivityDetailDiagram diagram = (ActivityDetailDiagram) diagramEditPart
//						.getModel();
//
//				if (!GraphicalDataHelper.isAutoLayout(diagram)) {
//					((ActivityDetailDiagramEditPart) diagramEditPart)
//							.getRecentlyAddedParts().addAll(
//									diagramEditPart.getChildren());
//					DefaultEditDomain ed = (DefaultEditDomain) diagramEditPart
//							.getViewer().getEditDomain();
//					IEditorPart editor = ed.getEditorPart();
//					if (editor != null && editor instanceof ActivityDetailDiagramEditor) {
//						((ActivityDetailDiagramEditor) editor).cleanUpDiagram();
//					}
//				} else {
//					diagramEditPart.refresh();
//				}
//			}
			diagramEditPart.refresh();
			return;
		}
		super.handlePropertyChanged(msg);
	}

	/**
	 * @see org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart#createEditPolicies()
	 */
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new RoleTaskFlowLayoutEditPolicy());
	}

}
