//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.gef.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.command.Command;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.VaryActivityCommand;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;

/**
 * @author Shashidhar Kannoori
 * @author Shilpa Toraskar
 * @since  1.0
 */
public final class DiagramEditorUtil {

	
	private static DiagramEditorUtil instance = null;

	private List commandListeners;

	private DiagramEditorUtil() {
	}

	public static DiagramEditorUtil getInstance() {
		if (instance == null) {
			synchronized (DiagramEditorUtil.class) {
				if (instance == null) {
					instance = new DiagramEditorUtil();
				}
			}
		}
		return instance;
	}
	public List getVaryCommandListeners() {
		if (commandListeners == null) {
			commandListeners = new ArrayList();
		}

		commandListeners.add(new ICommandListener() {
			
			public void notifyExecuted(Command command) {
				// get contributor/replacer of the activity
				//
				Object wrapper = ((VaryActivityCommand)command).getWrapper();
				closeEditors(wrapper, new ArrayList());
			}

			public Class getCommandType() {
				return VaryActivityCommand.class;
			}

			public void preUndo(Command command) {
				// get old contributor/replacer of the activity
				//
				Collection list = ((VaryActivityCommand)command).getResult();
				
				for(Iterator iterator = list.iterator(); iterator.hasNext();){
					Object object = iterator.next();
					closeEditors(object, new ArrayList());
				
			}
				
		}

			public void preExecute(Command command) {
			}
		});

		return commandListeners;
	}
	private void closeEditors(Object closeElement, List closeEditorRefs) {
		closeEditorRefs = new ArrayList();
		IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault()
				.getWorkbench().getActiveWorkbenchWindow()
				.getActivePage();
		IEditorReference[] editorReferences = workbenchPage
				.getEditorReferences();
		for (int i = 0; i < editorReferences.length; i++) {
			IEditorReference reference = editorReferences[i];
			IEditorPart editor = reference.getEditor(true);
			if (editor != null) {
				IEditorInput input = editor.getEditorInput();
				Object element = null;
				if (input instanceof BreakdownElementEditorInput) {
					BreakdownElementEditorInput binput = (BreakdownElementEditorInput)input;
					if (binput.getWrapper() != null) {
						element = binput.getWrapper();
						if(element instanceof BreakdownElementWrapperItemProvider){
							Object parent = ((BreakdownElementWrapperItemProvider)element).getParent(null);
							if(parent instanceof BreakdownElementWrapperItemProvider){
								if(element.equals(closeElement))
								closeEditors(parent, closeEditorRefs);
							}
						}
					} else {
						element = binput.getMethodElement();
					}
				} 
				if (element != null && element.equals(closeElement))
				{
						closeEditorRefs.add(reference);
				}
			}
		}
		int size = closeEditorRefs.size();
		IEditorReference[] references = new IEditorReference[size];
		for (int i = 0; i < size; i++) {
			references[i] = (IEditorReference) closeEditorRefs.get(i);
		}
		workbenchPage.closeEditors(references, false);
	}
}