//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui;

import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/**
 * The Method Authoring perspective.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class AuthoringPerspective implements IPerspectiveFactory {

	/**
	 * The perspective ID.
	 */
	public static final String PERSPECTIVE_ID = AuthoringPerspective.class
			.getName();

	/**
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(IPageLayout)
	 */
	public void createInitialLayout(IPageLayout layout) {
		layout.setEditorAreaVisible(true);
		String editorArea = layout.getEditorArea();
		layout.addView(LibraryView.VIEW_ID, IPageLayout.LEFT, 0.30f,
				editorArea);
		layout.addPlaceholder(IPageLayout.ID_PROP_SHEET, 
				IPageLayout.BOTTOM, 0.65f, editorArea);
		PerspectiveListUtil.addPerspectiveShortList(layout);
	}

	/**
	 * Opens this perspective.
	 * 
	 * @return The previously active perspective.
	 */
	public static IPerspectiveDescriptor open() {
		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();
		if (activePage != null) {
			IPerspectiveRegistry registry = PlatformUI.getWorkbench()
					.getPerspectiveRegistry();
			IPerspectiveDescriptor oldPerspective = activePage.getPerspective();
			if (!oldPerspective.getId().equals(PERSPECTIVE_ID)) {
				IPerspectiveDescriptor perspective = registry
						.findPerspectiveWithId(PERSPECTIVE_ID);
				activePage.setPerspective(perspective);
			}
			return oldPerspective;
		}
		return null;
	}

}
