//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;

/**
 * Defines and caches the commonly referenced text in the Authoring UI.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class AuthoringUIText {

	/**
	 * Editor form page titles.
	 */
	public static final String ASSIGN_PAGE_TITLE = AuthoringUIResources.assignPage_title; //$NON-NLS-1$	

	public static final String CATEGORIES_PAGE_TITLE = AuthoringUIResources.categoriesPage_title; //$NON-NLS-1$

	public static final String DELIVERABLE_PARTS_PAGE_TITLE = AuthoringUIResources.deliverablePartsPage_title; //$NON-NLS-1$

	public static final String DESCRIPTION_PAGE_TITLE = AuthoringUIResources.descriptionPage_title; //$NON-NLS-1$

	public static final String DISCIPLINES_PAGE_TITLE = AuthoringUIResources.disciplinesPage_title; //$NON-NLS-1$

	public static final String GUIDANCE_PAGE_TITLE = AuthoringUIResources.guidancePage_title; //$NON-NLS-1$	

	public static final String PREVIEW_PAGE_TITLE = AuthoringUIResources.previewPage_title; //$NON-NLS-1$

	public static final String REFERENCES_PAGE_TITLE = AuthoringUIResources.referencesPage_title; //$NON-NLS-1$

	public static final String REFERENCE_WORKFLOW_PAGE_TITLE = AuthoringUIResources.referenceWorkflowPage_title; //$NON-NLS-1$

	public static final String ROLES_PAGE_TITLE = AuthoringUIResources.rolesPage_title; //$NON-NLS-1$

	public static final String ROLE_SETS_PAGE_TITLE = AuthoringUIResources.roleSetsPage_title; //$NON-NLS-1$

	public static final String STEPS_PAGE_TITLE = AuthoringUIResources.stepsPage_title; //$NON-NLS-1$

	public static final String TASKS_PAGE_TITLE = AuthoringUIResources.tasksPage_title; //$NON-NLS-1$

	public static final String TOOL_MENTORS_PAGE_TITLE = AuthoringUIResources.toolMentorsPage_title; //$NON-NLS-1$

	public static final String WORK_PRODUCTS_PAGE_TITLE = AuthoringUIResources.workProductsPage_title; //$NON-NLS-1$

	/**
	 * Editor section names and description.
	 */
	public static final String CHECK_ITEMS_SECTION_NAME = AuthoringUIResources.checkItemsSection_name; //$NON-NLS-1$

	public static final String CHECK_ITEMS_SECTION_DESC = AuthoringUIResources.checkItemsSection_desc; //$NON-NLS-1$		

	public static final String DEPENDENCIES_SECTION_NAME = AuthoringUIResources.dependenciesSection_name; //$NON-NLS-1$

	public static final String DEPENDENCIES_SECTION_DESC = AuthoringUIResources.dependenciesSection_desc; //$NON-NLS-1$

	public static final String DETAIL_SECTION_NAME = AuthoringUIResources.detailSection_name; //$NON-NLS-1$

	public static final String DETAIL_SECTION_DESC = AuthoringUIResources.detailSection_desc; //$NON-NLS-1$

	public static final String GENERAL_INFO_SECTION_NAME = AuthoringUIResources.generalInfoSection_name; //$NON-NLS-1$

	public static final String GENERAL_INFO_SECTION_DESC = AuthoringUIResources.generalInfoSection_desc; //$NON-NLS-1$

	public static final String ICON_SECTION_NAME = AuthoringUIResources.iconSection_name; //$NON-NLS-1$

	public static final String ICON_SECTION_DESC = AuthoringUIResources.iconSection_desc; //$NON-NLS-1$

	public static final String NOTATION_SECTION_NAME = AuthoringUIResources.notationSection_name; //$NON-NLS-1$

	public static final String NOTATION_SECTION_DESC = AuthoringUIResources.notationSection_desc; //$NON-NLS-1$

	public static final String REFERENCED_PLUGINS_SECTION_NAME = AuthoringUIResources.referencedPluginsSection_name; //$NON-NLS-1$

	public static final String REFERENCED_PLUGINS_SECTION_DESC = AuthoringUIResources.referencedPluginsSection_desc; //$NON-NLS-1$

	public static final String STAFFING_SECTION_NAME = AuthoringUIResources.staffingSection_name; //$NON-NLS-1$

	public static final String STAFFING_SECTION_DESC = AuthoringUIResources.staffingSection_desc; //$NON-NLS-1$

	public static final String STEPS_SECTION_NAME = AuthoringUIResources.stepsSection_name; //$NON-NLS-1$

	public static final String STEPS_SECTION_DESC = AuthoringUIResources.stepsSection_desc; //$NON-NLS-1$

	public static final String TAILORING_SECTION_NAME = AuthoringUIResources.tailoringSection_name; //$NON-NLS-1$

	public static final String TAILORING_SECTION_DESC = AuthoringUIResources.tailoringSection_desc; //$NON-NLS-1$

	public static final String VARIABILITY_SECTION_NAME = AuthoringUIResources.variabilitySection_name; //$NON-NLS-1$

	public static final String VARIABILITY_SECTION_DESC = AuthoringUIResources.variabilitySection_desc; //$NON-NLS-1$

	public static final String VERSION_INFO_SECTION_NAME = AuthoringUIResources.versionInfoSection_name; //$NON-NLS-1$

	public static final String VERSION_INFO_SECTION_DESC = AuthoringUIResources.versionInfoSection_desc; //$NON-NLS-1$

	/**
	 * UI and element attribute labels.
	 */
	public static final String ADDITIONAL_INFO_TEXT = AuthoringUIResources.additionalInfo_text; //$NON-NLS-1$

	public static final String APPLICATION_TEXT = AuthoringUIResources.application_text; //$NON-NLS-1$		

	public static final String ALTERNATIVES_TEXT = AuthoringUIResources.alternatives_text; //$NON-NLS-1$

	public static final String ASSIGNMENT_APPROACHES_TEXT = AuthoringUIResources.assignmentApproaches_text; //$NON-NLS-1$

	public static final String AUTHORS_TEXT = AuthoringUIResources.authors_text; //$NON-NLS-1$	

	public static final String BACKGROUND_TEXT = AuthoringUIResources.background_text; //$NON-NLS-1$

	public static final String BASE_ELEMENT_TEXT = AuthoringUIResources.baseElement_text; //$NON-NLS-1$

	public static final String BASE_GUIDANCE_TEXT = AuthoringUIResources.baseGuidance_text; //$NON-NLS-1$	

	public static final String BRIEF_DESCRIPTION_TEXT = AuthoringUIResources.briefDescription_text; //$NON-NLS-1$

	public static final String BRIEF_OUTLINE_TEXT = AuthoringUIResources.briefOutline_text; //$NON-NLS-1$

	public static final String CHANGE_DATE_TEXT = AuthoringUIResources.changeDate_text; //$NON-NLS-1$

	public static final String CHANGE_DESCRIPTION_TEXT = AuthoringUIResources.changeDescription_text; //$NON-NLS-1$

	public static final String CHECK_ITEMS_TEXT = AuthoringUIResources.checkItems_text; //$NON-NLS-1$

	public static final String CONTRIBUTES_TEXT = AuthoringUIResources.contributes_text; //$NON-NLS-1$
	
	private static final String LOCAL_CONTRIBUTES_TEXT = AuthoringUIResources.localContributes_text;  //$NON-NLS-1$

	public static final String COPYRIGHT_TEXT = AuthoringUIResources.copyright_text; //$NON-NLS-1$

	public static final String DESCRIPTION_TEXT = AuthoringUIResources.description_text; //$NON-NLS-1$

	public static final String EDITOR_TEXT = AuthoringUIResources.editor_text; //$NON-NLS-1$

	public static final String EXTENDS_TEXT = AuthoringUIResources.extends_text; //$NON-NLS-1$

	public static final String EXTERNAL_DESCRIPTION_TEXT = AuthoringUIResources.externalDescription_text; //$NON-NLS-1$

	public static final String EXTERNAL_ID_TEXT = AuthoringUIResources.externalId_text; //$NON-NLS-1$

	public static final String GOALS_TEXT = AuthoringUIResources.goals_text; //$NON-NLS-1$

	public static final String IMPACT_OF_NOT_HAVING_TEXT = AuthoringUIResources.impactOfNotHaving_text; //$NON-NLS-1$

	public static final String KEY_CONSIDERATIONS_TEXT = AuthoringUIResources.keyConsiderations_text; //$NON-NLS-1$

	public static final String LEVEL_OF_ADOPTION_TEXT = AuthoringUIResources.levelsOfAdoption_text; //$NON-NLS-1$

	public static final String MAIN_DESCRIPTION_TEXT = AuthoringUIResources.mainDescription_text; //$NON-NLS-1$

	public static final String NAME_TEXT = AuthoringUIResources.name_text; //$NON-NLS-1$

	public static final String NEW_ELEMENT_TEXT = AuthoringUIResources.newElement_text; //$NON-NLS-1$

	public static final String NOT_APPLICABLE_TEXT = AuthoringUIResources.notApplicable_text; //$NON-NLS-1$

	public static final String PACKAGING_GUIDANCE_TEXT = AuthoringUIResources.packagingGuidance_text; //$NON-NLS-1$

	public static final String PRESENTATION_NAME_TEXT = AuthoringUIResources.presentationName_text; //$NON-NLS-1$

	public static final String PROBLEM_TEXT = AuthoringUIResources.problem_text; //$NON-NLS-1$

	public static final String PURPOSE_TEXT = AuthoringUIResources.purpose_text; //$NON-NLS-1$

	public static final String REASON_FOR_NOT_NEEDING_TEXT = AuthoringUIResources.reasonForNotNeeding_text; //$NON-NLS-1$

	public static final String REPLACES_TEXT = AuthoringUIResources.replaces_text; //$NON-NLS-1$

	public static final String REPRESENTATION_OPTIONS_TEXT = AuthoringUIResources.representationOptions_text; //$NON-NLS-1$

	public static final String SKILLS_TEXT = AuthoringUIResources.skills_text; //$NON-NLS-1$

	public static final String STEPS_TEXT = AuthoringUIResources.steps_text; //$NON-NLS-1$

	public static final String STEP_NAME_TEXT = AuthoringUIResources.steps_name_text; //$NON-NLS-1$

	public static final String SYNONYMS_TEXT = AuthoringUIResources.synonyms_text; //$NON-NLS-1$	

	public static final String TEMPLATE_FILE_TEXT = AuthoringUIResources.templateFile_text; //$NON-NLS-1$	

	public static final String TYPE_TEXT = AuthoringUIResources.type_text; //$NON-NLS-1$	

	public static final String UNIQUE_ID_TEXT = AuthoringUIResources.uniqueId_text; //$NON-NLS-1$	

	public static final String VARIABILITY_TYPE_TEXT = AuthoringUIResources.variabilityType_text; //$NON-NLS-1$	

	public static final String VERSION_TEXT = AuthoringUIResources.version_text; //$NON-NLS-1$	

	/**
	 * Button labels.
	 */
	public static final String ADD_BUTTON_TEXT = AuthoringUIResources.addButton_text; //$NON-NLS-1$

	public static final String ATTACH_BUTTON_TEXT = AuthoringUIResources.attachButton_text; //$NON-NLS-1$

	public static final String BROWSE_BUTTON_TEXT = AuthoringUIResources.browseButton_text; //$NON-NLS-1$	

	public static final String CHANGE_TYPE_BUTTON_TEXT = AuthoringUIResources.changeTypeButton_text; //$NON-NLS-1$	

	public static final String CLEAR_BUTTON_TEXT = AuthoringUIResources.clearButton_text; //$NON-NLS-1$

	public static final String DELETE_BUTTON_TEXT = AuthoringUIResources.deleteButton_text; //$NON-NLS-1$

	public static final String DESELECT_BUTTON_TEXT = AuthoringUIResources.deselectButton_text; //$NON-NLS-1$

	public static final String DETACH_BUTTON_TEXT = AuthoringUIResources.detachButton_text; //$NON-NLS-1$	

	public static final String DOWN_BUTTON_TEXT = AuthoringUIResources.downButton_text; //$NON-NLS-1$	

	public static final String ORDER_BUTTON_TEXT = AuthoringUIResources.orderButton_text; //$NON-NLS-1$

	public static final String EDIT_BUTTON_TEXT = AuthoringUIResources.editButton_text; //$NON-NLS-1$
	
	public static final String REMOVE_BUTTON_TEXT = AuthoringUIResources.removeButton_text; //$NON-NLS-1$

	public static final String SELECT_BUTTON_TEXT = AuthoringUIResources.selectButton_text; //$NON-NLS-1$

	public static final String UP_BUTTON_TEXT = AuthoringUIResources.upButton_text; //$NON-NLS-1$

	public static final String VIEW_HISTORY_BUTTON_TEXT = AuthoringUIResources.viewHistoryButton_text; //$NON-NLS-1$

	public static final String ALWAYS_BUTTON_TEXT = MessageDialogWithToggle.ALWAYS;

	public static final String NEVER_BUTTON_TEXT = MessageDialogWithToggle.NEVER;

	public static final String PROMPT_BUTTON_TEXT = MessageDialogWithToggle.PROMPT;

}
