//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;


/**
 * Copies an element in the Library view.
 * 
 * @author Phong Nguyen Le
 * @since 1.0
 */
public class LibraryViewCopyAction extends CopyAction {

	public void run() {
		if (command == null)
			return;
		else {
			if (domain instanceof TraceableAdapterFactoryEditingDomain) {
				((TraceableAdapterFactoryEditingDomain) domain).resetCopyMaps();
			}
			super.run();
		}
	}

	public boolean updateSelection(IStructuredSelection selection) {
		if (selection == null || selection.isEmpty())
			return false;

		Collection collection = new ArrayList();
		for (Iterator objects = selection.iterator(); objects.hasNext();) {
			Object element = TngUtil.unwrap(objects.next());
			if (element instanceof MethodElement
					&& !(element instanceof MethodPlugin)
					&& !TngUtil.isPredefined((MethodElement) element)) {
				collection.add(element);
			}

		}

		command = createCommand(collection);

		return command.canExecute();
	}

}
