//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.actions;

import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;


public class LibraryViewFindElementAction extends BaseSelectionListenerAction {

	/**
	 * The ID for this action.
	 */
	public static final String ACTION_ID = LibraryViewFindElementAction.class
			.getName();
	
	private LibraryView targetView;
	private IStructuredSelection selected;

	
	public LibraryViewFindElementAction(String text) {
		super(text);
	}

	public void run() {
		if (targetView == null)
			targetView = LibraryView.getView();
		// select currentSelection in Lib View
		if (targetView != null && selected != null && !selected.isEmpty()) {
			targetView.setSelectionToViewer(selected.getFirstElement());
		}
	}

	protected boolean updateSelection(IStructuredSelection selection) {
		selected = selection;
		if (selection != null && !selection.isEmpty()) {
			Object element = selection.getFirstElement();
			Object realObj = TngUtil.unwrap(element);
			if (realObj instanceof MethodElement) {
				return true;
			}
		}
		return false;
	}
}
