//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;


/**
 * Pastes an element from the clipboard to the Library view.
 * 
 * @author Phong Nguyen Le
 * @since 1.0
 */
public class LibraryViewPasteAction extends PasteAction implements
		ILibraryAction {

	private IProgressMonitor progressMonitor;

	public void run() {
		LibraryLockingOperationRunner runner = new LibraryLockingOperationRunner();
		runner.setProgressMonitor(getProgressMonitor());
		runner.run(new IRunnableWithProgress() {

			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				performPaste();
			}
			
		});
	}
	
	protected void performPaste() {
		if(command instanceof PasteFromClipboardCommand) {
			PasteFromClipboardCommand cmd = ((PasteFromClipboardCommand)command);
			Object owner = cmd.getOwner();
			if(owner instanceof Adapter) {
				owner = ((Adapter)owner).getTarget();
			}
			
			// check target for modifiable
			//
			if(owner instanceof EObject) {
				IStatus status = UserInteractionHelper.checkModify((EObject) owner, MsgBox.getDefaultShell());
				if (!status.isOK()) {
					AuthoringUIPlugin.getDefault().getMsgDialog().displayError(
							getText(), null, status);
					return;
				}
			}			
		}
		
		if (command == null)
			return;
		else
			super.run();
	}

	public boolean updateSelection(IStructuredSelection selection) {
		if (selection.size() < 1)
			return false;
		else {
			Object[] objs = selection.toArray();
			for (int i = 0; i < objs.length; i++) {
				if (objs[i] instanceof MethodPlugin)
					return false;
			}
		}

		return super.updateSelection(selection);
	}
	
	/**
	 * @see org.eclipse.jface.action.Action#firePropertyChange(String, Object,
	 *      Object)
	 */
	public void notifyPropertyChange(String propertyName, Object oldValue,
			Object newValue) {
		super.firePropertyChange(propertyName, oldValue, newValue);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.epf.authoring.ui.actions.ILibraryAction#setProgressMonitor(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void setProgressMonitor(IProgressMonitor monitor) {
		progressMonitor = monitor;
	}

	/**
	 * @return the progressMonitor
	 */
	protected IProgressMonitor getProgressMonitor() {
		if(progressMonitor == null) {
			progressMonitor = new NullProgressMonitor();
		}
		return progressMonitor;
	}
}
