//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationWizard;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

/**
 * Displays the New Method Configuration wizard.
 * 
 * @author Bingxue Xu
 * @author Kelvin Low
 * @since 1.0
 */
public class NewConfigurationAction extends Action implements
		IWorkbenchWindowActionDelegate {

	/**
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init()
	 */
	public void init(IWorkbenchWindow window) {
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		Display.getCurrent().asyncExec(new Runnable() {
			public void run() {
				MethodLibrary targetLib = LibraryService.getInstance()
						.getCurrentMethodLibrary();
				if (targetLib == null) {
					AuthoringUIPlugin
							.getDefault()
							.getMsgDialog()
							.displayError(
									AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title, //$NON-NLS-1$
									AuthoringUIResources.noOpenLibraryError_msg); //$NON-NLS-1$
					return;
				}

				Shell shell = Display.getCurrent().getActiveShell();
				IStatus status = UserInteractionHelper.checkModify(targetLib,
						shell);
				if (!status.isOK()) {
					AuthoringUIPlugin
							.getDefault()
							.getMsgDialog()
							.display(
									AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title, //$NON-NLS-1$
									AuthoringUIResources.newConfigurationWirazd_createError, //$NON-NLS-1$ 
									status);
					return;
				}

				MethodConfiguration config = createConfiguration();
				if (config == null) {
					return;
				}

				if (!PerspectiveListUtil.isAuthoringPerspective()) {
					UIActionDispatcher.openAuthoringPerspective();
				}
				EditorChooser.getInstance().openEditor(config);
			}
		});
	}

	/**
	 * @see org.eclipse.jface.action.Action#run()
	 */
	public void run() {
		run(null);
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
	}

	/**
	 * Displays the wizard and creates a new configuration when the user selects
	 * the Finish button.
	 */
	private MethodConfiguration createConfiguration() {
		MethodConfiguration config = null;

		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();
		LibraryLocationData llData = new LibraryLocationData();

		try {
			llData.setOkPressed(false);

			NewConfigurationWizard wizard = new NewConfigurationWizard(llData);
			WizardDialog dialog = new WizardDialog(Display.getCurrent()
					.getActiveShell(), wizard);
			dialog.create();
			dialog.open();

			if (!llData.isOkPressed())
				return null;

			String configName = llData.getLibName().trim();
			if (activePage != null) {
				if (configName != null) {
					config = LibraryService.getInstance()
							.createMethodConfiguration(
									configName,
									LibraryService.getInstance()
											.getCurrentMethodLibrary());
					config.setBriefDescription(llData.getLibBriefDescription());
				}
			}
		} catch (Exception e) {
			AuthoringUIPlugin
					.getDefault()
					.getMsgDialog()
					.displayError(
							AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title, //$NON-NLS-1$
							AuthoringUIResources.internalError_msg, //$NON-NLS-1$
							e);
		}

		return config;
	}

}
