//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.wizards.OpenConfigurationWizard;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;


/**
 * @author Jinhua Xi
 * @since 1.0
 * 
 */
public class OpenConfigurationAction implements IWorkbenchWindowActionDelegate {
	// private static String DEFAULT_PERSPECTIVE_ID = null;

	// private IWorkbenchWindow window;

	private IStructuredSelection selection;

	private List configList = new ArrayList();

	public void init(IWorkbenchWindow window) {
		// this.window = window;
	}

	public void run(IAction action) {
		Display.getCurrent().asyncExec(new Runnable() {
			public void run() {
				configList.clear();
				doWork();
				if (configList.size() > 0) {
					if (!PerspectiveListUtil.isAuthoringPerspective()) {
						System.out
								.println("$$$DEBUG: Need to switch to authoring perspective!"); //$NON-NLS-1$
						UIActionDispatcher.openAuthoringPerspective();
					}
					for (int i = 0; i < configList.size(); i++) {
						MethodConfiguration config = (MethodConfiguration) configList
								.get(i);
						// System.out.println("$$$DEBUG: config name = " +
						// config.getName());
						EditorChooser.getInstance().openEditor(config);
					}
				}
			}
		});
	}

	public void dispose() {
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

	private void doWork() {
		try {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();
			if (activePage != null) {

				OpenConfigurationWizard wizard = new OpenConfigurationWizard(
						configList);
				wizard.init(PlatformUI.getWorkbench(), selection); // probably
				// no need for this line
				// Instantiates the wizard container with the wizard and opens
				// it
				WizardDialog dialog = new WizardDialog(Display.getCurrent()
						.getActiveShell(), wizard);
				dialog.create();
				dialog.open();

				// for (int i=0; i<configList.size(); i++) {
				// MethodConfiguration config =
				// (MethodConfiguration)configList.get(i);
				// System.out.println(config.getName());
				// }

			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

}
