//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.actions;

import java.util.Properties;

import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.wizards.NewMethodPluginWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

/**
 * New Method plugin UI wizard
 * 
 * @author Bingxue Xu
 * @since 1.0
 * 
 */
public class OpenNewMethodPluginWizardAction extends Action implements
		IIntroAction {

	public void run(IIntroSite site, Properties params) {

		String toggle_str = params.getProperty("toggle"); //$NON-NLS-1$
		// de-maximaize the welcome, i.e. the intro view window
		if (toggle_str != null && toggle_str.equalsIgnoreCase("true")) { //$NON-NLS-1$
			toggleActiveView();
		}

		if (!PerspectiveListUtil.isAuthoringPerspective()) {
			// System.out.println("Need to switch to authoring perspective!");
			UIActionDispatcher.openAuthoringPerspective();
		}

		NewMethodPluginWizard wizard = new NewMethodPluginWizard();
		wizard.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow()
				.getWorkbench(), (IStructuredSelection) null);

		// Instantiates the wizard container with the wizard and opens it
		WizardDialog dialog = new WizardDialog(Display.getCurrent()
				.getActiveShell(), wizard);
		dialog.create();
		dialog.open();

	}

	private void toggleActiveView() {
		IWorkbenchWindow activeWindow = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();

		// de-maximaize the welcome, i.e. the intro view window or any active
		// view
		IWorkbenchPage page = activeWindow.getActivePage();
		if (page != null) {
			if (page instanceof WorkbenchPage) {
				// WorkbenchPage realPage = (WorkbenchPage) page;

				IWorkbenchPartReference partRef = page.getActivePartReference();

				if (partRef != null) {
					((WorkbenchPage) page).toggleZoom(partRef);
				}
			}
		}
	}
}
