//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.actions;

import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ShowPresentationNames implements IViewActionDelegate {

	private LibraryView targetView;

	public void init(IViewPart view) {
		targetView = (LibraryView) view;

	}

	public void run(IAction action) {
		PresentationContext.INSTANCE.setShowPresentationNames(!PresentationContext.INSTANCE.isShowPresentationNames());
		targetView.getViewer().refresh();
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

}
