//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.dnd;

import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/**
 * The drag adapter for the Library Viewer.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class LibraryViewerDragAdapter extends ViewerDragAdapter {

	/**
	 * Creates a new <code>EditorDragAdapter</code>.
	 */
	public LibraryViewerDragAdapter(Viewer viewer) {
		super(viewer);
	}

	/**
	 * Called when dragging is initiated.
	 */
	public void dragStart(DragSourceEvent event) {
		super.dragStart(event);
		event.doit = !viewer.getSelection().isEmpty();
	}

	/**
	 * Called to transfer the data.
	 */
	public void dragSetData(DragSourceEvent event) {
		if (HTMLTransfer.getInstance().isSupportedType(event.dataType)) {
			IStructuredSelection selection = (IStructuredSelection) viewer
					.getSelection();
			Object[] selectedElements = selection.toList().toArray(
					new Object[selection.size()]);
			if (selectedElements != null && selectedElements.length > 0) {
				Object selectedElement = TngUtil.unwrap(selectedElements[0]);
				if (selectedElement instanceof MethodElement) {
					event.data = getHyperlink((MethodElement) selectedElement);
				}
			}
		} else {
			super.dragSetData(event);
		}
	}

	/**
	 * Returns the hyperlink for the given Method element.
	 */
	protected String getHyperlink(MethodElement dragElement) {
		MethodElement dropElement = null;
		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();
		IEditorPart activeEditor = activePage.getActiveEditor();
		if (activeEditor != null) {
			IEditorInput editorInput = activeEditor.getEditorInput();
			if (editorInput instanceof MethodElementEditorInput) {
				dropElement = ((MethodElementEditorInput) editorInput)
						.getMethodElement();
			}
		}
		
		if(dragElement instanceof ProcessComponent){
			dragElement = ((ProcessComponent)dragElement).getProcess();
		}

		String href = ResourceHelper.getUrl(dragElement, dropElement, ".html"); //$NON-NLS-1$
		return ResourceHelper.getElementLink(dragElement, true,
				"file://" + href); //$NON-NLS-1$
	}

}
