//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.editors;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.forms.ConfigViewPage;
import org.eclipse.epf.authoring.ui.forms.ConfigurationDescription;
import org.eclipse.epf.authoring.ui.forms.ConfigurationPage;
import org.eclipse.epf.library.configuration.ConfigurationClosure;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.ui.PartInitException;


/**
 * The Method Configuration editor.
 * 
 * @author Shilpa Toraskar
 * @author Kelvin Low
 * @since 1.0
 */
public class ConfigurationEditor extends MethodElementEditor {

	/**
	 * The editor ID.
	 */
	public static final String EDITOR_ID = ConfigurationEditor.class.getName();

	ConfigurationPage configPage = null;

	/**
	 * Creates a new instance.
	 */
	public ConfigurationEditor() {
		super();
	}

	/**
	 * Returns the method configuration associated with this editor.
	 */
	public MethodConfiguration getConfiguration() {
		return ((ConfigurationEditorInput) super.getEditorInput())
				.getConfiguration();
	}

	/**
	 * @see org.eclipse.ui.forms.editor.FormEditor#addPages()
	 */
	protected void addPages() {
		try {
			addPage(new ConfigurationDescription(this));
			configPage = new ConfigurationPage(this);
			addPage(configPage);
			addPage(new ConfigViewPage(this));
		} catch (PartInitException e) {
			AuthoringUIPlugin.getDefault().getLogger().logError(e);
		}
	}

	/**
	 * @org.eclipse.epf.authoring.ui.editors.MethodElementEditor#dispose()
	 */
	public void dispose() {
		super.dispose();
	}

	public ConfigurationClosure getClosure() {
		return configPage.getClosure();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.epf.authoring.ui.editors.MethodElementEditor#createInput(org.eclipse.epf.uma.MethodElement)
	 */
	protected MethodElementEditorInput createInput(MethodElement e) {
		if(e instanceof MethodConfiguration) {
			return new ConfigurationEditorInput((MethodConfiguration) e);
		}
		return null;
	}

}
