//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.actions.MethodAddImageAction;
import org.eclipse.epf.authoring.ui.actions.MethodAddLinkAction;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.IRichTextToolBar;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.actions.AddOrderedListAction;
import org.eclipse.epf.richtext.actions.AddTableAction;
import org.eclipse.epf.richtext.actions.AddUnorderedListAction;
import org.eclipse.epf.richtext.actions.BoldAction;
import org.eclipse.epf.richtext.actions.ClearContentAction;
import org.eclipse.epf.richtext.actions.CopyAction;
import org.eclipse.epf.richtext.actions.CutAction;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.actions.FontStyleAction;
import org.eclipse.epf.richtext.actions.IndentAction;
import org.eclipse.epf.richtext.actions.ItalicAction;
import org.eclipse.epf.richtext.actions.OutdentAction;
import org.eclipse.epf.richtext.actions.PasteAction;
import org.eclipse.epf.richtext.actions.SubscriptAction;
import org.eclipse.epf.richtext.actions.SuperscriptAction;
import org.eclipse.epf.richtext.actions.UnderlineAction;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.swt.widgets.Composite;


/**
 * A Rich Text editor with added extensions to support Method browsing and
 * authoring. Includes a tool bar and an integrated HTML source editor.
 * 
 * @author Kelvin Low
 * @since 1.0
 */
public class MethodRichTextEditor extends RichTextEditor implements
		IMethodRichTextEditor {

	// The method element associated with this rich text control.
	private MethodElement methodElement;

	// The modal object associated with this rich text control.
	private EObject modalObject;

	// The modal object feature associated with this rich text control.
	private EStructuralFeature modalObjectFeature;

	/**
	 * Creates a new instance.
	 * 
	 * @param parent
	 *            The parent control.
	 * @param style
	 *            The initial style for the editor.
	 * @param basePath
	 *            The base path used for resolving hrefs.
	 */
	public MethodRichTextEditor(Composite parent, int style, String basePath,
			MethodElement methodElement) {
		super(parent, style, basePath);
		this.methodElement = methodElement;
		((MethodRichText) richText).setMethodElement(methodElement);
	}

	/**
	 * Creates the underlying rich text control.
	 * 
	 * @param parent
	 *            The parent composite.
	 * @param style
	 *            The style for this control.
	 * @param basePath
	 *            The path used for resolving links.
	 */
	protected IRichText createRichTextControl(Composite parent, int style,
			String basePath) {
		return new MethodRichText(parent, style, basePath, methodElement);
	}

	/**
	 * Fills the Rich Text editor tool bar with action items.
	 * 
	 * @param toolBar
	 *            The Rich text editor tool bar.
	 */
	public void fillToolBar(IRichTextToolBar toolBar) {
		toolBar.addAction(new FontStyleAction());
		toolBar.addAction(new CutAction());
		toolBar.addAction(new CopyAction());
		toolBar.addAction(new PasteAction());
		toolBar.addSeparator();
		toolBar.addAction(new ClearContentAction());
		toolBar.addSeparator();
		toolBar.addAction(new BoldAction());
		toolBar.addAction(new ItalicAction());
		toolBar.addAction(new UnderlineAction());
		toolBar.addSeparator();
		toolBar.addAction(new SubscriptAction());
		toolBar.addAction(new SuperscriptAction());
		toolBar.addSeparator();
		toolBar.addAction(new AddOrderedListAction());
		toolBar.addAction(new AddUnorderedListAction());
		toolBar.addSeparator();
		toolBar.addAction(new OutdentAction());
		toolBar.addAction(new IndentAction());
		toolBar.addSeparator();
		toolBar.addAction(new FindReplaceAction());
		toolBar.addSeparator();
		toolBar.addAction(new MethodAddLinkAction());
		toolBar.addAction(new MethodAddImageAction());
		toolBar.addAction(new AddTableAction());
	}

	/**
	 * Returns the method element associated with this rich text control.
	 */
	public MethodElement getMethodElement() {
		return methodElement;
	}

	/**
	 * Returns the modal object associated with this rich text control.
	 */
	public EObject getModalObject() {
		return modalObject;
	}

	/**
	 * Sets the modal object associated with this rich text control.
	 */
	public void setModalObject(EObject modalObject) {
		this.modalObject = modalObject;
	}

	/**
	 * Returns modal object feature associated with this rich text control.
	 */
	public EStructuralFeature getModalObjectFeature() {
		return modalObjectFeature;
	}

	/**
	 * Sets the modal object feature associated with this rich text control.
	 */
	public void setModalObjectFeature(EStructuralFeature modalObjectFeature) {
		this.modalObjectFeature = modalObjectFeature;
	}

}
