//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.filters;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.viewers.Viewer;


/**
 * @author Shashidhar Kannoori
 * @since 1.0
 */
public class DescriptorConfigurationFilter extends ConfigurationFilter {

	String filterStr;

	MethodConfiguration methodConfiguration;

	protected FilterHelper helper;

	/**
	 * @param methodConfig
	 * @param viewer
	 */
	public DescriptorConfigurationFilter(MethodConfiguration methodConfig,
			Viewer viewer, String filterStr) {
		super(methodConfig, viewer);
		this.filterStr = filterStr;
		this.methodConfiguration = methodConfig;
	}

	public boolean accept(Object obj) {

		if (obj instanceof MethodConfiguration) {
			return methodConfiguration.equals(obj);
		}

		if (!super.accept(obj))
			return false;
		if (helper.isShowPresentationName()) {
			if (!helper.matchPatternOnPresentationName(obj))
				return false;
		} else {
			if (!helper.matchPattern(obj))
				return false;
		}
		if (!helper.isObjectInSelectedItems(obj))
			return false;
		if (childAccept(obj))
			return true;
		return false;

	}

	public java.util.Collection getChildren(Object obj,
			org.eclipse.emf.ecore.EStructuralFeature childFeature) {
		// return super.getChildren(obj, childFeature);
		// Modified code to handle the filtering
		// to check if the variability of parent is not N/A, filter out already
		// exisitng
		// element from children list.
		Collection col = super.getChildren(obj, childFeature);
		if(col != null){
		for (Iterator itor = col.iterator(); itor.hasNext();) {
			Object element = itor.next();
			if (!accept(element))
				itor.remove();
		}
		}else{
			col = Collections.EMPTY_LIST;
		}

		return col;
	}

	public boolean childAccept(Object obj) {
		return false;
	}

	public void setHelper(FilterHelper helper) {
		this.helper = helper;
	}
	
	public void setMethodConfiguration(MethodConfiguration config)
	{
		super.setMethodConfiguration(config);
		this.methodConfiguration = config;
	}

}
