//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;

import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.CategoryFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;


/**
 * The Role Sets page in the Role Set Grouping editor.
 * 
 * @author Shashidhar Kannoori
 * @author Kelvin Low
 * @since 1.0
 * 
 * TODO: Rename this class to RoleSetGroupingRoleSetsPage and move it to the
 * om.ibm.rmc.authoring.ui.util.forms package
 */
public class RoleSetGroupingRoleSets extends AssociationFormPage {

	private static final String FORM_PAGE_ID = "roleSetGroupingRoleSetsPage"; //$NON-NLS-1$

	private RoleSetGrouping roleSetGrouping;

	/**
	 * Creates a new instance.
	 */
	public RoleSetGroupingRoleSets(FormEditor editor) {
		super(editor, FORM_PAGE_ID, AuthoringUIText.ROLE_SETS_PAGE_TITLE);
	}

	/**
	 * @see org.eclipse.ui.forms.editor.init(IEditorSite, IEditorInput)
	 */
	public void init(IEditorSite site, IEditorInput input) {
		super.init(site, input);
		roleSetGrouping = (RoleSetGrouping) contentElement;
		setUseCategory2(false);
		setUseCategory3(false);
		setAllowChange1(true);
	}

	/**
	 * @see org.eclipse.epf.authoring.ui.forms.AssociationFormPage#initContentProviderSelected()
	 */
	protected void initContentProviderSelected() {
		contentProviderSelected = new AdapterFactoryContentProvider(
				TngAdapterFactory.INSTANCE
						.getNavigatorView_ComposedAdapterFactory()) {
			public Object[] getElements(Object object) {
				return ((RoleSetGrouping) object).getRoleSets().toArray();
			}
		};
		viewer_selected.setContentProvider(contentProviderSelected);
	}

	/**
	 * @see org.eclipse.epf.authoring.ui.forms.AssociationFormPage#addItemsToModel1(ArrayList)
	 */
	protected void addItemsToModel1(ArrayList addItems) {
		// Update the model.
		if (!addItems.isEmpty()) {
			editor.getActionManager().doAction(IActionManager.ADD_MANY,
					roleSetGrouping,
					UmaPackage.eINSTANCE.getRoleSetGrouping_RoleSets(),
					addItems, -1);
		}
	}

	/**
	 * @see org.eclipse.epf.authoring.ui.forms.AssociationFormPage#removeItemsFromModel1(ArrayList)
	 */
	protected void removeItemsFromModel1(ArrayList rmItems) {
		// Update the model.
		if (!rmItems.isEmpty()) {
			editor.getActionManager().doAction(IActionManager.REMOVE_MANY,
					roleSetGrouping,
					UmaPackage.eINSTANCE.getRoleSetGrouping_RoleSets(),
					rmItems, -1);
		}
	}

	/**
	 * @see org.eclipse.epf.authoring.ui.forms.DescriptionFormPage#getContentElement()
	 */
	protected Object getContentElement() {
		return roleSetGrouping;
	}

	/**
	 * @see org.eclipse.epf.authoring.ui.forms.DescriptionFormPage#getTabString()
	 */
	protected String getTabString() {
		return FilterConstants.ROLESETS;
	}

	/**
	 * @see org.eclipse.epf.authoring.ui.forms.DescriptionFormPage#getFilter()
	 */
	protected IFilter getFilter() {
		return filter = new CategoryFilter() {
			protected boolean childAccept(Object obj) {
				return (obj instanceof RoleSet);
			}
		};
	}
	protected String getMultipleSelectDescription(int count) {
		return super.getMultipleSelectDescription(count, AuthoringUIResources.roleSetGroupingRoleSetsPage_multipleSelectDescription);
	}
	
	protected String getSectionDescription() {
		return AuthoringUIResources.roleSetGroupingRoleSetsPage_sectionDescription;
	}

	protected String getSectionName() {
		return AuthoringUIResources.roleSetGroupingRoleSetsPage_sectionName;
	}

	protected String getSelectedLabel() {
		return AuthoringUIResources.roleSetGroupingRoleSetsPage_selectedLabel;
	}
	
	protected String getSelectedLabel2() {
		return AuthoringUIResources.roleSetGroupingRoleSetsPage_selectedLabel;
	}
	
	protected String getSelectedLabel3() {
		return AuthoringUIResources.roleSetGroupingRoleSetsPage_selectedLabel;
	}
}
