//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.preferences;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;


/**
 * Preference page for debug options
 * 
 * @author Shilpa Toraskar
 * @since 1.0
 * 
 */
public class DebugPrefPage extends CommonPrefPage implements
		IWorkbenchPreferencePage {

	int NUM_COLUMN = 3;

	private Composite composite_tab;

	// private IWorkbench workbench;

	private Button enableHealthCheck;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent) {

		// composite_tab << parent
		composite_tab = createComposite(parent, NUM_COLUMN);

		createLabel(composite_tab, " ", NUM_COLUMN); //$NON-NLS-1$

		enableHealthCheck = new Button(composite_tab, SWT.CHECK);
		enableHealthCheck.setText(AuthoringUIResources.enableHealthCheck_text); //$NON-NLS-1$

		createLabel(composite_tab, " ", NUM_COLUMN); //$NON-NLS-1$
		createLine(composite_tab, NUM_COLUMN);

		initializeValues();

		return composite_tab;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
		// this.workbench = workbench;
	}

	/*
	 * (non-Javadoc) Method declared on PreferencePage
	 */
	protected void performDefaults() {
		super.performDefaults();
		initializeDefaults();
	}

	/*
	 * (non-Javadoc) Method declared on PreferencePage
	 */
	public boolean performOk() {
		storeValues();
		LibraryPlugin.getDefault().savePluginPreferences();

		return true;
	}

	protected IPreferenceStore doGetPreferenceStore() {

		return LibraryPlugin.getDefault().getPreferenceStore();

	}

	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		IPreferenceStore store = getPreferenceStore();

		store.setValue(ApplicationPreferenceConstants.PREF_ENABLE_HEALTH_CHECK,
				enableHealthCheck.getSelection());
	}

	/**
	 * Initializes states of the controls using default values in the preference
	 * store.
	 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();

		enableHealthCheck
				.setSelection(store
						.getDefaultBoolean(ApplicationPreferenceConstants.PREF_ENABLE_HEALTH_CHECK));
	}

	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		IPreferenceStore store = getPreferenceStore();
		enableHealthCheck
				.setSelection(store
						.getBoolean(ApplicationPreferenceConstants.PREF_ENABLE_HEALTH_CHECK));
	}

	private Composite createComposite(Composite parent, int numColumns) {

		Composite composite = new Composite(parent, SWT.NULL);

		// GridLayout
		GridLayout layout = new GridLayout();
		layout.numColumns = numColumns;
		layout.marginHeight = layout.marginWidth = 0;
		composite.setLayout(layout);

		// GridData
		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		composite.setLayoutData(data);

		return composite;
	}
}
