//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.prefs.LibraryPreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;


/**
 * @author BingXue Xu
 * @since 1.0
 */
public class LibraryPreferenceInitializer extends AbstractPreferenceInitializer {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		// These settings will show up when the Library preference page
		// is shown for the first time.

		IPreferenceStore store = LibraryPlugin.getDefault()
				.getPreferenceStore();
		// IPreferenceStore store =
		// PlatformUI.getWorkbench().getPreferenceStore();
		store.setDefault(LibraryPreferenceConstants.PREF_RADIO_SAVE_CHOICE, 1);
		store.setDefault(LibraryPreferenceConstants.PREF_BACK_UP_BEFORE_SAVE,
				false);
	}

}
