//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.preferences;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;


/**
 * Startup preference page
 * 
 * @author Bingxue Xu
 * @since 1.0
 * 
 */
public class StartupPrefPage extends CommonPrefPage implements
		IWorkbenchPreferencePage, SelectionListener, ModifyListener {

	Composite composite_tab;

	int ncol = 3;

	private Button ctrl_startupPrompt;

	protected Control createContents(Composite parent) {

		composite_tab = createGridComposite(parent, ncol);

		createLabel(composite_tab, " ", ncol); //$NON-NLS-1$

		ctrl_startupPrompt = new Button(composite_tab, SWT.CHECK);
		ctrl_startupPrompt.setText(AuthoringUIResources.promptforlibary_text); //$NON-NLS-1$

		createLabel(composite_tab, " ", ncol); //$NON-NLS-1$
		createLine(composite_tab, ncol);

		initializeValues();

		return composite_tab;
	}

	public void init(IWorkbench workbench) {
	}

	public void widgetSelected(SelectionEvent e) {
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

	public void modifyText(ModifyEvent e) {
	}

	/*
	 * (non-Javadoc) Method declared on PreferencePage
	 */
	protected void performDefaults() {
		super.performDefaults();
		initializeDefaults();
	}

	/*
	 * (non-Javadoc) Method declared on PreferencePage
	 */
	public boolean performOk() {
		storeValues();
		LibraryUIPlugin.getDefault().savePluginPreferences();
		return true;
	}

	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		// IPreferenceStore store = getPreferenceStore();
		// store.setValue(LibraryPreferenceConstants.PREF_PROMPT_FOR_LIBRARY_AT_STARTUP,
		// ctrl_startupPrompt.getSelection());
		LibraryUIPreferences
				.setPromptForMethodLibraryAtStartup(ctrl_startupPrompt
						.getSelection());
	}

	private void initializeDefaults() {
		// IPreferenceStore store = getPreferenceStore();
		ctrl_startupPrompt.setSelection(true);
	}

	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		// IPreferenceStore store = getPreferenceStore();
		// ctrl_startupPrompt.setSelection(store.getBoolean(LibraryPreferenceConstants.PREF_PROMPT_FOR_LIBRARY_AT_STARTUP));
		ctrl_startupPrompt.setSelection(LibraryUIPreferences
				.getPromptForMethodLibraryAtStartup());
	}

	protected IPreferenceStore doGetPreferenceStore() {
		return LibraryUIPlugin.getDefault().getPreferenceStore();
	}

}
