//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.forms.ProcessBreakdownStructureFormPage;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/**
 * This class represents property sheet page for process elements
 * 
 * @author Shilpa Toraskar
 * @since 1.0
 * 
 */
public class EPFPropertySheetPage extends TabbedPropertySheetPage {
	// private TabbedPropertyViewer viewer;

	private IPropertySheetEntry rootEntry;

	private static IPropertySourceProvider sourceProvider;

	private static ISelection selection = null;

	private static IActionManager actionMgr;

	private static ProcessEditor processEditor;

	public static String formPageID = null;
	
	private static ProcessBreakdownStructureFormPage formPage = null;

	// public static int currentPage=0;

	public EPFPropertySheetPage(ProcessEditor editor) {
		super((ITabbedPropertySheetPageContributor) editor);

		actionMgr = ((ProcessEditor) editor).getActionManager();
		processEditor = editor;

	}

	public static IActionManager getActionManager() {
		return actionMgr;
	}

	public static ProcessEditor getEditor() {
		return processEditor;
	}

	/**
	 * Sets the given property source provider as the property source provider.
	 * <p>
	 * Calling this method is only valid if you are using this page's default
	 * root entry.
	 * </p>
	 * 
	 * @param newProvider
	 *            the property source provider
	 */
	public void setPropertySourceProvider(IPropertySourceProvider newProvider) {
		sourceProvider = newProvider;
		if (rootEntry == null) {
			// create a new root
			PropertySheetEntry root = new PropertySheetEntry();

			rootEntry = root;
		}
		if (sourceProvider != null) {
			// set the property source provider for root entry
			if (rootEntry instanceof PropertySheetEntry) {
				((PropertySheetEntry) rootEntry)
						.setPropertySourceProvider(sourceProvider);
			}
		}
	}

	public static IPropertySourceProvider getPropertySourceProvider() {
		return sourceProvider;
	}

	public static ISelection getSelection() {
		return selection;
	}

	/**
	 * @see org.eclipse.ui.ISelectionListener#selectionChanged(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection sel) {
		selection = sel;

		if (part instanceof ProcessEditor) {
			processEditor = (ProcessEditor) part;
			// currentPage = processFormEditor.getCurrentPage();
			actionMgr = processEditor.getActionManager();
			IFormPage activePage = processEditor.getActivePageInstance();
			if (activePage instanceof ProcessBreakdownStructureFormPage)
				formPage = (ProcessBreakdownStructureFormPage) activePage;
			formPageID = activePage != null ? activePage.getId() : null;
		}

		super.selectionChanged(part, selection);
	}

	public void handlePartActivated(IWorkbenchPart part) {
		if (part instanceof ProcessEditor) {
			processEditor = (ProcessEditor) part;
			selection = processEditor.getSelection();
			actionMgr = processEditor.getActionManager();
			IFormPage activePage = processEditor.getActivePageInstance();
			if (activePage instanceof ProcessBreakdownStructureFormPage)
				formPage = (ProcessBreakdownStructureFormPage) activePage;
			formPageID = activePage != null ? activePage.getId() : null;
		}

		super.handlePartActivated(part);
	}

	public static AdapterFactory getAdapterFactory() {
		return formPage.getAdapterFactory();
//		if (formPageID.equals(ProcessEditor.WBS_FORM_ID)) {
//			return TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
//		} else if (formPageID.equals(ProcessEditor.TA_FORM_ID)) {
//			return TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
//		} else if (formPageID.equals(ProcessEditor.WPBS_FORM_ID)) {
//			return TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
//		} else if (formPageID.equals(ProcessEditor.CONSOLIDATED_FORM_ID)) {
//			return TngAdapterFactory.INSTANCE
//					.getProcessComposedAdapterFactory();
//		}

//		return null;
	}

	public void refresh() {

		// will see if this works..
		try
		{
			super.refresh();
		}
		catch (Exception e)
		{
			
		}
		
//		 TODO - get rid of internal APIs.
//		if (this.getCurrentTab() != null) {
//			this.getCurrentTab().refresh();
//
//			// also refresh section
//			ISection section = this.getCurrentTab().getSectionAtIndex(0);
//			if (section != null) {
//				section.refresh();
//			}
//		}
	}

}
