//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.providers;

import org.eclipse.core.resources.IResource;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

/**
 * @author Phong Nguyen Le - May 11, 2006
 * @since  1.0
 */
public class MethodElementLabelDecorator implements ILabelDecorator {
	private static ILabelDecorator delegateDecorator;
	
	private static ILabelDecorator getDelegateDecorator() {
		if (delegateDecorator == null) {
			delegateDecorator = IDEWorkbenchPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
		}
		return delegateDecorator;
	}
	
	private static IResource getWorkspaceResource(Object element) {
		element = TngUtil.unwrap(element);
		if(element instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory) element)) {
			// don't decorate icon of root custom category that is shown as UI folder "Custom Categories"
			// in library view
			//
			return null;
		}
		return PersistenceUtil.getWorkspaceResource(element);
	}
	
	public MethodElementLabelDecorator() {
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelDecorator#decorateImage(org.eclipse.swt.graphics.Image, java.lang.Object)
	 */
	public Image decorateImage(Image image, Object element) {		
		IResource wsRes = getWorkspaceResource(element);
		if(wsRes != null) {
			return getDelegateDecorator().decorateImage(image, wsRes);
		}
		return image;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelDecorator#decorateText(java.lang.String, java.lang.Object)
	 */
	public String decorateText(String text, Object element) {
		return text;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		getDelegateDecorator().addListener(listener);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		IResource wsRes = getWorkspaceResource(element);
		if(wsRes != null) {
			return getDelegateDecorator().isLabelProperty(wsRes, property);
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		getDelegateDecorator().removeListener(listener);
	}

}
