//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.wizards;

import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;


/**
 * The label provider for the Configuration table in the Open Configuration
 * wizard.
 * 
 * @author Bingxue Xu
 * @since 1.0
 */
public class ConfigurationTableLabelProvider extends LabelProvider implements
		ITableLabelProvider {

	public Image getColumnImage(Object element, int index) {
		return null;
	}

	public String getColumnText(Object element, int index) {
		MethodConfiguration config = (MethodConfiguration) element;
		return config.getName();
	}

}
