//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.wizards;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;


/**
 * A wizard page that prompts the user to enter a name and description for a
 * new Method Configuration.
 * 
 * @author Bingxue Xu
 * @author Kelvin Low
 * @since 1.0
 */
public class NewConfigurationMainPage extends WizardPage implements Listener {

	/**
	 * The wizard page name.
	 */	
	public static final String PAGE_NAME = NewConfigurationMainPage.class
			.getName();

	private Text nameText, descText;

	/**
	 * Creates a new instance.
	 */
	public NewConfigurationMainPage() {
		super(PAGE_NAME);
		setTitle(AuthoringUIResources.AuthoringUIPlugin_NewConfigurationMainPage_pageTitle); //$NON-NLS-1$);
		setDescription(AuthoringUIResources.AuthoringUIPlugin_NewConfigurationMainPage_pageDescription); //$NON-NLS-1$
		setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor(
				"full/wizban/New.gif")); //$NON-NLS-1$		
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		GridData labelGridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(3, false));
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label nameLabel = new Label(composite, SWT.NONE);
		nameLabel.setText(AuthoringUIText.NAME_TEXT);
		nameLabel.setLayoutData(labelGridData);
		nameText = new Text(composite, SWT.BORDER);
		nameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		((GridData) nameText.getLayoutData()).horizontalSpan = 2;

		Label briefDescLabel = new Label(composite, SWT.NONE);
		briefDescLabel.setText(AuthoringUIText.DESCRIPTION_TEXT);
		briefDescLabel.setLayoutData(labelGridData);
		descText = new Text(composite, SWT.BORDER | SWT.MULTI | SWT.WRAP
				| SWT.V_SCROLL);
		descText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		((GridData) descText.getLayoutData()).horizontalSpan = 2;
		((GridData) descText.getLayoutData()).heightHint = 70;
		((GridData) descText.getLayoutData()).widthHint = 480;

		initDataFromDTO();

		addListeners();

		setControl(composite);
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {
		setPageComplete(isPageComplete());

		if (event.widget == nameText && event.type == SWT.FocusOut) {
			nameText.setText(StrUtil.makeValidFileName(nameText.getText()));
		}
		if (event.widget == descText && event.type == SWT.FocusOut) {
			descText.setText(StrUtil.getPlainText(descText.getText()));
		}

		getWizard().getContainer().updateButtons();
	}

	/**
	 * @see org.eclipse.jface.wizard.WizardPage.isCompleted()
	 */
	public boolean isPageComplete() {
		NewConfigurationWizard wizard = (NewConfigurationWizard) getWizard();

		if (isTextNonEmpty(nameText)) {
			wizard.okToComplete = true;
			return true;
		}

		wizard.okToComplete = false;
		return false;
	}

	private void initDataFromDTO() {
		descText
				.setText(AuthoringUIResources.AuthoringUIPlugin_NewConfigurationMainPage_DefaultBriefDescription); //$NON-NLS-1$
	}

	void saveDataToDTO(NewConfigurationWizard wizard) {
		wizard.llData.setLibName(nameText.getText().trim());
		wizard.llData.setLibBriefDescription(descText.getText().trim());
	}

	private void addListeners() {
		nameText.addListener(SWT.Modify, this);
		nameText.addListener(SWT.FocusOut, this);
		descText.addListener(SWT.Modify, this);
		descText.addListener(SWT.FocusOut, this);
	}

	private static boolean isTextNonEmpty(Text t) {
		String s = t.getText();
		if ((s != null) && (s.trim().length() > 0))
			return true;
		return false;
	}

}
