//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.wizards;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/**
 * A wizard that guides the user to create a new Method Configuration.
 * 
 * @author Bingxue Xu
 * @author Kelvin Low
 * @since 1.0
 */
public class NewConfigurationWizard extends Wizard implements INewWizard {

	protected NewConfigurationMainPage mainPage;

	protected boolean okToComplete = false;

	protected LibraryLocationData llData;

	/**
	 * Creates a new instance.
	 */
	public NewConfigurationWizard(LibraryLocationData llData) {
		super();
		this.llData = llData;
		setWindowTitle(AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench,
	 *      IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	public void addPages() {
		mainPage = new NewConfigurationMainPage();
		addPage(mainPage);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#canFinish()
	 */
	public boolean canFinish() {
		return okToComplete;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		mainPage.saveDataToDTO(this);
		llData.setOkPressed(true);

		// Check for duplicate configuration name.
		if (configNameExists(llData.getLibName().trim())) {
			llData.setOkPressed(false);
			return false;
		}

		return true;
	}

	private boolean configNameExists(String configName) {
		String[] configNames = LibraryServiceUtil
				.getMethodConfigurationNames(LibraryService.getInstance()
						.getCurrentMethodLibrary());
		for (int i = 0; i < configNames.length; i++) {
			if (configName.equals(configNames[i])) {
				AuthoringUIPlugin
						.getDefault()
						.getMsgDialog()
						.displayError(
								AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title, //$NON-NLS-1$				
								AuthoringUIResources.bind(AuthoringUIResources.duplicateElementNameError_msg, configName)); //$NON-NLS-1$
				return true;
			}
		}
		return false;
	}

}
