//------------------------------------------------------------------------------
// Copyright (c) 2005, 2006 IBM Corporation and others.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// IBM Corporation - initial implementation
//------------------------------------------------------------------------------
package org.eclipse.epf.authoring.ui.wizards;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

/**
 * A wizard page that prompts the user to select a Method Configuration to open.
 * 
 * @author Bingxue Xu
 * @since 1.0
 */
public class OpenConfigurationMainPage extends WizardPage implements
		ICheckStateListener, Listener {

	/**
	 * The wizard page name.
	 */
	public static final String PAGE_NAME = OpenConfigurationMainPage.class
			.getName();

	private CheckboxTableViewer tableViewer;

	private Table table;

	private int checkedCount = 0;

	/**
	 * Creates a new instance.
	 */
	public OpenConfigurationMainPage(String pageName, String title,
			ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
		setTitle(AuthoringUIResources.AuthoringUIPlugin_OpenConfigurationMainPage_pageTitle); //$NON-NLS-1$
		setDescription(AuthoringUIResources.AuthoringUIPlugin_OpenConfigurationMainPage_pageDescription); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.jface.viewers.ICheckStateListener#checkStateChanged(CheckStateChangedEvent)
	 */
	public void checkStateChanged(CheckStateChangedEvent event) {
		Object obj = event.getElement();

		OpenConfigurationWizard wizard = (OpenConfigurationWizard) getWizard();
		if (event.getChecked()) {
			checkedCount++;
			wizard.configurations.add(obj);
		} else {
			checkedCount--;
			wizard.configurations.remove(obj);
		}

		setPageComplete(isPageComplete());
		getWizard().getContainer().updateButtons();
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {
		setPageComplete(isPageComplete());
		getWizard().getContainer().updateButtons();
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizardPage#isPageComplete()
	 */
	public boolean isPageComplete() {
		OpenConfigurationWizard wizard = (OpenConfigurationWizard) getWizard();

		if (checkedCount > 0) {
			wizard.okToComplete = true;
			return true;
		}

		wizard.okToComplete = false;
		return false;
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		// Create the composite to hold the widgets.
		Composite composite = new Composite(parent, SWT.NULL);

		// Create the desired layout for this wizard page.
		composite.setLayout(new GridLayout(3, false));

		// Add an empty line first.
		Label emptyLine = new Label(composite, SWT.NONE);
		emptyLine.setText("   "); //$NON-NLS-1$
		{
			GridData gridData = new GridData(GridData.BEGINNING
					| GridData.FILL_BOTH);
			gridData.horizontalSpan = 3;
			emptyLine.setLayoutData(gridData);
		}

		new Label(composite, SWT.NONE).setText("   "); //$NON-NLS-1$

		table = new Table(composite, SWT.CHECK);
		{
			GridData gridData = new GridData(GridData.BEGINNING
					| GridData.FILL_BOTH);
			gridData.heightHint = 300;
			table.setLayoutData(gridData);
		}
		tableViewer = new CheckboxTableViewer(table);
		tableViewer.setLabelProvider(new ConfigurationTableLabelProvider());
		tableViewer.setContentProvider(new ArrayContentProvider());
		MethodConfiguration[] configs = LibraryServiceUtil
				.getMethodConfigurations(LibraryService.getInstance()
						.getCurrentMethodLibrary());
		tableViewer.setInput(configs);

		tableViewer.addCheckStateListener(this);

		// Set the composite as the control for this page.
		setControl(composite);
	}

}
